/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.changelog.ChangelogStateBackendHandle;

@NotThreadSafe
class ChangelogStateBackendMetricGroup
extends ProxyMetricGroup<MetricGroup> {
    private static final String PREFIX = "ChangelogStateBackend";
    @VisibleForTesting
    static final String LATEST_FULL_SIZE_OF_MATERIALIZATION = "ChangelogStateBackend.lastFullSizeOfMaterialization";
    @VisibleForTesting
    static final String LATEST_INC_SIZE_OF_MATERIALIZATION = "ChangelogStateBackend.lastIncSizeOfMaterialization";
    @VisibleForTesting
    static final String LATEST_FULL_SIZE_OF_NON_MATERIALIZATION = "ChangelogStateBackend.lastFullSizeOfNonMaterialization";
    @VisibleForTesting
    static final String LATEST_INC_SIZE_OF_NON_MATERIALIZATION = "ChangelogStateBackend.lastIncSizeOfNonMaterialization";
    private long lastFullSizeOfMaterialization;
    private long lastIncSizeOfMaterialization;
    private long lastFullSizeOfNonMaterialization;
    private long lastIncSizeOfNonMaterialization;

    ChangelogStateBackendMetricGroup(MetricGroup parentMetricGroup) {
        super(parentMetricGroup);
        this.gauge(LATEST_FULL_SIZE_OF_MATERIALIZATION, () -> this.lastFullSizeOfMaterialization);
        this.gauge(LATEST_INC_SIZE_OF_MATERIALIZATION, () -> this.lastIncSizeOfMaterialization);
        this.gauge(LATEST_FULL_SIZE_OF_NON_MATERIALIZATION, () -> this.lastFullSizeOfNonMaterialization);
        this.gauge(LATEST_INC_SIZE_OF_NON_MATERIALIZATION, () -> this.lastIncSizeOfNonMaterialization);
        this.setSize(0L, 0L, 0L, 0L);
    }

    synchronized void reportSnapshotResult(SnapshotResult<ChangelogStateBackendHandle> snapshotResult) {
        ChangelogStateBackendHandle changelogStateBackendHandle = (ChangelogStateBackendHandle)snapshotResult.getJobManagerOwnedSnapshot();
        if (changelogStateBackendHandle == null) {
            this.setSize(0L, 0L, 0L, 0L);
        } else {
            this.setSize(this.sumStateSize(changelogStateBackendHandle.getMaterializedStateHandles()), this.sumCheckpointSize(changelogStateBackendHandle.getMaterializedStateHandles()), this.sumStateSize(changelogStateBackendHandle.getNonMaterializedStateHandles()), this.sumCheckpointSize(changelogStateBackendHandle.getNonMaterializedStateHandles()));
        }
    }

    private long sumStateSize(List<? extends KeyedStateHandle> keyedStateHandles) {
        return keyedStateHandles.stream().mapToLong(StateObject::getStateSize).sum();
    }

    private long sumCheckpointSize(List<? extends KeyedStateHandle> keyedStateHandles) {
        return keyedStateHandles.stream().mapToLong(CompositeStateHandle::getCheckpointedSize).sum();
    }

    private void setSize(long lastFullSizeOfMaterialization, long lastIncSizeOfMaterialization, long lastFullSizeOfNonMaterialization, long lastIncSizeOfNonMaterialization) {
        this.lastFullSizeOfMaterialization = lastFullSizeOfMaterialization;
        this.lastIncSizeOfMaterialization = lastIncSizeOfMaterialization;
        this.lastFullSizeOfNonMaterialization = lastFullSizeOfNonMaterialization;
        this.lastIncSizeOfNonMaterialization = lastIncSizeOfNonMaterialization;
    }
}

