/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Optional;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBListState;
import org.apache.flink.contrib.streaming.state.RocksDBMapState;
import org.apache.flink.runtime.state.StateSnapshotTransformer;

abstract class RocksDBSnapshotTransformFactoryAdaptor<SV, SEV>
implements StateSnapshotTransformer.StateSnapshotTransformFactory<SV> {
    final StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory;

    RocksDBSnapshotTransformFactoryAdaptor(StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) {
        this.snapshotTransformFactory = snapshotTransformFactory;
    }

    public Optional<StateSnapshotTransformer<SV>> createForDeserializedState() {
        throw new UnsupportedOperationException("Only serialized state filtering is supported in RocksDB backend");
    }

    static <SV, SEV> StateSnapshotTransformer.StateSnapshotTransformFactory<SV> wrapStateSnapshotTransformFactory(StateDescriptor<?, SV> stateDesc, StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory, TypeSerializer<SV> stateSerializer) {
        if (stateDesc instanceof ListStateDescriptor) {
            TypeSerializer elementSerializer = ((ListSerializer)stateSerializer).getElementSerializer();
            return new RocksDBListStateSnapshotTransformFactory(snapshotTransformFactory, elementSerializer);
        }
        if (stateDesc instanceof MapStateDescriptor) {
            return new RocksDBMapStateSnapshotTransformFactory(snapshotTransformFactory);
        }
        return new RocksDBValueStateSnapshotTransformFactory(snapshotTransformFactory);
    }

    private static class RocksDBListStateSnapshotTransformFactory<SV, SEV>
    extends RocksDBSnapshotTransformFactoryAdaptor<SV, SEV> {
        private final TypeSerializer<SEV> elementSerializer;

        private RocksDBListStateSnapshotTransformFactory(StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory, TypeSerializer<SEV> elementSerializer) {
            super(snapshotTransformFactory);
            this.elementSerializer = elementSerializer;
        }

        public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState() {
            return this.snapshotTransformFactory.createForDeserializedState().map(est -> new RocksDBListState.StateSnapshotTransformerWrapper(est, this.elementSerializer.duplicate()));
        }
    }

    private static class RocksDBMapStateSnapshotTransformFactory<SV, SEV>
    extends RocksDBSnapshotTransformFactoryAdaptor<SV, SEV> {
        private RocksDBMapStateSnapshotTransformFactory(StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) {
            super(snapshotTransformFactory);
        }

        public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState() {
            return this.snapshotTransformFactory.createForSerializedState().map(RocksDBMapState.StateSnapshotTransformerWrapper::new);
        }
    }

    private static class RocksDBValueStateSnapshotTransformFactory<SV, SEV>
    extends RocksDBSnapshotTransformFactoryAdaptor<SV, SEV> {
        private RocksDBValueStateSnapshotTransformFactory(StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) {
            super(snapshotTransformFactory);
        }

        public Optional<StateSnapshotTransformer<byte[]>> createForSerializedState() {
            return this.snapshotTransformFactory.createForSerializedState();
        }
    }
}

