/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.streaming.api.datastream.CoGroupedStreams;
import org.apache.flink.testutils.DeeplyEqualsChecker;

class UnionSerializerTest
extends SerializerTestBase<CoGroupedStreams.TaggedUnion<Object, Object>> {
    public UnionSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof CoGroupedStreams.TaggedUnion && o2 instanceof CoGroupedStreams.TaggedUnion, (o1, o2, checker) -> {
            CoGroupedStreams.TaggedUnion union1 = (CoGroupedStreams.TaggedUnion)o1;
            CoGroupedStreams.TaggedUnion union2 = (CoGroupedStreams.TaggedUnion)o2;
            if (union1.isOne() && union2.isOne()) {
                return checker.deepEquals(union1.getOne(), union2.getOne());
            }
            if (union1.isTwo() && union2.isTwo()) {
                return checker.deepEquals(union1.getTwo(), union2.getTwo());
            }
            return false;
        }));
    }

    protected TypeSerializer<CoGroupedStreams.TaggedUnion<Object, Object>> createSerializer() {
        return new CoGroupedStreams.UnionSerializer((TypeSerializer)new KryoSerializer(Object.class, new ExecutionConfig()), (TypeSerializer)new KryoSerializer(Object.class, new ExecutionConfig()));
    }

    protected int getLength() {
        return -1;
    }

    protected Class<CoGroupedStreams.TaggedUnion<Object, Object>> getTypeClass() {
        return CoGroupedStreams.TaggedUnion.class;
    }

    protected CoGroupedStreams.TaggedUnion<Object, Object>[] getTestData() {
        return new CoGroupedStreams.TaggedUnion[]{CoGroupedStreams.TaggedUnion.one((Object)1), CoGroupedStreams.TaggedUnion.two((Object)"A"), CoGroupedStreams.TaggedUnion.one((Object)"C")};
    }
}

