/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SlotAllocationTest
extends TestLogger {
    @Test
    public void testTwoPipelines() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        FilterFunction<Long> dummyFilter = new FilterFunction<Long>(){

            public boolean filter(Long value) {
                return false;
            }
        };
        env.generateSequence(1L, 10L).filter((FilterFunction)dummyFilter).slotSharingGroup("isolated").filter((FilterFunction)dummyFilter).slotSharingGroup("default").disableChaining().filter((FilterFunction)dummyFilter).slotSharingGroup("group 1").filter((FilterFunction)dummyFilter).startNewChain().print().disableChaining();
        env.generateSequence(1L, 10L).filter((FilterFunction)dummyFilter).slotSharingGroup("isolated-2").filter((FilterFunction)dummyFilter).slotSharingGroup("default").disableChaining().filter((FilterFunction)dummyFilter).slotSharingGroup("group 2").filter((FilterFunction)dummyFilter).startNewChain().print().disableChaining();
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        Assert.assertEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(3)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(2)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(4)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(5)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(6)).getSlotSharingGroup());
        int pipelineStart = 6;
        Assert.assertEquals((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(pipelineStart + 2)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(pipelineStart + 1)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(pipelineStart + 2)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(pipelineStart + 3)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(pipelineStart + 3)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(pipelineStart + 4)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(pipelineStart + 4)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(pipelineStart + 5)).getSlotSharingGroup());
    }

    @Test
    public void testUnion() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        FilterFunction<Long> dummyFilter = new FilterFunction<Long>(){

            public boolean filter(Long value) {
                return false;
            }
        };
        DataStreamSource src1 = env.generateSequence(1L, 10L);
        SingleOutputStreamOperator src2 = env.generateSequence(1L, 10L).slotSharingGroup("src-1");
        src1.union(new DataStream[]{src2}).filter((FilterFunction)dummyFilter);
        SingleOutputStreamOperator src3 = env.generateSequence(1L, 10L).slotSharingGroup("group-1");
        SingleOutputStreamOperator src4 = env.generateSequence(1L, 10L).slotSharingGroup("group-1");
        src3.union(new DataStream[]{src4}).filter((FilterFunction)dummyFilter);
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        Assert.assertEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(1)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(3)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
    }

    @Test
    public void testInheritOverride() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        FilterFunction<Long> dummyFilter = new FilterFunction<Long>(){

            public boolean filter(Long value) {
                return false;
            }
        };
        SingleOutputStreamOperator src1 = env.generateSequence(1L, 10L).slotSharingGroup("group-1");
        SingleOutputStreamOperator src2 = env.generateSequence(1L, 10L).slotSharingGroup("group-1");
        src1.union(new DataStream[]{src2}).filter((FilterFunction)dummyFilter).slotSharingGroup("default");
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        Assert.assertEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(1)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(2)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(2)).getSlotSharingGroup());
    }

    @Test
    public void testCoOperation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        CoMapFunction<Long, Long, Long> dummyCoMap = new CoMapFunction<Long, Long, Long>(){

            public Long map1(Long value) throws Exception {
                return null;
            }

            public Long map2(Long value) throws Exception {
                return null;
            }
        };
        DataStreamSource src1 = env.generateSequence(1L, 10L);
        SingleOutputStreamOperator src2 = env.generateSequence(1L, 10L).slotSharingGroup("src-1");
        src1.connect((DataStream)src2).map((CoMapFunction)dummyCoMap);
        SingleOutputStreamOperator src3 = env.generateSequence(1L, 10L).slotSharingGroup("group-1");
        SingleOutputStreamOperator src4 = env.generateSequence(1L, 10L).slotSharingGroup("group-1");
        src3.connect((DataStream)src4).map((CoMapFunction)dummyCoMap);
        JobGraph jobGraph = env.getStreamGraph().getJobGraph();
        List vertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        Assert.assertEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(0)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(1)).getSlotSharingGroup());
        Assert.assertNotEquals((Object)((JobVertex)vertices.get(1)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(4)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(3)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(2)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
        Assert.assertEquals((Object)((JobVertex)vertices.get(3)).getSlotSharingGroup(), (Object)((JobVertex)vertices.get(5)).getSlotSharingGroup());
    }
}

