/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.operators.sort.FixedLengthByteKeyComparator;
import org.apache.flink.streaming.api.operators.sort.KeyAndValueSerializer;
import org.apache.flink.streaming.api.operators.sort.SerializerComparatorTestData;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

class FixedLengthByteKeyComparatorTest
extends ComparatorTestBase<Tuple2<byte[], StreamRecord<Integer>>> {
    FixedLengthByteKeyComparatorTest() {
    }

    protected Order[] getTestedOrder() {
        return new Order[]{Order.ASCENDING};
    }

    protected TypeComparator<Tuple2<byte[], StreamRecord<Integer>>> createComparator(boolean ascending) {
        return new FixedLengthByteKeyComparator(new IntSerializer().getLength());
    }

    protected TypeSerializer<Tuple2<byte[], StreamRecord<Integer>>> createSerializer() {
        IntSerializer intSerializer = new IntSerializer();
        return new KeyAndValueSerializer((TypeSerializer)intSerializer, intSerializer.getLength());
    }

    protected void deepEquals(String message, Tuple2<byte[], StreamRecord<Integer>> should, Tuple2<byte[], StreamRecord<Integer>> is) {
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])((byte[])is.f0)).as(message, new Object[0])).isEqualTo(should.f0);
        ((ObjectAssert)Assertions.assertThat((Object)is.f1).as(message, new Object[0])).isEqualTo(should.f1);
    }

    protected Tuple2<byte[], StreamRecord<Integer>>[] getSortedTestData() {
        return SerializerComparatorTestData.getOrderedIntTestData();
    }
}

