/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import java.io.IOException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

final class SerializerComparatorTestData {
    static Tuple2<byte[], StreamRecord<Integer>>[] getOrderedIntTestData() {
        IntSerializer intSerializer = new IntSerializer();
        DataOutputSerializer outputSerializer = new DataOutputSerializer(intSerializer.getLength());
        return (Tuple2[])IntStream.range(-10, 10).mapToObj(idx -> {
            try {
                intSerializer.serialize(Integer.valueOf(idx), (DataOutputView)outputSerializer);
                byte[] copyOfBuffer = outputSerializer.getCopyOfBuffer();
                outputSerializer.clear();
                return Tuple2.of((Object)copyOfBuffer, (Object)new StreamRecord((Object)idx, (long)idx));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }).toArray(Tuple2[]::new);
    }

    static Tuple2<byte[], StreamRecord<String>>[] getOrderedStringTestData() {
        StringSerializer stringSerializer = new StringSerializer();
        DataOutputSerializer outputSerializer = new DataOutputSerializer(64);
        return (Tuple2[])Stream.of(new String(new byte[]{-1, 0}), new String(new byte[]{0, 1}), "A", "AB", "ABC", "ABCD", "ABCDE", "ABCDEF", "ABCDEFG", "ABCDEFGH").map(str -> {
            try {
                stringSerializer.serialize(str, (DataOutputView)outputSerializer);
                byte[] copyOfBuffer = outputSerializer.getCopyOfBuffer();
                outputSerializer.clear();
                return Tuple2.of((Object)copyOfBuffer, (Object)new StreamRecord(str, 0L));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }).sorted((o1, o2) -> {
            byte[] key0 = (byte[])o1.f0;
            byte[] key1 = (byte[])o2.f0;
            int firstLength = key0.length;
            int secondLength = key1.length;
            int minLength = Math.min(firstLength, secondLength);
            for (int i = 0; i < minLength; ++i) {
                int cmp = Byte.compare(key0[i], key1[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            int lengthCmp = Integer.compare(firstLength, secondLength);
            if (lengthCmp != 0) {
                return lengthCmp;
            }
            return Long.compare(((StreamRecord)o1.f1).getTimestamp(), ((StreamRecord)o2.f1).getTimestamp());
        }).toArray(Tuple2[]::new);
    }

    private SerializerComparatorTestData() {
    }
}

