/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.windowing.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.RichAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.RichWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalAggregateProcessAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalAggregateProcessWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableProcessAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableProcessWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueProcessAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueProcessWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.streaming.util.functions.StreamingFunctionUtils;
import org.apache.flink.util.Collector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.AllOf;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class InternalWindowFunctionTest {
    @Test
    public void testInternalIterableAllWindowFunction() throws Exception {
        AllWindowFunctionMock mock = (AllWindowFunctionMock)((Object)Mockito.mock(AllWindowFunctionMock.class));
        InternalIterableAllWindowFunction windowFunction = new InternalIterableAllWindowFunction((AllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Iterable i = (Iterable)Mockito.mock(Iterable.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process(Byte.valueOf((byte)0), (Window)w, ctx, i, c);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply(w, (Iterable<Long>)i, (Collector<String>)c);
        windowFunction.close();
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalIterableProcessAllWindowFunction() throws Exception {
        ProcessAllWindowFunctionMock mock = (ProcessAllWindowFunctionMock)((Object)Mockito.mock(ProcessAllWindowFunctionMock.class));
        InternalIterableProcessAllWindowFunction windowFunction = new InternalIterableProcessAllWindowFunction((ProcessAllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Iterable i = (Iterable)Mockito.mock(Iterable.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process(Byte.valueOf((byte)0), (Window)w, ctx, i, c);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).process((ProcessAllWindowFunction.Context)Mockito.anyObject(), (Iterable)Mockito.eq((Object)i), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalIterableWindowFunction() throws Exception {
        WindowFunctionMock mock = (WindowFunctionMock)((Object)Mockito.mock(WindowFunctionMock.class));
        InternalIterableWindowFunction windowFunction = new InternalIterableWindowFunction((WindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Iterable i = (Iterable)Mockito.mock(Iterable.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process((Object)42L, (Window)w, ctx, i, c);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply(Mockito.eq((long)42L), (TimeWindow)Mockito.eq((Object)w), (Iterable<Long>)((Iterable)Mockito.eq((Object)i)), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalIterableProcessWindowFunction() throws Exception {
        ProcessWindowFunctionMock mock = (ProcessWindowFunctionMock)((Object)Mockito.mock(ProcessWindowFunctionMock.class));
        InternalIterableProcessWindowFunction windowFunction = new InternalIterableProcessWindowFunction((ProcessWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Iterable i = (Iterable)Mockito.mock(Iterable.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        ((ProcessWindowFunctionMock)((Object)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ProcessWindowFunction.Context c = (ProcessWindowFunction.Context)invocationOnMock.getArguments()[1];
                c.currentProcessingTime();
                c.currentWatermark();
                c.windowState();
                c.globalState();
                return null;
            }
        }).when((Object)mock))).process(Mockito.eq((long)42L), (ProcessWindowFunction.Context)Mockito.anyObject(), (Iterable<Long>)((Iterable)Mockito.eq((Object)i)), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.process((Object)42L, (Window)w, ctx, i, c);
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).currentProcessingTime();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).currentWatermark();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).windowState();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).globalState();
        windowFunction.close();
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalSingleValueWindowFunction() throws Exception {
        WindowFunctionMock mock = (WindowFunctionMock)((Object)Mockito.mock(WindowFunctionMock.class));
        InternalSingleValueWindowFunction windowFunction = new InternalSingleValueWindowFunction((WindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process((Object)42L, (Window)w, ctx, (Object)23L, c);
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply(Mockito.eq((long)42L), (TimeWindow)Mockito.eq((Object)w), (Iterable<Long>)((Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{23L}))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((WindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalSingleValueAllWindowFunction() throws Exception {
        AllWindowFunctionMock mock = (AllWindowFunctionMock)((Object)Mockito.mock(AllWindowFunctionMock.class));
        InternalSingleValueAllWindowFunction windowFunction = new InternalSingleValueAllWindowFunction((AllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process(Byte.valueOf((byte)0), (Window)w, ctx, (Object)23L, c);
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).apply((TimeWindow)Mockito.eq((Object)w), (Iterable<Long>)((Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{23L}))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((AllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalSingleValueProcessAllWindowFunction() throws Exception {
        ProcessAllWindowFunctionMock mock = (ProcessAllWindowFunctionMock)((Object)Mockito.mock(ProcessAllWindowFunctionMock.class));
        InternalSingleValueProcessAllWindowFunction windowFunction = new InternalSingleValueProcessAllWindowFunction((ProcessAllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process(Byte.valueOf((byte)0), (Window)w, ctx, (Object)23L, c);
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).process((ProcessAllWindowFunction.Context)Mockito.anyObject(), (Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{23L})), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((ProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalSingleValueProcessWindowFunction() throws Exception {
        ProcessWindowFunctionMock mock = (ProcessWindowFunctionMock)((Object)Mockito.mock(ProcessWindowFunctionMock.class));
        InternalSingleValueProcessWindowFunction windowFunction = new InternalSingleValueProcessWindowFunction((ProcessWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        ((ProcessWindowFunctionMock)((Object)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ProcessWindowFunction.Context c = (ProcessWindowFunction.Context)invocationOnMock.getArguments()[1];
                c.currentProcessingTime();
                c.currentWatermark();
                c.windowState();
                c.globalState();
                return null;
            }
        }).when((Object)mock))).process(Mockito.eq((long)42L), (ProcessWindowFunction.Context)Mockito.anyObject(), (Iterable<Long>)((Iterable)MockitoHamcrest.argThat((Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{23L}))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.process((Object)42L, (Window)w, ctx, (Object)23L, c);
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).currentProcessingTime();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).currentWatermark();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).windowState();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).globalState();
        windowFunction.close();
        ((ProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalAggregateProcessWindowFunction() throws Exception {
        AggregateProcessWindowFunctionMock mock = (AggregateProcessWindowFunctionMock)((Object)Mockito.mock(AggregateProcessWindowFunctionMock.class));
        InternalAggregateProcessWindowFunction windowFunction = new InternalAggregateProcessWindowFunction((AggregateFunction)new AggregateFunction<Long, Set<Long>, Map<Long, Long>>(){
            private static final long serialVersionUID = 1L;

            public Set<Long> createAccumulator() {
                return new HashSet<Long>();
            }

            public Set<Long> add(Long value, Set<Long> accumulator) {
                accumulator.add(value);
                return accumulator;
            }

            public Map<Long, Long> getResult(Set<Long> accumulator) {
                HashMap<Long, Long> result = new HashMap<Long, Long>();
                for (Long in : accumulator) {
                    result.put(in, in);
                }
                return result;
            }

            public Set<Long> merge(Set<Long> a, Set<Long> b) {
                a.addAll(b);
                return a;
            }
        }, (ProcessWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((AggregateProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((AggregateProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((AggregateProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        LinkedList<Long> args = new LinkedList<Long>();
        args.add(23L);
        args.add(24L);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        ((AggregateProcessWindowFunctionMock)((Object)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ProcessWindowFunction.Context c = (ProcessWindowFunction.Context)invocationOnMock.getArguments()[1];
                c.currentProcessingTime();
                c.currentWatermark();
                c.windowState();
                c.globalState();
                return null;
            }
        }).when((Object)mock))).process(Mockito.eq((long)42L), (ProcessWindowFunction.Context)Mockito.anyObject(), (Iterable<Map<Long, Long>>)((Iterable)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Matcher)AllOf.allOf((Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)23L), (Matcher)CoreMatchers.is((Object)23L)), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)24L), (Matcher)CoreMatchers.is((Object)24L)))))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.process((Object)42L, (Window)w, ctx, args, c);
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).currentProcessingTime();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).currentWatermark();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).windowState();
        ((InternalWindowFunction.InternalWindowContext)Mockito.verify((Object)ctx)).globalState();
        windowFunction.close();
        ((AggregateProcessWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    @Test
    public void testInternalAggregateProcessAllWindowFunction() throws Exception {
        AggregateProcessAllWindowFunctionMock mock = (AggregateProcessAllWindowFunctionMock)((Object)Mockito.mock(AggregateProcessAllWindowFunctionMock.class));
        InternalAggregateProcessAllWindowFunction windowFunction = new InternalAggregateProcessAllWindowFunction((AggregateFunction)new AggregateFunction<Long, Set<Long>, Map<Long, Long>>(){
            private static final long serialVersionUID = 1L;

            public Set<Long> createAccumulator() {
                return new HashSet<Long>();
            }

            public Set<Long> add(Long value, Set<Long> accumulator) {
                accumulator.add(value);
                return accumulator;
            }

            public Map<Long, Long> getResult(Set<Long> accumulator) {
                HashMap<Long, Long> result = new HashMap<Long, Long>();
                for (Long in : accumulator) {
                    result.put(in, in);
                }
                return result;
            }

            public Set<Long> merge(Set<Long> a, Set<Long> b) {
                a.addAll(b);
                return a;
            }
        }, (ProcessAllWindowFunction)mock);
        BasicTypeInfo stringType = BasicTypeInfo.STRING_TYPE_INFO;
        ExecutionConfig execConf = new ExecutionConfig();
        execConf.setParallelism(42);
        StreamingFunctionUtils.setOutputType((Function)windowFunction, (TypeInformation)stringType, (ExecutionConfig)execConf);
        ((AggregateProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setOutputType((TypeInformation<String>)stringType, execConf);
        Configuration config = new Configuration();
        windowFunction.open(config);
        ((AggregateProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).open(config);
        RuntimeContext rCtx = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        windowFunction.setRuntimeContext(rCtx);
        ((AggregateProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).setRuntimeContext(rCtx);
        TimeWindow w = (TimeWindow)Mockito.mock(TimeWindow.class);
        Collector c = (Collector)Mockito.mock(Collector.class);
        LinkedList<Long> args = new LinkedList<Long>();
        args.add(23L);
        args.add(24L);
        InternalWindowFunction.InternalWindowContext ctx = (InternalWindowFunction.InternalWindowContext)Mockito.mock(InternalWindowFunction.InternalWindowContext.class);
        windowFunction.process(Byte.valueOf((byte)0), (Window)w, ctx, args, c);
        ((AggregateProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).process((ProcessAllWindowFunction.Context)Mockito.anyObject(), (Iterable)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Matcher)AllOf.allOf((Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)23L), (Matcher)CoreMatchers.is((Object)23L)), (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)24L), (Matcher)CoreMatchers.is((Object)24L))))), (Collector<String>)((Collector)Mockito.eq((Object)c)));
        windowFunction.close();
        ((AggregateProcessAllWindowFunctionMock)((Object)Mockito.verify((Object)((Object)mock)))).close();
    }

    private static class ProcessAllWindowFunctionMock
    extends ProcessAllWindowFunction<Long, String, TimeWindow>
    implements OutputTypeConfigurable<String> {
        private static final long serialVersionUID = 1L;

        private ProcessAllWindowFunctionMock() {
        }

        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void process(ProcessAllWindowFunction.Context context, Iterable<Long> input, Collector<String> out) throws Exception {
        }
    }

    private static class AllWindowFunctionMock
    extends RichAllWindowFunction<Long, String, TimeWindow>
    implements OutputTypeConfigurable<String> {
        private static final long serialVersionUID = 1L;

        private AllWindowFunctionMock() {
        }

        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void apply(TimeWindow window, Iterable<Long> values, Collector<String> out) throws Exception {
        }
    }

    private static class WindowFunctionMock
    extends RichWindowFunction<Long, String, Long, TimeWindow>
    implements OutputTypeConfigurable<String> {
        private static final long serialVersionUID = 1L;

        private WindowFunctionMock() {
        }

        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void apply(Long aLong, TimeWindow w, Iterable<Long> input, Collector<String> out) throws Exception {
        }
    }

    private static class AggregateProcessAllWindowFunctionMock
    extends ProcessAllWindowFunction<Map<Long, Long>, String, TimeWindow>
    implements OutputTypeConfigurable<String> {
        private static final long serialVersionUID = 1L;

        private AggregateProcessAllWindowFunctionMock() {
        }

        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void process(ProcessAllWindowFunction.Context context, Iterable<Map<Long, Long>> input, Collector<String> out) throws Exception {
        }
    }

    private static class AggregateProcessWindowFunctionMock
    extends ProcessWindowFunction<Map<Long, Long>, String, Long, TimeWindow>
    implements OutputTypeConfigurable<String> {
        private static final long serialVersionUID = 1L;

        private AggregateProcessWindowFunctionMock() {
        }

        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void process(Long aLong, ProcessWindowFunction.Context context, Iterable<Map<Long, Long>> elements, Collector<String> out) throws Exception {
        }
    }

    private static class ProcessWindowFunctionMock
    extends ProcessWindowFunction<Long, String, Long, TimeWindow>
    implements OutputTypeConfigurable<String> {
        private static final long serialVersionUID = 1L;

        private ProcessWindowFunctionMock() {
        }

        public void setOutputType(TypeInformation<String> outTypeInfo, ExecutionConfig executionConfig) {
        }

        public void process(Long aLong, ProcessWindowFunction.Context context, Iterable<Long> elements, Collector<String> out) throws Exception {
        }
    }
}

