/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.BitSet;
import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.junit.Assert;
import org.junit.Test;

public class KeyMapPutTest {
    @Test
    public void testPutUniqueKeysAndGrowth() {
        try {
            int i;
            KeyMap map = new KeyMap();
            int numElements = 1000000;
            for (i = 0; i < 1000000; ++i) {
                map.put((Object)i, (Object)(2 * i + 1));
                Assert.assertEquals((long)(i + 1), (long)map.size());
                Assert.assertTrue((map.getCurrentTableCapacity() > map.size() ? 1 : 0) != 0);
                Assert.assertTrue((map.getCurrentTableCapacity() > map.getRehashThreshold() ? 1 : 0) != 0);
                Assert.assertTrue((map.size() <= map.getRehashThreshold() ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)1000000L, (long)map.size());
            Assert.assertEquals((long)1000000L, (long)map.traverseAndCountElements());
            Assert.assertEquals((long)0x200000L, (long)map.getCurrentTableCapacity());
            for (i = 0; i < 1000000; ++i) {
                Assert.assertEquals((long)(2 * i + 1), (long)((Integer)map.get((Object)i)).intValue());
            }
            for (i = 999999; i >= 0; --i) {
                Assert.assertEquals((long)(2 * i + 1), (long)((Integer)map.get((Object)i)).intValue());
            }
            BitSet bitset = new BitSet();
            int numContained = 0;
            for (KeyMap.Entry entry : map) {
                ++numContained;
                Assert.assertEquals((long)((Integer)entry.getKey() * 2 + 1), (long)((Integer)entry.getValue()).intValue());
                Assert.assertFalse((boolean)bitset.get((Integer)entry.getKey()));
                bitset.set((Integer)entry.getKey());
            }
            Assert.assertEquals((long)1000000L, (long)numContained);
            Assert.assertEquals((long)1000000L, (long)bitset.cardinality());
            Assert.assertEquals((long)1000000L, (long)map.size());
            Assert.assertEquals((long)1000000L, (long)map.traverseAndCountElements());
            Assert.assertEquals((long)0x200000L, (long)map.getCurrentTableCapacity());
            Assert.assertTrue((map.getLongestChainLength() <= 7 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutDuplicateKeysAndGrowth() {
        try {
            Integer put;
            int i;
            KeyMap map = new KeyMap();
            int numElements = 1000000;
            for (i = 0; i < 1000000; ++i) {
                put = (Integer)map.put((Object)i, (Object)(2 * i + 1));
                Assert.assertNull((Object)put);
            }
            for (i = 0; i < 1000000; i += 3) {
                put = (Integer)map.put((Object)i, (Object)(2 * i));
                Assert.assertNotNull((Object)put);
                Assert.assertEquals((long)(2 * i + 1), (long)put.intValue());
            }
            for (i = 0; i < 1000000; ++i) {
                int expected = i % 3 == 0 ? 2 * i : 2 * i + 1;
                Assert.assertEquals((long)expected, (long)((Integer)map.get((Object)i)).intValue());
            }
            Assert.assertEquals((long)1000000L, (long)map.size());
            Assert.assertEquals((long)1000000L, (long)map.traverseAndCountElements());
            Assert.assertEquals((long)0x200000L, (long)map.getCurrentTableCapacity());
            Assert.assertTrue((map.getLongestChainLength() <= 7 ? 1 : 0) != 0);
            BitSet bitset = new BitSet();
            int numContained = 0;
            for (KeyMap.Entry entry : map) {
                ++numContained;
                int key = (Integer)entry.getKey();
                int expected = key % 3 == 0 ? 2 * key : 2 * key + 1;
                Assert.assertEquals((long)expected, (long)((Integer)entry.getValue()).intValue());
                Assert.assertFalse((boolean)bitset.get(key));
                bitset.set(key);
            }
            Assert.assertEquals((long)1000000L, (long)numContained);
            Assert.assertEquals((long)1000000L, (long)bitset.cardinality());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

