/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.junit.Assert;
import org.junit.Test;

public class KeyMapTest {
    @Test
    public void testInitialSizeComputation() {
        try {
            KeyMap map = new KeyMap();
            Assert.assertEquals((long)64L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)6L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)24L, (long)map.getShift());
            Assert.assertEquals((long)48L, (long)map.getRehashThreshold());
            map = new KeyMap(0);
            Assert.assertEquals((long)64L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)6L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)24L, (long)map.getShift());
            Assert.assertEquals((long)48L, (long)map.getRehashThreshold());
            map = new KeyMap(1);
            Assert.assertEquals((long)64L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)6L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)24L, (long)map.getShift());
            Assert.assertEquals((long)48L, (long)map.getRehashThreshold());
            map = new KeyMap(9);
            Assert.assertEquals((long)64L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)6L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)24L, (long)map.getShift());
            Assert.assertEquals((long)48L, (long)map.getRehashThreshold());
            map = new KeyMap(63);
            Assert.assertEquals((long)64L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)6L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)24L, (long)map.getShift());
            Assert.assertEquals((long)48L, (long)map.getRehashThreshold());
            map = new KeyMap(64);
            Assert.assertEquals((long)128L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)7L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)23L, (long)map.getShift());
            Assert.assertEquals((long)96L, (long)map.getRehashThreshold());
            map = new KeyMap(500);
            Assert.assertEquals((long)512L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)9L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)21L, (long)map.getShift());
            Assert.assertEquals((long)384L, (long)map.getRehashThreshold());
            map = new KeyMap(127);
            Assert.assertEquals((long)128L, (long)map.getCurrentTableCapacity());
            Assert.assertEquals((long)7L, (long)map.getLog2TableCapacity());
            Assert.assertEquals((long)23L, (long)map.getShift());
            Assert.assertEquals((long)96L, (long)map.getRehashThreshold());
            try {
                new KeyMap(-1);
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                map = new KeyMap(1701926178);
                int maxCap = Integer.highestOneBit(Integer.MAX_VALUE);
                Assert.assertEquals((long)Integer.highestOneBit(Integer.MAX_VALUE), (long)map.getCurrentTableCapacity());
                Assert.assertEquals((long)30L, (long)map.getLog2TableCapacity());
                Assert.assertEquals((long)0L, (long)map.getShift());
                Assert.assertEquals((long)(maxCap / 4 * 3), (long)map.getRehashThreshold());
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutAndGetRandom() {
        try {
            Integer key;
            int i;
            KeyMap map = new KeyMap();
            Random rnd = new Random();
            long seed = rnd.nextLong();
            int numElements = 10000;
            HashMap<Integer, Integer> groundTruth = new HashMap<Integer, Integer>();
            rnd.setSeed(seed);
            for (i = 0; i < 10000; ++i) {
                key = rnd.nextInt();
                Integer value = rnd.nextInt();
                if (!rnd.nextBoolean()) continue;
                groundTruth.put(key, value);
                map.put((Object)key, (Object)value);
            }
            rnd.setSeed(seed);
            for (i = 0; i < 10000; ++i) {
                key = rnd.nextInt();
                rnd.nextInt();
                rnd.nextBoolean();
                Integer expected = (Integer)groundTruth.get(key);
                if (expected == null) {
                    Assert.assertNull((Object)map.get((Object)key));
                    continue;
                }
                Integer contained = (Integer)map.get((Object)key);
                Assert.assertNotNull((Object)contained);
                Assert.assertEquals((Object)expected, (Object)contained);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConjunctTraversal() {
        try {
            Random rootRnd = new Random(654685486325439L);
            int numMaps = 7;
            int numKeys = 1000000;
            KeyMap[] maps = new KeyMap[7];
            for (int i = 0; i < 7; ++i) {
                maps[i] = new KeyMap();
            }
            double[] probabilities = new double[7];
            double[] probabilitiesTemp = new double[7];
            probabilities[0] = 0.5;
            double remainingProb = 1.0 - probabilities[0];
            for (int i = 1; i < 6; ++i) {
                probabilities[i] = remainingProb /= 2.0;
            }
            probabilities[6] = remainingProb;
            long probSeed = rootRnd.nextLong();
            long keySeed = rootRnd.nextLong();
            Random probRnd = new Random(probSeed);
            Random keyRnd = new Random(keySeed);
            int maxStride = 2147;
            int totalNumElements = 0;
            int nextKeyValue = 1;
            for (int i = 0; i < 1000000; ++i) {
                int numCopies = nextKeyValue % 3 + 1;
                System.arraycopy(probabilities, 0, probabilitiesTemp, 0, 7);
                double totalProb = 1.0;
                for (int copy = 0; copy < numCopies; ++copy) {
                    int pos = KeyMapTest.drawPosProportionally(probabilitiesTemp, totalProb, probRnd);
                    totalProb -= probabilitiesTemp[pos];
                    probabilitiesTemp[pos] = 0.0;
                    Integer boxed = nextKeyValue;
                    Integer previous = (Integer)maps[pos].put((Object)boxed, (Object)boxed);
                    Assert.assertNull((String)"Test problem - test does not assign unique maps", (Object)previous);
                }
                totalNumElements += numCopies;
                nextKeyValue += keyRnd.nextInt(2147) + 1;
            }
            int numContained = 0;
            for (KeyMap map : maps) {
                numContained += map.size();
            }
            Assert.assertEquals((long)totalNumElements, (long)numContained);
            keyRnd.setSeed(keySeed);
            numContained = 0;
            nextKeyValue = 1;
            for (int i = 0; i < 1000000; ++i) {
                int numCopiesExpected = nextKeyValue % 3 + 1;
                int numCopiesContained = 0;
                for (KeyMap map : maps) {
                    Integer val = (Integer)map.get((Object)nextKeyValue);
                    if (val == null) continue;
                    Assert.assertEquals((long)nextKeyValue, (long)val.intValue());
                    ++numCopiesContained;
                }
                Assert.assertEquals((long)numCopiesExpected, (long)numCopiesContained);
                numContained += numCopiesContained;
                nextKeyValue += keyRnd.nextInt(2147) + 1;
            }
            Assert.assertEquals((long)totalNumElements, (long)numContained);
            final int[] keysStartedAndFinished = new int[]{0, 0};
            KeyMap.TraversalEvaluator<Integer, Integer> traversal = new KeyMap.TraversalEvaluator<Integer, Integer>(){
                private int key;
                private int valueCount;

                public void startNewKey(Integer key) {
                    this.key = key;
                    this.valueCount = 0;
                    keysStartedAndFinished[0] = keysStartedAndFinished[0] + 1;
                }

                public void nextValue(Integer value) {
                    Assert.assertEquals((long)this.key, (long)value.intValue());
                    ++this.valueCount;
                }

                public void keyDone() {
                    int expected = this.key % 3 + 1;
                    if (expected != this.valueCount) {
                        Assert.fail((String)("Wrong count for key " + this.key + " ; expected=" + expected + " , count=" + this.valueCount));
                    }
                    keysStartedAndFinished[1] = keysStartedAndFinished[1] + 1;
                }
            };
            KeyMap.traverseMaps((KeyMap[])KeyMapTest.shuffleArray(maps, rootRnd), (KeyMap.TraversalEvaluator)traversal, (long)17L);
            Assert.assertEquals((long)1000000L, (long)keysStartedAndFinished[0]);
            Assert.assertEquals((long)1000000L, (long)keysStartedAndFinished[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSizeComparator() {
        try {
            KeyMap map1 = new KeyMap(5);
            KeyMap map2 = new KeyMap(80);
            Assert.assertTrue((map1.getCurrentTableCapacity() < map2.getCurrentTableCapacity() ? 1 : 0) != 0);
            Assert.assertTrue((KeyMap.CapacityDescendingComparator.INSTANCE.compare(map1, map1) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((KeyMap.CapacityDescendingComparator.INSTANCE.compare(map2, map2) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((KeyMap.CapacityDescendingComparator.INSTANCE.compare(map1, map2) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((KeyMap.CapacityDescendingComparator.INSTANCE.compare(map2, map1) < 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static int drawPosProportionally(double[] array, double totalProbability, Random rnd) {
        double val = rnd.nextDouble() * totalProbability;
        double accum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            if (!(val <= (accum += array[i])) || !(array[i] > 0.0)) continue;
            return i;
        }
        return array.length - 1;
    }

    private static <E> E[] shuffleArray(E[] array, Random rnd) {
        E[] target = Arrays.copyOf(array, array.length);
        for (int i = target.length - 1; i > 0; --i) {
            int swapPos = rnd.nextInt(i + 1);
            E temp = target[i];
            target[i] = target[swapPos];
            target[swapPos] = temp;
        }
        return target;
    }
}

