/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.MergingWindowSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MergingWindowSetTest {
    @Test
    public void testNonEagerMerging() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)new NonEagerlyMergingWindowAssigner(3000L), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        TimeWindow result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(0L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(2L, 5L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
        mergeFunction.reset();
        result = (TimeWindow)windowSet.addWindow((Window)new TimeWindow(10L, 12L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertNotNull((Object)windowSet.getStateWindow((Window)result));
    }

    @Test
    public void testIncrementalMerging() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertTrue((boolean)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(0L, 4L))).equals((Object)new TimeWindow(0L, 4L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 5L), (Object)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 5L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)mergeFunction.stateWindow());
        MatcherAssert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 4L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(4L, 6L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)mergeFunction.stateWindow());
        MatcherAssert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 5L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 4L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 6L), (Object)windowSet.addWindow((Window)new TimeWindow(4L, 6L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)windowSet.addWindow((Window)new TimeWindow(11L, 14L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)windowSet.getStateWindow((Window)new TimeWindow(11L, 14L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 14L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 14L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)mergeFunction.stateWindow());
        MatcherAssert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(11L, 14L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 15L), (Object)windowSet.addWindow((Window)new TimeWindow(12L, 15L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 15L), (Object)mergeFunction.mergeTarget());
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)mergeFunction.stateWindow());
        MatcherAssert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 14L)}));
        Assert.assertTrue((boolean)mergeFunction.mergedStateWindows().isEmpty());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 15L), (Object)windowSet.addWindow((Window)new TimeWindow(11L, 14L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)));
        Assert.assertEquals((Object)new TimeWindow(11L, 14L), (Object)windowSet.getStateWindow((Window)new TimeWindow(10L, 15L)));
        windowSet.retireWindow((Window)new TimeWindow(0L, 6L));
        Assert.assertTrue((windowSet.getStateWindow((Window)new TimeWindow(0L, 6L)) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((TimeWindow)windowSet.getStateWindow((Window)new TimeWindow(10L, 15L))).equals((Object)new TimeWindow(11L, 14L)));
    }

    @Test
    public void testLateMerging() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 3L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 8L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.getStateWindow((Window)new TimeWindow(10L, 13L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(8L, 10L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)mergeFunction.mergeTarget());
        MatcherAssert.assertThat((Object)mergeFunction.stateWindow(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
        MatcherAssert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)}));
        MatcherAssert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)CoreMatchers.anyOf((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 13L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L)})));
        MatcherAssert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)mergeFunction.mergeTarget())));
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(8L, 10L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        MatcherAssert.assertThat((Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 13L)), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(3L, 5L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(0L, 13L), (Object)mergeFunction.mergeTarget());
        MatcherAssert.assertThat((Object)mergeFunction.stateWindow(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)new TimeWindow(0L, 3L)), (Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
        MatcherAssert.assertThat(mergeFunction.mergeSources(), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 13L)}));
        MatcherAssert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)CoreMatchers.anyOf((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(10L, 13L)})));
        MatcherAssert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)mergeFunction.mergeTarget())));
        MatcherAssert.assertThat((Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 13L)), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)new TimeWindow(0L, 3L)), (Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
    }

    @Test
    public void testMergeLargeWindowCoveringSingleWindow() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 3L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 3L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 3L)));
    }

    @Test
    public void testAddingIdenticalWindows() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
    }

    @Test
    public void testMergeLargeWindowCoveringMultipleWindows() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(1L, 3L), (Object)windowSet.addWindow((Window)new TimeWindow(1L, 3L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(1L, 3L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 3L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.addWindow((Window)new TimeWindow(5L, 8L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(5L, 8L), (Object)windowSet.getStateWindow((Window)new TimeWindow(5L, 8L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(10L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertFalse((boolean)mergeFunction.hasMerged());
        Assert.assertEquals((Object)new TimeWindow(10L, 13L), (Object)windowSet.getStateWindow((Window)new TimeWindow(10L, 13L)));
        mergeFunction.reset();
        Assert.assertEquals((Object)new TimeWindow(0L, 13L), (Object)windowSet.addWindow((Window)new TimeWindow(0L, 13L), (MergingWindowSet.MergeFunction)mergeFunction));
        Assert.assertTrue((boolean)mergeFunction.hasMerged());
        MatcherAssert.assertThat(mergeFunction.mergedStateWindows(), (Matcher)CoreMatchers.anyOf((Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L), new TimeWindow(5L, 8L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 3L), new TimeWindow(10L, 13L)}), (Matcher)Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(5L, 8L), new TimeWindow(10L, 13L)})));
        MatcherAssert.assertThat((Object)windowSet.getStateWindow((Window)new TimeWindow(0L, 13L)), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)new TimeWindow(1L, 3L)), (Matcher)Is.is((Object)new TimeWindow(5L, 8L)), (Matcher)Is.is((Object)new TimeWindow(10L, 13L))));
    }

    @Test
    public void testRestoreFromState() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        Mockito.when((Object)mockState.get()).thenReturn((Object)Lists.newArrayList((Object[])new Tuple2[]{new Tuple2((Object)new TimeWindow(17L, 42L), (Object)new TimeWindow(42L, 17L)), new Tuple2((Object)new TimeWindow(1L, 2L), (Object)new TimeWindow(3L, 4L))}));
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        Assert.assertEquals((Object)new TimeWindow(42L, 17L), (Object)windowSet.getStateWindow((Window)new TimeWindow(17L, 42L)));
        Assert.assertEquals((Object)new TimeWindow(3L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
    }

    @Test
    public void testPersist() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        TestingMergeFunction mergeFunction = new TestingMergeFunction();
        windowSet.addWindow((Window)new TimeWindow(1L, 2L), (MergingWindowSet.MergeFunction)mergeFunction);
        windowSet.addWindow((Window)new TimeWindow(17L, 42L), (MergingWindowSet.MergeFunction)mergeFunction);
        Assert.assertEquals((Object)new TimeWindow(1L, 2L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
        Assert.assertEquals((Object)new TimeWindow(17L, 42L), (Object)windowSet.getStateWindow((Window)new TimeWindow(17L, 42L)));
        windowSet.persist();
        ((ListState)Mockito.verify((Object)mockState)).add(org.mockito.Matchers.eq((Object)new Tuple2((Object)new TimeWindow(1L, 2L), (Object)new TimeWindow(1L, 2L))));
        ((ListState)Mockito.verify((Object)mockState)).add(org.mockito.Matchers.eq((Object)new Tuple2((Object)new TimeWindow(17L, 42L), (Object)new TimeWindow(17L, 42L))));
        ((ListState)Mockito.verify((Object)mockState, (VerificationMode)Mockito.times((int)2))).add(org.mockito.Matchers.anyObject());
    }

    @Test
    public void testPersistOnlyIfHaveUpdates() throws Exception {
        ListState mockState = (ListState)Mockito.mock(ListState.class);
        Mockito.when((Object)mockState.get()).thenReturn((Object)Lists.newArrayList((Object[])new Tuple2[]{new Tuple2((Object)new TimeWindow(17L, 42L), (Object)new TimeWindow(42L, 17L)), new Tuple2((Object)new TimeWindow(1L, 2L), (Object)new TimeWindow(3L, 4L))}));
        MergingWindowSet windowSet = new MergingWindowSet((MergingWindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L)), mockState);
        Assert.assertEquals((Object)new TimeWindow(42L, 17L), (Object)windowSet.getStateWindow((Window)new TimeWindow(17L, 42L)));
        Assert.assertEquals((Object)new TimeWindow(3L, 4L), (Object)windowSet.getStateWindow((Window)new TimeWindow(1L, 2L)));
        windowSet.persist();
        ((ListState)Mockito.verify((Object)mockState, (VerificationMode)Mockito.times((int)0))).add(org.mockito.Matchers.anyObject());
    }

    static class NonEagerlyMergingWindowAssigner
    extends MergingWindowAssigner<Object, TimeWindow> {
        private static final long serialVersionUID = 1L;
        protected long sessionTimeout;

        public NonEagerlyMergingWindowAssigner(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public Collection<TimeWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
            return Collections.singletonList(new TimeWindow(timestamp, timestamp + this.sessionTimeout));
        }

        public Trigger<Object, TimeWindow> getDefaultTrigger(StreamExecutionEnvironment env) {
            return EventTimeTrigger.create();
        }

        public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
            return new TimeWindow.Serializer();
        }

        public boolean isEventTime() {
            return true;
        }

        public void mergeWindows(Collection<TimeWindow> windows, MergingWindowAssigner.MergeCallback<TimeWindow> c) {
            TimeWindow earliestStart = null;
            for (TimeWindow timeWindow : windows) {
                if (earliestStart == null) {
                    earliestStart = timeWindow;
                    continue;
                }
                if (timeWindow.getStart() >= earliestStart.getStart()) continue;
                earliestStart = timeWindow;
            }
            ArrayList<TimeWindow> associatedWindows = new ArrayList<TimeWindow>();
            for (TimeWindow win : windows) {
                if (win.getStart() >= earliestStart.getEnd() || win.getStart() < earliestStart.getStart()) continue;
                associatedWindows.add(win);
            }
            TimeWindow timeWindow = new TimeWindow(earliestStart.getStart(), earliestStart.getEnd() + 1L);
            if (associatedWindows.size() > 1) {
                c.merge(associatedWindows, (Object)timeWindow);
            }
        }
    }

    private static class TestingMergeFunction
    implements MergingWindowSet.MergeFunction<TimeWindow> {
        private TimeWindow target = null;
        private Collection<TimeWindow> sources = null;
        private TimeWindow stateWindow = null;
        private Collection<TimeWindow> mergedStateWindows = null;

        private TestingMergeFunction() {
        }

        public void reset() {
            this.target = null;
            this.sources = null;
            this.stateWindow = null;
            this.mergedStateWindows = null;
        }

        public boolean hasMerged() {
            return this.target != null;
        }

        public TimeWindow mergeTarget() {
            return this.target;
        }

        public Collection<TimeWindow> mergeSources() {
            return this.sources;
        }

        public TimeWindow stateWindow() {
            return this.stateWindow;
        }

        public Collection<TimeWindow> mergedStateWindows() {
            return this.mergedStateWindows;
        }

        public void merge(TimeWindow mergeResult, Collection<TimeWindow> mergedWindows, TimeWindow stateWindowResult, Collection<TimeWindow> mergedStateWindows) throws Exception {
            if (this.target != null) {
                Assert.fail((String)"More than one merge for adding a Window should not occur.");
            }
            this.stateWindow = stateWindowResult;
            this.target = mergeResult;
            this.mergedStateWindows = mergedStateWindows;
            this.sources = mergedWindows;
        }
    }
}

