/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichAggregateFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.WindowedStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.CountEvictor;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class WindowTranslationTest {
    @Test(expected=UnsupportedOperationException.class)
    public void testReduceWithRichReducerFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        source.keyBy(new int[]{0}).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).reduce((ReduceFunction)new RichReduceFunction<Tuple2<String, Integer>>(){

            public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                return null;
            }
        });
        Assert.fail((String)"exception was not thrown");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAggregateWithRichFunctionFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        source.keyBy(new int[]{0}).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).aggregate(new DummyRichAggregationFunction());
        Assert.fail((String)"exception was not thrown");
    }

    @Test
    public void testMergingAssignerWithNonMergingTriggerFails() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        WindowedStream windowedStream = env.fromElements((Object[])new String[]{"Hello", "Ciao"}).keyBy((KeySelector)new KeySelector<String, String>(){
            private static final long serialVersionUID = 598309916882894293L;

            public String getKey(String value) throws Exception {
                return value;
            }
        }).window((WindowAssigner)EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L)));
        try {
            windowedStream.trigger((Trigger)new Trigger<String, TimeWindow>(){
                private static final long serialVersionUID = 6558046711583024443L;

                public TriggerResult onElement(String element, long timestamp, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                    return null;
                }

                public TriggerResult onProcessingTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                    return null;
                }

                public TriggerResult onEventTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                    return null;
                }

                public boolean canMerge() {
                    return false;
                }

                public void clear(TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
                }
            });
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.fail((String)"The trigger call should fail.");
    }

    @Test
    public void testMergingWindowsWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 2});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new KeySelector<Integer, String>(){

            public String getKey(Integer value) throws Exception {
                return value.toString();
            }
        }).window((WindowAssigner)EventTimeSessionWindows.withGap((Time)Time.seconds((long)5L))).evictor((Evictor)CountEvictor.of((long)5L)).process((ProcessWindowFunction)new TestProcessWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof EventTimeSessionWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, 1);
    }

    @Test
    public void testReduceEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)SlidingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).reduce((ReduceFunction)new DummyReducer());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)reducer, (WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)new DummyReducer(), (WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String tuple, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithProcesWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)reducer, (ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(String key, ProcessWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithProcessWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).reduce((ReduceFunction)new DummyReducer(), (ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(String tuple, ProcessWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithPreReducerEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((ReduceFunction)reducer, (WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithPreReducerAndEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).apply((ReduceFunction)reducer, (WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple3<String, String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple3<String, String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect((Object)new Tuple3(in.f0, in.f0, in.f1));
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testAggregateProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)SlidingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testAggregateWithWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction(), (WindowFunction)new TestWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testAggregateWithWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction(), (WindowFunction)new TestWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testAggregateWithProcessWindowFunctionEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction(), (ProcessWindowFunction)new TestProcessWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testAggregateWithProcessWindowFunctionProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).aggregate((AggregateFunction)new DummyAggregationFunction(), (ProcessWindowFunction)new TestProcessWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof AggregatingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(operator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testApplyEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessEventTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).process((ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(String key, ProcessWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessProcessingTime() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).process((ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(String key, ProcessWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof ProcessingTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingProcessingTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ReducingStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testApplyWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessWithCustomTrigger() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).process((ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(String key, ProcessWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof CountEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testReduceWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).reduce((ReduceFunction)reducer, (ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple, TimeWindow>(){

            public void process(Tuple tuple, ProcessWindowFunction.Context context, Iterable<Tuple2<String, Integer>> elements, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : elements) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof CountEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testAggregateWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).aggregate((AggregateFunction)new DummyAggregationFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testAggregateWithEvictorAndProcessFunction() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple3[]{Tuple3.of((Object)"hello", (Object)"hallo", (Object)1), Tuple3.of((Object)"hello", (Object)"hallo", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new Tuple3KeySelector()).window((WindowAssigner)SlidingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS), (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).evictor((Evictor)CountEvictor.of((long)100L)).aggregate((AggregateFunction)new DummyAggregationFunction(), (ProcessWindowFunction)new TestProcessWindowFunction());
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof WindowOperator));
        WindowOperator winOperator = (WindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple3((Object)"hello", (Object)"hallo", (Object)1));
    }

    @Test
    public void testApplyWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).evictor((Evictor)TimeEvictor.of((Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(String key, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof TimeEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    @Test
    public void testProcessWithEvictor() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        SingleOutputStreamOperator window1 = source.keyBy((KeySelector)new TupleKeySelector()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.of((long)1L, (TimeUnit)TimeUnit.SECONDS))).trigger((Trigger)CountTrigger.of((long)1L)).evictor((Evictor)TimeEvictor.of((Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))).process((ProcessWindowFunction)new ProcessWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, String, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void process(String key, ProcessWindowFunction.Context ctx, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
                for (Tuple2<String, Integer> in : values) {
                    out.collect(in);
                }
            }
        });
        OneInputTransformation transform = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator = transform.getOperator();
        Assert.assertTrue((boolean)(operator instanceof EvictingWindowOperator));
        EvictingWindowOperator winOperator = (EvictingWindowOperator)operator;
        Assert.assertTrue((boolean)(winOperator.getTrigger() instanceof CountTrigger));
        Assert.assertTrue((boolean)(winOperator.getEvictor() instanceof TimeEvictor));
        Assert.assertTrue((boolean)(winOperator.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator.getStateDescriptor() instanceof ListStateDescriptor));
        WindowTranslationTest.processElementAndEnsureOutput(winOperator, winOperator.getKeySelector(), BasicTypeInfo.STRING_TYPE_INFO, new Tuple2((Object)"hello", (Object)1));
    }

    private static <K, IN, OUT> void processElementAndEnsureOutput(OneInputStreamOperator<IN, OUT> operator, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, IN element) throws Exception {
        KeyedOneInputStreamOperatorTestHarness<K, IN, OUT> testHarness = new KeyedOneInputStreamOperatorTestHarness<K, IN, OUT>(operator, keySelector, keyType);
        if (operator instanceof OutputTypeConfigurable) {
            ((OutputTypeConfigurable)operator).setOutputType((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, new ExecutionConfig());
        }
        testHarness.open();
        testHarness.setProcessingTime(0L);
        testHarness.processWatermark(Long.MIN_VALUE);
        testHarness.processElement(new StreamRecord(element, 0L));
        testHarness.setProcessingTime(Long.MAX_VALUE);
        testHarness.processWatermark(Long.MAX_VALUE);
        Assert.assertTrue((testHarness.getOutput().size() >= 3 ? 1 : 0) != 0);
        testHarness.close();
    }

    private static class Tuple3KeySelector
    implements KeySelector<Tuple3<String, String, Integer>, String> {
        private Tuple3KeySelector() {
        }

        public String getKey(Tuple3<String, String, Integer> value) throws Exception {
            return (String)value.f0;
        }
    }

    private static class TupleKeySelector
    implements KeySelector<Tuple2<String, Integer>, String> {
        private TupleKeySelector() {
        }

        public String getKey(Tuple2<String, Integer> value) throws Exception {
            return (String)value.f0;
        }
    }

    private static class TestProcessWindowFunction
    extends ProcessWindowFunction<Integer, String, String, TimeWindow> {
        private TestProcessWindowFunction() {
        }

        public void process(String key, ProcessWindowFunction.Context ctx, Iterable<Integer> values, Collector<String> out) throws Exception {
            for (Integer in : values) {
                out.collect((Object)in.toString());
            }
        }
    }

    private static class TestWindowFunction
    implements WindowFunction<Integer, String, String, TimeWindow> {
        private TestWindowFunction() {
        }

        public void apply(String key, TimeWindow window, Iterable<Integer> values, Collector<String> out) throws Exception {
            for (Integer in : values) {
                out.collect((Object)in.toString());
            }
        }
    }

    private static class DummyRichAggregationFunction<T>
    extends RichAggregateFunction<T, T, T> {
        private DummyRichAggregationFunction() {
        }

        public T createAccumulator() {
            return null;
        }

        public T add(T value, T accumulator) {
            return accumulator;
        }

        public T getResult(T accumulator) {
            return accumulator;
        }

        public T merge(T a, T b) {
            return a;
        }
    }

    private static class DummyAggregationFunction
    implements AggregateFunction<Tuple3<String, String, Integer>, Tuple2<String, Integer>, Integer> {
        private DummyAggregationFunction() {
        }

        public Tuple2<String, Integer> createAccumulator() {
            return new Tuple2((Object)"", (Object)0);
        }

        public Tuple2<String, Integer> add(Tuple3<String, String, Integer> value, Tuple2<String, Integer> accumulator) {
            accumulator.f0 = value.f0;
            accumulator.f1 = value.f2;
            return accumulator;
        }

        public Integer getResult(Tuple2<String, Integer> accumulator) {
            return (Integer)accumulator.f1;
        }

        public Tuple2<String, Integer> merge(Tuple2<String, Integer> a, Tuple2<String, Integer> b) {
            return a;
        }
    }

    private static class DummyReducer
    implements ReduceFunction<Tuple2<String, Integer>> {
        private DummyReducer() {
        }

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
            return value1;
        }
    }
}

