/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class StreamRecordTest {
    @Test
    public void testWithNoTimestamp() {
        StreamRecord record = new StreamRecord((Object)"test");
        Assert.assertTrue((boolean)record.isRecord());
        Assert.assertFalse((boolean)record.isWatermark());
        Assert.assertFalse((boolean)record.hasTimestamp());
        Assert.assertEquals((Object)"test", (Object)record.getValue());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getTimestamp());
        Assert.assertNotNull((Object)record.toString());
        Assert.assertTrue((record.hashCode() == new StreamRecord((Object)"test").hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)record.equals((Object)new StreamRecord((Object)"test")));
        Assert.assertEquals((Object)record, (Object)record.asRecord());
        try {
            record.asWatermark();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testWithTimestamp() {
        StreamRecord record = new StreamRecord((Object)"foo", 42L);
        Assert.assertTrue((boolean)record.isRecord());
        Assert.assertFalse((boolean)record.isWatermark());
        Assert.assertTrue((boolean)record.hasTimestamp());
        Assert.assertEquals((long)42L, (long)record.getTimestamp());
        Assert.assertEquals((Object)"foo", (Object)record.getValue());
        Assert.assertNotNull((Object)record.toString());
        Assert.assertTrue((record.hashCode() == new StreamRecord((Object)"foo", 42L).hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((record.hashCode() != new StreamRecord((Object)"foo").hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)record.equals((Object)new StreamRecord((Object)"foo", 42L)));
        Assert.assertFalse((boolean)record.equals((Object)new StreamRecord((Object)"foo")));
        Assert.assertEquals((Object)record, (Object)record.asRecord());
        try {
            record.asWatermark();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAllowedTimestampRange() {
        Assert.assertEquals((long)0L, (long)new StreamRecord((Object)"test", 0L).getTimestamp());
        Assert.assertEquals((long)-1L, (long)new StreamRecord((Object)"test", -1L).getTimestamp());
        Assert.assertEquals((long)1L, (long)new StreamRecord((Object)"test", 1L).getTimestamp());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)new StreamRecord((Object)"test", Long.MIN_VALUE).getTimestamp());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)new StreamRecord((Object)"test", Long.MAX_VALUE).getTimestamp());
    }

    @Test
    public void testReplacePreservesTimestamp() {
        StreamRecord recNoTimestamp = new StreamRecord((Object)"o sole mio");
        StreamRecord newRecNoTimestamp = recNoTimestamp.replace((Object)17);
        Assert.assertFalse((boolean)newRecNoTimestamp.hasTimestamp());
        StreamRecord recWithTimestamp = new StreamRecord((Object)"la dolce vita", 99L);
        StreamRecord newRecWithTimestamp = recWithTimestamp.replace((Object)17);
        Assert.assertTrue((boolean)newRecWithTimestamp.hasTimestamp());
        Assert.assertEquals((long)99L, (long)newRecWithTimestamp.getTimestamp());
    }

    @Test
    public void testReplaceWithTimestampOverridesTimestamp() {
        StreamRecord record = new StreamRecord((Object)"la divina comedia");
        Assert.assertFalse((boolean)record.hasTimestamp());
        StreamRecord newRecord = record.replace((Object)3.14, 123L);
        Assert.assertTrue((boolean)newRecord.hasTimestamp());
        Assert.assertEquals((long)123L, (long)newRecord.getTimestamp());
    }

    @Test
    public void testCopy() {
        StreamRecord recNoTimestamp = new StreamRecord((Object)"test");
        StreamRecord recNoTimestampCopy = recNoTimestamp.copy((Object)"test");
        Assert.assertEquals((Object)recNoTimestamp, (Object)recNoTimestampCopy);
        StreamRecord recWithTimestamp = new StreamRecord((Object)"test", 99L);
        StreamRecord recWithTimestampCopy = recWithTimestamp.copy((Object)"test");
        Assert.assertEquals((Object)recWithTimestamp, (Object)recWithTimestampCopy);
    }

    @Test
    public void testCopyTo() {
        StreamRecord recNoTimestamp = new StreamRecord((Object)"test");
        StreamRecord recNoTimestampCopy = new StreamRecord(null);
        recNoTimestamp.copyTo((Object)"test", recNoTimestampCopy);
        Assert.assertEquals((Object)recNoTimestamp, (Object)recNoTimestampCopy);
        StreamRecord recWithTimestamp = new StreamRecord((Object)"test", 99L);
        StreamRecord recWithTimestampCopy = new StreamRecord(null);
        recWithTimestamp.copyTo((Object)"test", recWithTimestampCopy);
        Assert.assertEquals((Object)recWithTimestamp, (Object)recWithTimestampCopy);
    }

    @Test
    public void testSetAndEraseTimestamps() {
        StreamRecord rec = new StreamRecord((Object)"hello");
        Assert.assertFalse((boolean)rec.hasTimestamp());
        rec.setTimestamp(13456L);
        Assert.assertTrue((boolean)rec.hasTimestamp());
        Assert.assertEquals((long)13456L, (long)rec.getTimestamp());
        rec.eraseTimestamp();
        Assert.assertFalse((boolean)rec.hasTimestamp());
    }
}

