/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.operators.SourceOperatorFactory;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;

public class SourceOperatorTestHarness<OUT>
extends AbstractStreamOperatorTestHarness<OUT> {
    private final MockDataOutput<OUT> dataOutput = new MockDataOutput(new AbstractStreamOperatorTestHarness.MockOutput());

    public SourceOperatorTestHarness(SourceOperatorFactory<OUT> operator, MockEnvironment environment) throws Exception {
        super(operator, environment);
    }

    public void emitNext() throws Exception {
        this.getCastedOperator().emitNext(this.dataOutput);
    }

    private SourceOperator<OUT, ?> getCastedOperator() {
        return (SourceOperator)this.operator;
    }

    private static class MockDataOutput<OUT>
    implements PushingAsyncDataInput.DataOutput<OUT> {
        private final Output<StreamRecord<OUT>> output;

        public MockDataOutput(Output<StreamRecord<OUT>> output) {
            this.output = output;
        }

        public void emitRecord(StreamRecord<OUT> streamRecord) {
            this.output.collect(null, streamRecord);
        }

        public void emitWatermark(Watermark watermark) {
            this.output.emitWatermark(watermark);
        }

        public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
            this.output.emitWatermarkStatus(watermarkStatus);
        }

        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            this.output.emitLatencyMarker(latencyMarker);
        }
    }
}

