/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.BroadcastingOutputCollector;
import org.apache.flink.streaming.runtime.tasks.OutputWithChainingCheck;
import org.apache.flink.util.OutputTag;

final class CopyingBroadcastingOutputCollector<T>
extends BroadcastingOutputCollector<T> {
    public CopyingBroadcastingOutputCollector(OutputWithChainingCheck<StreamRecord<T>>[] allOutputs, Counter numRecordsOutForTask) {
        super(allOutputs, numRecordsOutForTask);
    }

    @Override
    public void collect(StreamRecord<T> record) {
        boolean emitted = false;
        int length = this.outputs.length;
        for (int i = 0; i < length - 1; ++i) {
            OutputWithChainingCheck output = this.outputs[i];
            StreamRecord<T> shallowCopy = record.copy(record.getValue());
            emitted |= output.collectAndCheckIfChained(shallowCopy);
        }
        if (length > 0) {
            emitted |= this.outputs[length - 1].collectAndCheckIfChained(record);
        }
        if (emitted) {
            this.numRecordsOutForTask.inc();
        }
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        boolean emitted = false;
        int length = this.outputs.length;
        for (int i = 0; i < length - 1; ++i) {
            OutputWithChainingCheck output = this.outputs[i];
            StreamRecord<X> shallowCopy = record.copy(record.getValue());
            emitted |= output.collectAndCheckIfChained(outputTag, shallowCopy);
        }
        if (length > 0) {
            emitted |= this.outputs[length - 1].collectAndCheckIfChained(outputTag, record);
        }
        if (emitted) {
            this.numRecordsOutForTask.inc();
        }
    }
}

