/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.BroadcastStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.BroadcastProcessFunction;
import org.apache.flink.streaming.api.functions.co.KeyedBroadcastProcessFunction;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithKeyedOperator;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithNonKeyedOperator;
import org.apache.flink.streaming.api.transformations.BroadcastStateTransformation;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class BroadcastConnectedStream<IN1, IN2> {
    private final StreamExecutionEnvironment environment;
    private final DataStream<IN1> nonBroadcastStream;
    private final BroadcastStream<IN2> broadcastStream;
    private final List<MapStateDescriptor<?, ?>> broadcastStateDescriptors;

    protected BroadcastConnectedStream(StreamExecutionEnvironment env, DataStream<IN1> input1, BroadcastStream<IN2> input2, List<MapStateDescriptor<?, ?>> broadcastStateDescriptors) {
        this.environment = Objects.requireNonNull(env);
        this.nonBroadcastStream = Objects.requireNonNull(input1);
        this.broadcastStream = Objects.requireNonNull(input2);
        this.broadcastStateDescriptors = Objects.requireNonNull(broadcastStateDescriptors);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public DataStream<IN1> getFirstInput() {
        return this.nonBroadcastStream;
    }

    public BroadcastStream<IN2> getSecondInput() {
        return this.broadcastStream;
    }

    public TypeInformation<IN1> getType1() {
        return this.nonBroadcastStream.getType();
    }

    public TypeInformation<IN2> getType2() {
        return this.broadcastStream.getType();
    }

    @PublicEvolving
    public <KS, OUT> SingleOutputStreamOperator<OUT> process(KeyedBroadcastProcessFunction<KS, IN1, IN2, OUT> function) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(function, KeyedBroadcastProcessFunction.class, (int)1, (int)2, (int)3, (int[])TypeExtractor.NO_INDEX, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.process(function, outTypeInfo);
    }

    @PublicEvolving
    public <KS, OUT> SingleOutputStreamOperator<OUT> process(KeyedBroadcastProcessFunction<KS, IN1, IN2, OUT> function, TypeInformation<OUT> outTypeInfo) {
        Preconditions.checkNotNull(function);
        Preconditions.checkArgument((boolean)(this.nonBroadcastStream instanceof KeyedStream), (Object)"A KeyedBroadcastProcessFunction can only be used on a keyed stream.");
        CoBroadcastWithKeyedOperator<KS, IN1, IN2, OUT> operator = new CoBroadcastWithKeyedOperator<KS, IN1, IN2, OUT>(this.clean((Object)function), this.broadcastStateDescriptors);
        return this.transform("Co-Process-Broadcast-Keyed", outTypeInfo, operator);
    }

    @PublicEvolving
    public <OUT> SingleOutputStreamOperator<OUT> process(BroadcastProcessFunction<IN1, IN2, OUT> function) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(function, BroadcastProcessFunction.class, (int)0, (int)1, (int)2, (int[])TypeExtractor.NO_INDEX, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.process(function, outTypeInfo);
    }

    @PublicEvolving
    public <OUT> SingleOutputStreamOperator<OUT> process(BroadcastProcessFunction<IN1, IN2, OUT> function, TypeInformation<OUT> outTypeInfo) {
        Preconditions.checkNotNull(function);
        Preconditions.checkArgument((!(this.nonBroadcastStream instanceof KeyedStream) ? 1 : 0) != 0, (Object)"A BroadcastProcessFunction can only be used on a non-keyed stream.");
        CoBroadcastWithNonKeyedOperator<IN1, IN2, OUT> operator = new CoBroadcastWithNonKeyedOperator<IN1, IN2, OUT>(this.clean((Object)function), this.broadcastStateDescriptors);
        return this.transform("Co-Process-Broadcast", outTypeInfo, operator);
    }

    @Internal
    private <OUT> SingleOutputStreamOperator<OUT> transform(String functionName, TypeInformation<OUT> outTypeInfo, TwoInputStreamOperator<IN1, IN2, OUT> operator) {
        this.nonBroadcastStream.getType();
        this.broadcastStream.getType();
        BroadcastStateTransformation<IN1, IN2, OUT> transformation = this.getBroadcastStateTransformation(functionName, outTypeInfo, operator);
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, transformation);
        this.getExecutionEnvironment().addOperator(transformation);
        return returnStream;
    }

    private <OUT> BroadcastStateTransformation<IN1, IN2, OUT> getBroadcastStateTransformation(String functionName, TypeInformation<OUT> outTypeInfo, TwoInputStreamOperator<IN1, IN2, OUT> operator) {
        if (this.nonBroadcastStream instanceof KeyedStream) {
            return BroadcastStateTransformation.forKeyedStream(functionName, (KeyedStream)this.nonBroadcastStream, this.broadcastStream, SimpleOperatorFactory.of(operator), outTypeInfo, this.environment.getParallelism());
        }
        return BroadcastStateTransformation.forNonKeyedStream(functionName, this.nonBroadcastStream, this.broadcastStream, SimpleOperatorFactory.of(operator), outTypeInfo, this.environment.getParallelism());
    }

    protected <F> F clean(F f) {
        return this.getExecutionEnvironment().clean(f);
    }
}

