/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT>
extends PhysicalTransformation<Object> {
    private final Transformation<InputT> input;
    private final Sink<InputT, CommT, WriterStateT, GlobalCommT> sink;
    private ChainingStrategy chainingStrategy;

    public SinkTransformation(Transformation<InputT> input, Sink<InputT, CommT, WriterStateT, GlobalCommT> sink, String name, int parallelism) {
        super(name, TypeExtractor.getForClass(Object.class), parallelism);
        this.input = (Transformation)Preconditions.checkNotNull(input);
        this.sink = (Sink)Preconditions.checkNotNull(sink);
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.chainingStrategy = (ChainingStrategy)((Object)Preconditions.checkNotNull((Object)((Object)strategy)));
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    public void setUidHash(String uidHash) {
        throw new UnsupportedOperationException("Setting a UidHash is not supported for SinkTransformation.");
    }

    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        throw new UnsupportedOperationException("Do not support set resources for SinkTransformation.");
    }

    public Optional<Integer> declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase managedMemoryUseCase, int weight) {
        throw new UnsupportedOperationException("Declaring managed memory use cases is not supported for SinkTransformation.");
    }

    public void declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase managedMemoryUseCase) {
        throw new UnsupportedOperationException("Declaring managed memory use cases is not supported for SinkTransformation.");
    }

    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    public Sink<InputT, CommT, WriterStateT, GlobalCommT> getSink() {
        return this.sink;
    }
}

