/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.translators.AbstractTwoInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.BatchExecutionUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class TwoInputTransformationTranslator<IN1, IN2, OUT>
extends AbstractTwoInputTransformationTranslator<IN1, IN2, OUT, TwoInputTransformation<IN1, IN2, OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(TwoInputTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        boolean isKeyed;
        Collection<Integer> ids = this.translateInternal(transformation, context);
        boolean bl = isKeyed = transformation.getStateKeySelector1() != null && transformation.getStateKeySelector2() != null;
        if (isKeyed) {
            BatchExecutionUtils.applySortingInputs(transformation.getId(), context);
        }
        return ids;
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(TwoInputTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(TwoInputTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        return this.translateInternal(transformation, transformation.getInput1(), transformation.getInput2(), transformation.getOperatorFactory(), transformation.getStateKeyType(), transformation.getStateKeySelector1(), transformation.getStateKeySelector2(), context);
    }
}

