/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.PostVersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KeyGroupsList;
import org.apache.flink.streaming.api.operators.HeapInternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshot;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshotReaderWriters;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalTimerServiceSerializationProxy<K, N>
extends PostVersionedIOReadableWritable {
    public static final int VERSION = 1;
    private Map<String, HeapInternalTimerService<K, N>> timerServices;
    private ClassLoader userCodeClassLoader;
    private int keyGroupIdx;
    private int totalKeyGroups;
    private KeyGroupsList localKeyGroupRange;
    private KeyContext keyContext;
    private ProcessingTimeService processingTimeService;

    public InternalTimerServiceSerializationProxy(Map<String, HeapInternalTimerService<K, N>> timerServicesMapToPopulate, ClassLoader userCodeClassLoader, int totalKeyGroups, KeyGroupsList localKeyGroupRange, KeyContext keyContext, ProcessingTimeService processingTimeService, int keyGroupIdx) {
        this.timerServices = (Map)Preconditions.checkNotNull(timerServicesMapToPopulate);
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.totalKeyGroups = totalKeyGroups;
        this.localKeyGroupRange = (KeyGroupsList)Preconditions.checkNotNull((Object)localKeyGroupRange);
        this.keyContext = (KeyContext)Preconditions.checkNotNull((Object)keyContext);
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.keyGroupIdx = keyGroupIdx;
    }

    public InternalTimerServiceSerializationProxy(Map<String, HeapInternalTimerService<K, N>> timerServices, int keyGroupIdx) {
        this.timerServices = (Map)Preconditions.checkNotNull(timerServices);
        this.keyGroupIdx = keyGroupIdx;
    }

    public int getVersion() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.timerServices.size());
        for (Map.Entry<String, HeapInternalTimerService<K, N>> entry : this.timerServices.entrySet()) {
            String serviceName = entry.getKey();
            HeapInternalTimerService<K, N> timerService = entry.getValue();
            out.writeUTF(serviceName);
            InternalTimersSnapshotReaderWriters.getWriterForVersion(1, timerService.snapshotTimersForKeyGroup(this.keyGroupIdx)).writeTimersSnapshot(out);
        }
    }

    protected void read(DataInputView in, boolean wasVersioned) throws IOException {
        int noOfTimerServices = in.readInt();
        for (int i = 0; i < noOfTimerServices; ++i) {
            String serviceName = in.readUTF();
            HeapInternalTimerService<K, N> timerService = this.timerServices.get(serviceName);
            if (timerService == null) {
                timerService = new HeapInternalTimerService(this.totalKeyGroups, this.localKeyGroupRange, this.keyContext, this.processingTimeService);
                this.timerServices.put(serviceName, timerService);
            }
            int readerVersion = wasVersioned ? this.getReadVersion() : Integer.MIN_VALUE;
            InternalTimersSnapshot restoredTimersSnapshot = InternalTimersSnapshotReaderWriters.getReaderForVersion(readerVersion, this.userCodeClassLoader).readTimersSnapshot(in);
            timerService.restoreTimersForKeyGroup(restoredTimersSnapshot, this.keyGroupIdx);
        }
    }
}

