/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;

@Internal
public class PartitionTransformation<T>
extends StreamTransformation<T> {
    private final StreamTransformation<T> input;
    private final StreamPartitioner<T> partitioner;

    public PartitionTransformation(StreamTransformation<T> input, StreamPartitioner<T> partitioner) {
        super("Partition", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.partitioner = partitioner;
    }

    public StreamTransformation<T> getInput() {
        return this.input;
    }

    public StreamPartitioner<T> getPartitioner() {
        return this.partitioner;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        throw new UnsupportedOperationException("Cannot set chaining strategy on Union Transformation.");
    }
}

