/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PreviewPlanEnvironment;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;

@PublicEvolving
public class StreamPlanEnvironment
extends StreamExecutionEnvironment {
    private ExecutionEnvironment env;

    protected StreamPlanEnvironment(ExecutionEnvironment env) {
        this.env = env;
        int parallelism = env.getParallelism();
        if (parallelism > 0) {
            this.setParallelism(parallelism);
        } else {
            this.setParallelism(GlobalConfiguration.loadConfiguration().getInteger(CoreOptions.DEFAULT_PARALLELISM));
        }
    }

    @Override
    public JobExecutionResult execute() throws Exception {
        return this.execute("");
    }

    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        this.transformations.clear();
        if (this.env instanceof OptimizerPlanEnvironment) {
            ((OptimizerPlanEnvironment)this.env).setPlan((FlinkPlan)streamGraph);
        } else if (this.env instanceof PreviewPlanEnvironment) {
            ((PreviewPlanEnvironment)this.env).setPreview(streamGraph.getStreamingPlanAsJSON());
        }
        throw new OptimizerPlanEnvironment.ProgramAbortException();
    }
}

