/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;

@Internal
public class StreamEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String edgeId;
    private final int sourceId;
    private final int targetId;
    private final int typeNumber;
    private final List<String> selectedNames;
    private final OutputTag outputTag;
    private StreamPartitioner<?> outputPartitioner;
    private final String sourceOperatorName;
    private final String targetOperatorName;

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, List<String> selectedNames, StreamPartitioner<?> outputPartitioner, OutputTag outputTag) {
        this.sourceId = sourceVertex.getId();
        this.targetId = targetVertex.getId();
        this.typeNumber = typeNumber;
        this.selectedNames = selectedNames;
        this.outputPartitioner = outputPartitioner;
        this.outputTag = outputTag;
        this.sourceOperatorName = sourceVertex.getOperatorName();
        this.targetOperatorName = targetVertex.getOperatorName();
        this.edgeId = sourceVertex + "_" + targetVertex + "_" + typeNumber + "_" + selectedNames + "_" + outputPartitioner;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public List<String> getSelectedNames() {
        return this.selectedNames;
    }

    public OutputTag getOutputTag() {
        return this.outputTag;
    }

    public StreamPartitioner<?> getPartitioner() {
        return this.outputPartitioner;
    }

    public void setPartitioner(StreamPartitioner<?> partitioner) {
        this.outputPartitioner = partitioner;
    }

    public int hashCode() {
        return this.edgeId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamEdge that = (StreamEdge)o;
        return this.edgeId.equals(that.edgeId);
    }

    public String toString() {
        return "(" + this.sourceOperatorName + "-" + this.sourceId + " -> " + this.targetOperatorName + "-" + this.targetId + ", typeNumber=" + this.typeNumber + ", selectedNames=" + this.selectedNames + ", outputPartitioner=" + this.outputPartitioner + ", outputTag=" + this.outputTag + ')';
    }
}

