/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public class StreamSource<OUT, SRC extends SourceFunction<OUT>>
extends AbstractUdfStreamOperator<OUT, SRC> {
    private static final long serialVersionUID = 1L;
    private transient SourceFunction.SourceContext<OUT> ctx;
    private volatile transient boolean canceledOrStopped = false;

    public StreamSource(SRC sourceFunction) {
        super(sourceFunction);
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    public void run(Object lockingObject, StreamStatusMaintainer streamStatusMaintainer) throws Exception {
        this.run(lockingObject, streamStatusMaintainer, this.output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object lockingObject, StreamStatusMaintainer streamStatusMaintainer, Output<StreamRecord<OUT>> collector) throws Exception {
        TimeCharacteristic timeCharacteristic = this.getOperatorConfig().getTimeCharacteristic();
        Configuration configuration = this.getContainingTask().getEnvironment().getTaskManagerInfo().getConfiguration();
        long latencyTrackingInterval = this.getExecutionConfig().isLatencyTrackingConfigured() ? this.getExecutionConfig().getLatencyTrackingInterval() : configuration.getLong(MetricOptions.LATENCY_INTERVAL);
        LatencyMarksEmitter<OUT> latencyEmitter = null;
        if (latencyTrackingInterval > 0L) {
            latencyEmitter = new LatencyMarksEmitter<OUT>(this.getProcessingTimeService(), collector, latencyTrackingInterval, this.getOperatorID(), this.getRuntimeContext().getIndexOfThisSubtask());
        }
        long watermarkInterval = this.getRuntimeContext().getExecutionConfig().getAutoWatermarkInterval();
        this.ctx = StreamSourceContexts.getSourceContext(timeCharacteristic, this.getProcessingTimeService(), lockingObject, streamStatusMaintainer, collector, watermarkInterval, -1L);
        try {
            ((SourceFunction)this.userFunction).run(this.ctx);
            if (!this.isCanceledOrStopped()) {
                this.ctx.emitWatermark(Watermark.MAX_WATERMARK);
            }
        }
        finally {
            this.ctx.close();
            if (latencyEmitter != null) {
                latencyEmitter.close();
            }
        }
    }

    public void cancel() {
        this.markCanceledOrStopped();
        ((SourceFunction)this.userFunction).cancel();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    protected void markCanceledOrStopped() {
        this.canceledOrStopped = true;
    }

    protected boolean isCanceledOrStopped() {
        return this.canceledOrStopped;
    }

    private static class LatencyMarksEmitter<OUT> {
        private final ScheduledFuture<?> latencyMarkTimer;

        public LatencyMarksEmitter(final ProcessingTimeService processingTimeService, final Output<StreamRecord<OUT>> output, long latencyTrackingInterval, final OperatorID operatorId, final int subtaskIndex) {
            this.latencyMarkTimer = processingTimeService.scheduleAtFixedRate(new ProcessingTimeCallback(){

                @Override
                public void onProcessingTime(long timestamp) throws Exception {
                    try {
                        output.emitLatencyMarker(new LatencyMarker(processingTimeService.getCurrentProcessingTime(), operatorId, subtaskIndex));
                    }
                    catch (Throwable t) {
                        AbstractStreamOperator.LOG.warn("Error while emitting latency marker.", t);
                    }
                }
            }, 0L, latencyTrackingInterval);
        }

        public void close() {
            this.latencyMarkTimer.cancel(true);
        }
    }
}

