/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

public class AddPartitionsOperation
extends AlterTableOperation {
    private final boolean ignoreIfPartitionExists;
    private final List<CatalogPartitionSpec> partitionSpecs;
    private final List<CatalogPartition> catalogPartitions;

    public AddPartitionsOperation(ObjectIdentifier tableIdentifier, boolean ignoreIfPartitionExists, List<CatalogPartitionSpec> partitionSpecs, List<CatalogPartition> catalogPartitions) {
        super(tableIdentifier, false);
        this.ignoreIfPartitionExists = ignoreIfPartitionExists;
        this.partitionSpecs = partitionSpecs;
        this.catalogPartitions = catalogPartitions;
    }

    public List<CatalogPartitionSpec> getPartitionSpecs() {
        return this.partitionSpecs;
    }

    public List<CatalogPartition> getCatalogPartitions() {
        return this.catalogPartitions;
    }

    public boolean ignoreIfPartitionExists() {
        return this.ignoreIfPartitionExists;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("ALTER TABLE %s ADD", this.tableIdentifier.asSummaryString()));
        if (this.ignoreIfPartitionExists) {
            builder.append(" IF NOT EXISTS");
        }
        for (int i = 0; i < this.partitionSpecs.size(); ++i) {
            String spec = OperationUtils.formatPartitionSpec(this.partitionSpecs.get(i));
            builder.append(String.format(" PARTITION (%s)", spec));
            Map properties = this.catalogPartitions.get(i).getProperties();
            if (properties.isEmpty()) continue;
            builder.append(String.format(" WITH (%s)", OperationUtils.formatProperties(properties)));
        }
        return builder.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        List<CatalogPartitionSpec> specs = this.getPartitionSpecs();
        List<CatalogPartition> partitions = this.getCatalogPartitions();
        ObjectPath tablePath = this.getTableIdentifier().toObjectPath();
        try {
            for (int i = 0; i < specs.size(); ++i) {
                ctx.getCatalogManager().getCatalogOrThrowException(this.getTableIdentifier().getCatalogName()).createPartition(tablePath, specs.get(i), partitions.get(i), this.ignoreIfPartitionExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (TableNotExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

