/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;

@Internal
final class ReferenceResolverRule
implements ResolverRule {
    ReferenceResolverRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)new ExpressionResolverVisitor(context))).collect(Collectors.toList());
    }

    private class ExpressionResolverVisitor
    extends RuleExpressionVisitor<Expression> {
        ExpressionResolverVisitor(ResolverRule.ResolutionContext resolutionContext) {
            super(resolutionContext);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            Expression[] resolvedArgs = (Expression[])unresolvedCall.getChildren().stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)this)).toArray(Expression[]::new);
            return ApiExpressionUtils.unresolvedCall(unresolvedCall.getFunctionDefinition(), resolvedArgs);
        }

        @Override
        public Expression visit(UnresolvedReferenceExpression unresolvedReference) {
            return this.resolutionContext.referenceLookup().lookupField(unresolvedReference.getName()).map(expr -> expr).orElseGet(() -> this.resolutionContext.tableLookup().lookupTable(unresolvedReference.getName()).map(expr -> expr).orElseGet(() -> this.resolutionContext.getLocalReference(unresolvedReference.getName()).orElseThrow(() -> this.failForField(unresolvedReference))));
        }

        private ValidationException failForField(UnresolvedReferenceExpression fieldReference) {
            return new ValidationException(String.format("Cannot resolve field [%s], input field list:[%s].", fieldReference.getName(), String.join((CharSequence)", ", this.resolutionContext.referenceLookup().getAllInputFields().stream().map(FieldReferenceExpression::getName).collect(Collectors.toList()))));
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }
    }
}

