/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class ProjectQueryOperation
implements QueryOperation {
    private final List<ResolvedExpression> projectList;
    private final QueryOperation child;
    private final TableSchema tableSchema;

    public ProjectQueryOperation(List<ResolvedExpression> projectList, QueryOperation child, TableSchema tableSchema) {
        this.projectList = projectList;
        this.child = child;
        this.tableSchema = tableSchema;
    }

    public List<ResolvedExpression> getProjectList() {
        return this.projectList;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("projections", this.projectList);
        return OperationUtils.formatWithChildren("Project", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

