/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateTableOperation
implements CreateOperation {
    private final String[] tablePath;
    private CatalogTable catalogTable;
    private boolean ignoreIfExists;

    public CreateTableOperation(String[] tablePath, CatalogTable catalogTable, boolean ignoreIfExists) {
        this.tablePath = tablePath;
        this.catalogTable = catalogTable;
        this.ignoreIfExists = ignoreIfExists;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public String[] getTablePath() {
        return this.tablePath;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogTable", this.catalogTable.toProperties());
        params.put("tablePath", this.tablePath);
        params.put("ignoreIfExists", this.ignoreIfExists);
        return OperationUtils.formatWithChildren("CREATE TABLE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

