/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeValidator;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class BuiltInFunctionDefinition
implements FunctionDefinition {
    private final String name;
    private final FunctionKind kind;
    private final TypeInference typeInference;

    private BuiltInFunctionDefinition(String name, FunctionKind kind, TypeInference typeInference) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Name must not be null.");
        this.kind = (FunctionKind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (String)"Kind must not be null."));
        this.typeInference = (TypeInference)Preconditions.checkNotNull((Object)typeInference, (String)"Type inference must not be null.");
    }

    public String getName() {
        return this.name;
    }

    public TypeInference getTypeInference() {
        return this.typeInference;
    }

    @Override
    public FunctionKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.name;
    }

    public static class Builder {
        private String name;
        private FunctionKind kind;
        private TypeInference.Builder typeInferenceBuilder = new TypeInference.Builder();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder kind(FunctionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder inputTypeValidator(InputTypeValidator inputTypeValidator) {
            this.typeInferenceBuilder.inputTypeValidator(inputTypeValidator);
            return this;
        }

        public Builder accumulatorTypeStrategy(TypeStrategy accumulatorTypeStrategy) {
            this.typeInferenceBuilder.accumulatorTypeStrategy(accumulatorTypeStrategy);
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.typeInferenceBuilder.outputTypeStrategy(outputTypeStrategy);
            return this;
        }

        public Builder namedArguments(List<String> argumentNames) {
            this.typeInferenceBuilder.namedArguments(argumentNames);
            return this;
        }

        public Builder typedArguments(List<DataType> argumentTypes) {
            this.typeInferenceBuilder.typedArguments(argumentTypes);
            return this;
        }

        public BuiltInFunctionDefinition build() {
            return new BuiltInFunctionDefinition(this.name, this.kind, this.typeInferenceBuilder.build());
        }
    }
}

