/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;

public class LogicVisitor
implements RexBiVisitor<RelOptUtil.Logic, RelOptUtil.Logic> {
    private final RexNode seek;
    private final Collection<RelOptUtil.Logic> logicCollection;

    private LogicVisitor(RexNode seek, Collection<RelOptUtil.Logic> logicCollection) {
        this.seek = seek;
        this.logicCollection = logicCollection;
    }

    public static RelOptUtil.Logic find(RelOptUtil.Logic logic2, List<RexNode> nodes, RexNode seek) {
        EnumSet<RelOptUtil.Logic> set = EnumSet.noneOf(RelOptUtil.Logic.class);
        LogicVisitor visitor = new LogicVisitor(seek, set);
        for (RexNode node : nodes) {
            node.accept(visitor, logic2);
        }
        if (set.remove((Object)RelOptUtil.Logic.FALSE)) {
            set.add(RelOptUtil.Logic.UNKNOWN_AS_TRUE);
        }
        switch (set.size()) {
            case 0: {
                throw new IllegalArgumentException("not found: " + seek);
            }
            case 1: {
                return Iterables.getOnlyElement(set);
            }
        }
        return RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
    }

    public static void collect(RexNode node, RexNode seek, RelOptUtil.Logic logic2, List<RelOptUtil.Logic> logicList) {
        node.accept(new LogicVisitor(seek, logicList), logic2);
        Collections.replaceAll(logicList, RelOptUtil.Logic.FALSE, RelOptUtil.Logic.UNKNOWN_AS_TRUE);
    }

    @Override
    public RelOptUtil.Logic visitCall(RexCall call, RelOptUtil.Logic logic2) {
        RelOptUtil.Logic arg0 = logic2;
        switch (call.getKind()) {
            case IS_NOT_NULL: 
            case IS_NULL: {
                logic2 = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
                break;
            }
            case IS_TRUE: 
            case IS_NOT_TRUE: {
                logic2 = RelOptUtil.Logic.UNKNOWN_AS_FALSE;
                break;
            }
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                logic2 = RelOptUtil.Logic.UNKNOWN_AS_TRUE;
                break;
            }
            case NOT: {
                logic2 = logic2.negate2();
                break;
            }
            case CASE: {
                logic2 = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
            }
        }
        block7 : switch (logic2) {
            case TRUE: {
                switch (call.getKind()) {
                    case AND: {
                        break block7;
                    }
                }
                logic2 = RelOptUtil.Logic.TRUE_FALSE_UNKNOWN;
            }
        }
        for (RexNode operand : call.operands) {
            operand.accept(this, logic2);
        }
        return this.end(call, arg0);
    }

    private RelOptUtil.Logic end(RexNode node, RelOptUtil.Logic arg) {
        if (node.equals(this.seek)) {
            this.logicCollection.add(arg);
        }
        return arg;
    }

    @Override
    public RelOptUtil.Logic visitInputRef(RexInputRef inputRef, RelOptUtil.Logic arg) {
        return this.end(inputRef, arg);
    }

    @Override
    public RelOptUtil.Logic visitLocalRef(RexLocalRef localRef, RelOptUtil.Logic arg) {
        return this.end(localRef, arg);
    }

    @Override
    public RelOptUtil.Logic visitLiteral(RexLiteral literal, RelOptUtil.Logic arg) {
        return this.end(literal, arg);
    }

    @Override
    public RelOptUtil.Logic visitOver(RexOver over2, RelOptUtil.Logic arg) {
        return this.end(over2, arg);
    }

    @Override
    public RelOptUtil.Logic visitCorrelVariable(RexCorrelVariable correlVariable, RelOptUtil.Logic arg) {
        return this.end(correlVariable, arg);
    }

    @Override
    public RelOptUtil.Logic visitDynamicParam(RexDynamicParam dynamicParam, RelOptUtil.Logic arg) {
        return this.end(dynamicParam, arg);
    }

    @Override
    public RelOptUtil.Logic visitRangeRef(RexRangeRef rangeRef, RelOptUtil.Logic arg) {
        return this.end(rangeRef, arg);
    }

    @Override
    public RelOptUtil.Logic visitFieldAccess(RexFieldAccess fieldAccess, RelOptUtil.Logic arg) {
        return this.end(fieldAccess, arg);
    }

    @Override
    public RelOptUtil.Logic visitSubQuery(RexSubQuery subQuery, RelOptUtil.Logic arg) {
        if (!subQuery.getType().isNullable() && arg == RelOptUtil.Logic.TRUE_FALSE_UNKNOWN) {
            arg = RelOptUtil.Logic.TRUE_FALSE;
        }
        return this.end(subQuery, arg);
    }

    @Override
    public RelOptUtil.Logic visitTableInputRef(RexTableInputRef ref, RelOptUtil.Logic arg) {
        return this.end(ref, arg);
    }

    @Override
    public RelOptUtil.Logic visitPatternFieldRef(RexPatternFieldRef ref, RelOptUtil.Logic arg) {
        return this.end(ref, arg);
    }
}

