/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.jayway.jsonpath.spi.json;

import java.io.InputStream;
import java.util.Collection;
import java.util.Scanner;
import org.apache.flink.calcite.shaded.com.jayway.jsonpath.InvalidJsonException;
import org.apache.flink.calcite.shaded.com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONObject;

public class TapestryJsonProvider
extends AbstractJsonProvider {
    public static final TapestryJsonProvider INSTANCE = new TapestryJsonProvider();

    @Override
    public Object parse(String json) throws InvalidJsonException {
        return new JSONObject(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        Scanner sc = null;
        try {
            sc = new Scanner(jsonStream, charset);
            Object object = this.parse(sc.useDelimiter("\\A").next());
            return object;
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
    }

    @Override
    public String toJson(Object obj) {
        return ((JSONCollection)obj).toCompactString();
    }

    @Override
    public Object createArray() {
        return new JSONArray();
    }

    @Override
    public Object createMap() {
        return new JSONObject();
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        Object v;
        Object object = v = value == null ? JSONObject.NULL : value;
        if (this.isMap(obj)) {
            ((JSONObject)obj).put(key.toString(), v);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof JSONObject;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return ((JSONArray)obj).get(idx);
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        return ((JSONObject)obj).keys();
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        JSONObject json = (JSONObject)obj;
        if (!json.has(key)) {
            return UNDEFINED;
        }
        return json.get(key);
    }

    @Override
    public int length(Object obj) {
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).length();
        }
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).length();
        }
        throw new IllegalArgumentException("Cannot determine length of " + obj + ", unsupported type.");
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JSONArray;
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        Object v = newValue == null ? JSONObject.NULL : newValue;
        JSONArray list = (JSONArray)array;
        list.put(index, v);
    }
}

