/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.error.SqlParseException;

public class SqlCreateTable
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);
    private final SqlIdentifier tableName;
    private final SqlNodeList columnList;
    private final SqlNodeList propertyList;
    private final SqlNodeList primaryKeyList;
    private final List<SqlNodeList> uniqueKeysList;
    private final SqlNodeList partitionKeyList;
    private final SqlCharStringLiteral comment;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, SqlNodeList primaryKeyList, List<SqlNodeList> uniqueKeysList, SqlNodeList propertyList, SqlNodeList partitionKeyList, SqlCharStringLiteral comment) {
        super(OPERATOR, pos, false, false);
        this.tableName = Objects.requireNonNull(tableName, "Table name is missing");
        this.columnList = Objects.requireNonNull(columnList, "Column list should not be null");
        this.primaryKeyList = primaryKeyList;
        this.uniqueKeysList = uniqueKeysList;
        this.propertyList = propertyList;
        this.partitionKeyList = partitionKeyList;
        this.comment = comment;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableName, this.columnList, this.primaryKeyList, this.propertyList, this.partitionKeyList, this.comment);
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlNodeList getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public SqlNodeList getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    public List<SqlNodeList> getUniqueKeysList() {
        return this.uniqueKeysList;
    }

    public SqlCharStringLiteral getComment() {
        return this.comment;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public void validate() throws SqlParseException {
        HashSet<String> columnNames = new HashSet<String>();
        if (this.columnList != null) {
            for (SqlNode column : this.columnList) {
                SqlCall tableColumn;
                String columnName = null;
                if (column instanceof SqlTableColumn) {
                    tableColumn = (SqlTableColumn)column;
                    columnName = ((SqlTableColumn)tableColumn).getName().getSimple();
                } else if (column instanceof SqlBasicCall) {
                    tableColumn = (SqlBasicCall)column;
                    columnName = ((SqlBasicCall)tableColumn).getOperands()[1].toString();
                }
                if (columnNames.add(columnName)) continue;
                throw new SqlParseException(column.getParserPosition(), "Duplicate column name [" + columnName + "], at " + column.getParserPosition());
            }
        }
        if (this.primaryKeyList != null) {
            for (SqlNode primaryKeyNode : this.primaryKeyList) {
                String primaryKey = ((SqlIdentifier)primaryKeyNode).getSimple();
                if (columnNames.contains(primaryKey)) continue;
                throw new SqlParseException(primaryKeyNode.getParserPosition(), "Primary key [" + (String)primaryKey + "] not defined in columns, at " + primaryKeyNode.getParserPosition());
            }
        }
        if (this.uniqueKeysList != null) {
            for (SqlNodeList uniqueKeys : this.uniqueKeysList) {
                for (SqlNode uniqueKeyNode : uniqueKeys) {
                    String uniqueKey = ((SqlIdentifier)uniqueKeyNode).getSimple();
                    if (columnNames.contains(uniqueKey)) continue;
                    throw new SqlParseException(uniqueKeyNode.getParserPosition(), "Unique key [" + uniqueKey + "] not defined in columns, at " + uniqueKeyNode.getParserPosition());
                }
            }
        }
        if (this.partitionKeyList != null) {
            for (SqlNode partitionKeyNode : this.partitionKeyList.getList()) {
                String partitionKey = ((SqlIdentifier)partitionKeyNode).getSimple();
                if (columnNames.contains(partitionKey)) continue;
                throw new SqlParseException(partitionKeyNode.getParserPosition(), "Partition column [" + partitionKey + "] not defined in columns, at " + partitionKeyNode.getParserPosition());
            }
        }
    }

    public boolean containsComputedColumn() {
        for (SqlNode column : this.columnList) {
            if (!(column instanceof SqlBasicCall)) continue;
            return true;
        }
        return false;
    }

    public String getColumnSqlString() {
        SqlPrettyWriter writer = new SqlPrettyWriter(AnsiSqlDialect.DEFAULT);
        writer.setAlwaysUseParentheses(true);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        writer.startList("", "");
        for (SqlNode column : this.columnList) {
            writer.sep(",");
            if (column instanceof SqlTableColumn) {
                SqlTableColumn tableColumn = (SqlTableColumn)column;
                tableColumn.getName().unparse(writer, 0, 0);
                continue;
            }
            column.unparse(writer, 0, 0);
        }
        return writer.toString();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame withFrame;
        writer.keyword("CREATE TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        for (SqlNode column : this.columnList) {
            this.printIndent(writer);
            if (column instanceof SqlBasicCall) {
                SqlCall call = (SqlCall)column;
                SqlCall newCall = call.getOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(1), call.operand(0)});
                newCall.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            column.unparse(writer, leftPrec, rightPrec);
        }
        if (this.primaryKeyList != null && this.primaryKeyList.size() > 0) {
            this.printIndent(writer);
            writer.keyword("PRIMARY KEY");
            SqlWriter.Frame keyFrame = writer.startList("(", ")");
            this.primaryKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(keyFrame);
        }
        if (this.uniqueKeysList != null && this.uniqueKeysList.size() > 0) {
            this.printIndent(writer);
            for (SqlNodeList uniqueKeyList : this.uniqueKeysList) {
                writer.keyword("UNIQUE");
                SqlWriter.Frame keyFrame = writer.startList("(", ")");
                uniqueKeyList.unparse(writer, leftPrec, rightPrec);
                writer.endList(keyFrame);
            }
        }
        writer.newlineAndIndent();
        writer.endList(frame);
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.partitionKeyList != null && this.partitionKeyList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            withFrame = writer.startList("(", ")");
            this.partitionKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(withFrame);
            writer.newlineAndIndent();
        }
        if (this.propertyList != null) {
            writer.keyword("WITH");
            withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }

    public static class TableCreationContext {
        public List<SqlNode> columnList = new ArrayList<SqlNode>();
        public SqlNodeList primaryKeyList;
        public List<SqlNodeList> uniqueKeysList = new ArrayList<SqlNodeList>();
    }
}

