/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.datastream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.datastream.DataStreamSort;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.plan.rules.datastream.DataStreamSortRule$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001#\t\u0011B)\u0019;b'R\u0014X-Y7T_J$(+\u001e7f\u0015\t\u0019A!\u0001\u0006eCR\f7\u000f\u001e:fC6T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CG\u0007\u0002))\u0011QCF\u0001\bG>tg/\u001a:u\u0015\t9\u0002$A\u0002sK2T!!\u0007\u0007\u0002\u000f\r\fGnY5uK&\u00111\u0004\u0006\u0002\u000e\u0007>tg/\u001a:uKJ\u0014V\u000f\\3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u001a\u0013aB7bi\u000eDWm\u001d\u000b\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012qAQ8pY\u0016\fg\u000eC\u0003,C\u0001\u0007A&\u0001\u0003dC2d\u0007CA\u00170\u001b\u0005q#BA\u0004\u0019\u0013\t\u0001dF\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000bU\u0001A\u0011\t\u001a\u0015\u0005M:\u0004C\u0001\u001b6\u001b\u00051\u0012B\u0001\u001c\u0017\u0005\u001d\u0011V\r\u001c(pI\u0016DQaF\u0019A\u0002MBQ!\u000f\u0001\u0005\u0002i\nab\u00195fG.$\u0016.\\3Pe\u0012,'\u000f\u0006\u0002%w!)A\b\u000fa\u0001{\u0005!1o\u001c:u!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0004m_\u001eL7-\u00197\u000b\u0005\t3\u0011!\u00028pI\u0016\u001c\u0018B\u0001#@\u0005A1E.\u001b8l\u0019><\u0017nY1m'>\u0014HoB\u0003G\u0005!\u0005q)\u0001\nECR\f7\u000b\u001e:fC6\u001cvN\u001d;Sk2,\u0007C\u0001\u0011I\r\u0015\t!\u0001#\u0001J'\tA%\n\u0005\u0002&\u0017&\u0011AJ\n\u0002\u0007\u0003:L(+\u001a4\t\u000buAE\u0011\u0001(\u0015\u0003\u001dCq\u0001\u0015%C\u0002\u0013\u0005\u0011+\u0001\u0005J\u001dN#\u0016IT\"F+\u0005\u0011\u0006CA\u0017T\u0013\t!fF\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016DaA\u0016%!\u0002\u0013\u0011\u0016!C%O'R\u000bejQ#!\u0001")
public class DataStreamSortRule
extends ConverterRule {
    public static RelOptRule INSTANCE() {
        return DataStreamSortRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalSort sort = (FlinkLogicalSort)call.rel(0);
        return this.checkTimeOrder(sort);
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalSort sort = (FlinkLogicalSort)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.DATASTREAM());
        RelNode convInput = RelOptRule.convert(sort.getInput(0), FlinkConventions$.MODULE$.DATASTREAM());
        RelDataType inputRowType = ((RelSubset)convInput).getOriginal().getRowType();
        return new DataStreamSort(rel.getCluster(), traitSet, convInput, new RowSchema(inputRowType), new RowSchema(rel.getRowType()), sort.collation, sort.offset, sort.fetch, this.description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTimeOrder(FlinkLogicalSort sort) {
        RelCollation sortCollation = sort.collation;
        if (sortCollation.getFieldCollations().size() == 0) {
            return false;
        }
        RelDataType firstSortType = SortUtil$.MODULE$.getFirstSortField(sortCollation, sort.getRowType()).getType();
        RelFieldCollation.Direction firstSortDirection = SortUtil$.MODULE$.getFirstSortDirection(sortCollation);
        if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(firstSortType)) return false;
        RelFieldCollation.Direction direction = firstSortDirection;
        RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
        if (direction != null) {
            if (!((Object)((Object)direction)).equals((Object)direction2)) return false;
            return true;
        }
        if (direction2 == null) return true;
        return false;
    }

    public DataStreamSortRule() {
        super(FlinkLogicalSort.class, FlinkConventions$.MODULE$.LOGICAL(), FlinkConventions$.MODULE$.DATASTREAM(), "DataStreamSortRule");
    }
}

