/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001f\tAC)\u0019;b'\u0016$8\u000b\\5eKRKW.Z,j]\u0012|w/Q4h\r2\fG/T1q\rVt7\r^5p]*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011AA!\u0011\u0003\u0007\u000e\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003%1WO\\2uS>t7O\u0003\u0002\u0016-\u000511m\\7n_:T!a\u0006\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001a%\t\u0019\"+[2i\r2\fG/T1q\rVt7\r^5p]B\u00111DH\u0007\u00029)\u0011Q\u0004C\u0001\u0006if\u0004Xm]\u0005\u0003?q\u00111AU8x!\r\tcEG\u0007\u0002E)\u00111\u0005J\u0001\nif\u0004X-\u001e;jYNT!!\n\f\u0002\t)\fg/Y\u0005\u0003O\t\u00121CU3tk2$H+\u001f9f#V,'/_1cY\u0016D\u0001\"\u000b\u0001\u0003\u0006\u0004%IAK\u0001\ri&lWMR5fY\u0012\u0004vn]\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t\u0019\u0011J\u001c;\t\u0011I\u0002!\u0011!Q\u0001\n-\nQ\u0002^5nK\u001aKW\r\u001c3Q_N\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011B\u001b\u0002\u0015]Lg\u000eZ8x'&TX-F\u00017!\tas'\u0003\u00029[\t!Aj\u001c8h\u0011!Q\u0004A!A!\u0002\u00131\u0014aC<j]\u0012|woU5{K\u0002B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%I!N\u0001\fo&tGm\\<TY&$W\r\u0003\u0005?\u0001\t\u0005\t\u0015!\u00037\u000319\u0018N\u001c3poNc\u0017\u000eZ3!\u0011!\u0001\u0005A!b\u0001\n\u0013\t\u0015A\u0003:fiV\u0014h\u000eV=qKV\t!\tE\u0002D\rji\u0011\u0001\u0012\u0006\u0003\u000bR\t\u0001\u0002^=qK&tgm\\\u0005\u0003\u000f\u0012\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0005\u0006Y!/\u001a;ve:$\u0016\u0010]3!Q\tA5\n\u0005\u0002-\u0019&\u0011Q*\f\u0002\niJ\fgn]5f]RDQa\u0014\u0001\u0005\u0002A\u000ba\u0001P5oSRtD#B)T)V3\u0006C\u0001*\u0001\u001b\u0005\u0011\u0001\"B\u0015O\u0001\u0004Y\u0003\"\u0002\u001bO\u0001\u00041\u0004\"\u0002\u001fO\u0001\u00041\u0004\"\u0002!O\u0001\u0004\u0011\u0005\"\u0002-\u0001\t\u0003J\u0016a\u00024mCRl\u0015\r\u001d\u000b\u00045v{\u0006C\u0001\u0017\\\u0013\taVF\u0001\u0003V]&$\b\"\u00020X\u0001\u0004Q\u0012A\u0002:fG>\u0014H\rC\u0003a/\u0002\u0007\u0011-A\u0002pkR\u00042AY3\u001b\u001b\u0005\u0019'B\u00013\t\u0003\u0011)H/\u001b7\n\u0005\u0019\u001c'!C\"pY2,7\r^8s\u0011\u0015A\u0007\u0001\"\u0011j\u0003=9W\r\u001e)s_\u0012,8-\u001a3UsB,G#\u0001\"")
public class DataSetSlideTimeWindowAggFlatMapFunction
extends RichFlatMapFunction<Row, Row>
implements ResultTypeQueryable<Row> {
    private final int timeFieldPos;
    private final long windowSize;
    private final long windowSlide;
    private final transient TypeInformation<Row> returnType;

    private int timeFieldPos() {
        return this.timeFieldPos;
    }

    private long windowSize() {
        return this.windowSize;
    }

    private long windowSlide() {
        return this.windowSlide;
    }

    private TypeInformation<Row> returnType() {
        return this.returnType;
    }

    public void flatMap(Row record, Collector<Row> out) {
        long windowStart = BoxesRunTime.unboxToLong((Object)record.getField(this.timeFieldPos()));
        for (long start = TimeWindow.getWindowStartWithOffset((long)windowStart, (long)0L, (long)this.windowSlide()); start > windowStart - this.windowSize(); start -= this.windowSlide()) {
            record.setField(this.timeFieldPos(), (Object)BoxesRunTime.boxToLong((long)start));
            out.collect((Object)record);
        }
    }

    public TypeInformation<Row> getProducedType() {
        return this.returnType();
    }

    public DataSetSlideTimeWindowAggFlatMapFunction(int timeFieldPos, long windowSize, long windowSlide, TypeInformation<Row> returnType) {
        this.timeFieldPos = timeFieldPos;
        this.windowSize = windowSize;
        this.windowSlide = windowSlide;
        this.returnType = returnType;
    }
}

