/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.RichWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.table.runtime.TableAggregateCollector;
import org.apache.flink.table.runtime.aggregate.GeneratedTableAggregations;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001=\u0011!%\u00138de\u0016lWM\u001c;bY\u0006;wM]3hCR,w+\u001b8e_^4UO\\2uS>t'BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0003!)\u001a\"\u0001A\t\u0011\rIYRdI\u000f)\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003%9\u0018N\u001c3po&twM\u0003\u0002\u0017/\u0005Ia-\u001e8di&|gn\u001d\u0006\u00031e\t1!\u00199j\u0015\tQ\u0002\"A\u0005tiJ,\u0017-\\5oO&\u0011Ad\u0005\u0002\u0013%&\u001c\u0007nV5oI><h)\u001e8di&|g\u000e\u0005\u0002\u001fC5\tqD\u0003\u0002!\u0011\u0005)A/\u001f9fg&\u0011!e\b\u0002\u0004%><\bC\u0001\u0013'\u001b\u0005)#B\u0001\u0011\u0005\u0013\t9SE\u0001\u0003D%><\bCA\u0015+\u0019\u0001!Qa\u000b\u0001C\u00021\u0012\u0011aV\t\u0003[M\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012qAT8uQ&tw\r\u0005\u00025q5\tQG\u0003\u00027o\u00059q/\u001b8e_^\u001c(B\u0001\u000b\u0018\u0013\tITG\u0001\u0004XS:$wn\u001e\u0005\tw\u0001\u0011)\u0019!C\u0005y\u0005qa.^7He>,\b/\u001b8h\u0017\u0016LX#A\u001f\u0011\u00059r\u0014BA 0\u0005\rIe\u000e\u001e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{\u0005ya.^7He>,\b/\u001b8h\u0017\u0016L\b\u0005\u0003\u0005D\u0001\t\u0015\r\u0011\"\u0003=\u00035qW/\\!hOJ,w-\u0019;fg\"AQ\t\u0001B\u0001B\u0003%Q(\u0001\bok6\fum\u001a:fO\u0006$Xm\u001d\u0011\t\u0011\u001d\u0003!Q1A\u0005\nq\nQBZ5oC2\u0014vn^!sSRL\b\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001d\u0019Lg.\u00197S_^\f%/\u001b;zA!A1\n\u0001BC\u0002\u0013%A*\u0001\tjgR\u000b'\r\\3BO\u001e\u0014XmZ1uKV\tQ\n\u0005\u0002/\u001d&\u0011qj\f\u0002\b\u0005>|G.Z1o\u0011!\t\u0006A!A!\u0002\u0013i\u0015!E5t)\u0006\u0014G.Z!hOJ,w-\u0019;fA!)1\u000b\u0001C\u0001)\u00061A(\u001b8jiz\"R!V,Y3j\u00032A\u0016\u0001)\u001b\u0005\u0011\u0001\"B\u001eS\u0001\u0004i\u0004\"B\"S\u0001\u0004i\u0004\"B$S\u0001\u0004i\u0004\"B&S\u0001\u0004i\u0005\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0003\u0019yW\u000f\u001e9viV\t1\u0005C\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\u0006Qq.\u001e;qkR|F%Z9\u0015\u0005\u0005$\u0007C\u0001\u0018c\u0013\t\u0019wF\u0001\u0003V]&$\bbB3_\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004BB4\u0001A\u0003&1%A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0013Q\u0017aD2p]\u000e\fGoQ8mY\u0016\u001cGo\u001c:\u0016\u0003-\u0004\"\u0001\\7\u000e\u0003\u0011I!A\u001c\u0003\u0003/Q\u000b'\r\\3BO\u001e\u0014XmZ1uK\u000e{G\u000e\\3di>\u0014\b\"\u00039\u0001\u0001\u0004\u0005\r\u0011\"\u0003r\u0003M\u0019wN\\2bi\u000e{G\u000e\\3di>\u0014x\fJ3r)\t\t'\u000fC\u0004f_\u0006\u0005\t\u0019A6\t\rQ\u0004\u0001\u0015)\u0003l\u0003A\u0019wN\\2bi\u000e{G\u000e\\3di>\u0014\b\u0005C\u0003w\u0001\u0011\u0005s/\u0001\u0003pa\u0016tGCA1y\u0011\u0015IX\u000f1\u0001{\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0003wzl\u0011\u0001 \u0006\u0003{\"\tQbY8oM&<WO]1uS>t\u0017BA@}\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011!B1qa2LH#C1\u0002\b\u0005-\u0011qBA\u0012\u0011\u001d\tI!!\u0001A\u0002u\t1a[3z\u0011\u001d\ti!!\u0001A\u0002!\naa^5oI><\b\u0002CA\t\u0003\u0003\u0001\r!a\u0005\u0002\u000fI,7m\u001c:egB)\u0011QCA\u0010;5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\t\u0013R,'/\u00192mK\"A\u0011QEA\u0001\u0001\u0004\t9#A\u0002pkR\u0004R!!\u000b\u00020\rj!!a\u000b\u000b\u0007\u00055\u0002\"\u0001\u0003vi&d\u0017\u0002BA\u0019\u0003W\u0011\u0011bQ8mY\u0016\u001cGo\u001c:")
public class IncrementalAggregateWindowFunction<W extends Window>
extends RichWindowFunction<Row, CRow, Row, W> {
    private final int numGroupingKey;
    private final int numAggregates;
    private final int finalRowArity;
    private final boolean isTableAggregate;
    private CRow output;
    private TableAggregateCollector concatCollector;

    private int numGroupingKey() {
        return this.numGroupingKey;
    }

    private int numAggregates() {
        return this.numAggregates;
    }

    private int finalRowArity() {
        return this.finalRowArity;
    }

    private boolean isTableAggregate() {
        return this.isTableAggregate;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private TableAggregateCollector concatCollector() {
        return this.concatCollector;
    }

    private void concatCollector_$eq(TableAggregateCollector x$1) {
        this.concatCollector = x$1;
    }

    public void open(Configuration parameters) {
        this.output_$eq(new CRow(new Row(this.finalRowArity()), true));
        if (this.isTableAggregate()) {
            this.concatCollector_$eq(new TableAggregateCollector(this.numGroupingKey()));
            this.concatCollector().setResultRow(this.output().row());
        }
    }

    public void apply(Row key, W window, Iterable<Row> records, Collector<CRow> out) {
        Iterator<Row> iterator = records.iterator();
        if (iterator.hasNext()) {
            int i;
            Row record = iterator.next();
            for (i = 0; i < this.numGroupingKey(); ++i) {
                this.output().row().setField(i, key.getField(i));
            }
            if (this.isTableAggregate()) {
                this.concatCollector().out_$eq(out);
                Row accumulator = (Row)record.getField(0);
                GeneratedTableAggregations func = (GeneratedTableAggregations)record.getField(1);
                func.emit(accumulator, this.concatCollector());
            } else {
                for (i = 0; i < this.numAggregates(); ++i) {
                    this.output().row().setField(this.numGroupingKey() + i, record.getField(i));
                }
                out.collect((Object)this.output());
            }
        }
    }

    public IncrementalAggregateWindowFunction(int numGroupingKey, int numAggregates, int finalRowArity, boolean isTableAggregate) {
        this.numGroupingKey = numGroupingKey;
        this.numAggregates = numAggregates;
        this.finalRowArity = finalRowArity;
        this.isTableAggregate = isTableAggregate;
    }
}

