/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.runtime.join.NonWindowOuterJoinWithNonEquiPredicates;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001=\u00111FT8o/&tGm\\<MK\u001a$(+[4ii*{\u0017N\\,ji\"tuN\\#rk&\u0004&/\u001a3jG\u0006$Xm\u001d\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!a\n(p]^Kg\u000eZ8x\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5Qe\u0016$\u0017nY1uKND\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\tY\u00164G\u000fV=qKB\u0019qC\b\u0011\u000e\u0003aQ!!\u0007\u000e\u0002\u0011QL\b/Z5oM>T!a\u0007\u000f\u0002\r\r|W.\\8o\u0015\ti\u0002\"A\u0002ba&L!a\b\r\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"!\t\u0013\u000e\u0003\tR!a\t\u0005\u0002\u000bQL\b/Z:\n\u0005\u0015\u0012#a\u0001*po\"Aq\u0005\u0001B\u0001B\u0003%a#A\u0005sS\u001eDG\u000fV=qK\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\bhK:Tu.\u001b8Gk:\u001cg*Y7f!\tY\u0013G\u0004\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001T&\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019.\u0011!)\u0004A!A!\u0002\u0013Q\u0013aD4f]*{\u0017N\u001c$v]\u000e\u001cu\u000eZ3\t\u0011]\u0002!\u0011!Q\u0001\na\n!\"[:MK\u001a$(j\\5o!\ta\u0013(\u0003\u0002;[\t9!i\\8mK\u0006t\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0003}\u0001k\u0011a\u0010\u0006\u0003;\u0019I!!Q \u0003#M#(/Z1n#V,'/_\"p]\u001aLw\rC\u0003D\u0001\u0011\u0005A)\u0001\u0004=S:LGO\u0010\u000b\b\u000b\u001a;\u0005*\u0013&L!\t\t\u0002\u0001C\u0003\u0016\u0005\u0002\u0007a\u0003C\u0003(\u0005\u0002\u0007a\u0003C\u0003*\u0005\u0002\u0007!\u0006C\u00036\u0005\u0002\u0007!\u0006C\u00038\u0005\u0002\u0007\u0001\bC\u0003=\u0005\u0002\u0007Q\bC\u0003N\u0001\u0011\u0005c*\u0001\u0003pa\u0016tGCA(S!\ta\u0003+\u0003\u0002R[\t!QK\\5u\u0011\u0015\u0019F\n1\u0001U\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/\"\tQbY8oM&<WO]1uS>t\u0017BA-W\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")1\f\u0001C!9\u0006q\u0001O]8dKN\u001cX\t\\3nK:$H#C(^IRd\u0018qDA\u0012\u0011\u0015q&\f1\u0001`\u0003\u00151\u0018\r\\;f!\t\u0001'-D\u0001b\u0015\t\u0019C!\u0003\u0002dC\n!1IU8x\u0011\u0015)'\f1\u0001g\u0003\r\u0019G\u000f\u001f\t\u0003OJ\u0004R\u0001\u001b9`?~k\u0011!\u001b\u0006\u0003U.\f!aY8\u000b\u00051l\u0017!\u00034v]\u000e$\u0018n\u001c8t\u0015\tibN\u0003\u0002p\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003c&\u0014\u0011cQ8Qe>\u001cWm]:Gk:\u001cG/[8o\u0013\t\u0019\bOA\u0004D_:$X\r\u001f;\t\u000bUT\u0006\u0019\u0001<\u0002\u0007=,H\u000fE\u0002xu~k\u0011\u0001\u001f\u0006\u0003s\"\tA!\u001e;jY&\u00111\u0010\u001f\u0002\n\u0007>dG.Z2u_JDQ! .A\u0002y\f\u0001cY;se\u0016tGoU5eKN#\u0018\r^3\u0011\r}\f)\u0001IA\u0005\u001b\t\t\tAC\u0002\u0002\u0004i\tQa\u001d;bi\u0016LA!a\u0002\u0002\u0002\tAQ*\u00199Ti\u0006$X\r\u0005\u0005\u0002\f\u0005U\u0011\u0011DA\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!\u0002;va2,'bAA\n9\u0005!!.\u0019<b\u0013\u0011\t9\"!\u0004\u0003\rQ+\b\u000f\\33!\ra\u00131D\u0005\u0004\u0003;i#\u0001\u0002'p]\u001eDa!!\t[\u0001\u0004q\u0018AD8uQ\u0016\u00148+\u001b3f'R\fG/\u001a\u0005\u0007\u0003KQ\u0006\u0019\u0001\u001d\u0002\u001dI,7m\u001c:e\rJ|W\u000eT3gi\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012aB8o)&lWM\u001d\u000b\b\u001f\u00065\u0012\u0011GA\u001d\u0011!\ty#a\nA\u0002\u0005e\u0011!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d)\u0017q\u0005a\u0001\u0003g\u00012aZA\u001b\u0013\r\t9\u0004\u001d\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011\u0019)\u0018q\u0005a\u0001m\u0002")
public class NonWindowLeftRightJoinWithNonEquiPredicates
extends NonWindowOuterJoinWithNonEquiPredicates {
    private final boolean isLeftJoin;

    @Override
    public void open(Configuration parameters) {
        super.open(parameters);
        String joinType = this.isLeftJoin ? "Left" : "Right";
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Instantiating NonWindow", "JoinWithNonEquiPredicates."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinType})));
    }

    @Override
    public void processElement(CRow value, CoProcessFunction.Context ctx, Collector<CRow> out, MapState<Row, Tuple2<Object, Object>> currentSideState, MapState<Row, Tuple2<Object, Object>> otherSideState, boolean recordFromLeft) {
        MapState<Row, Object> currentJoinCntState = this.getJoinCntState(this.joinCntState(), recordFromLeft);
        Row inputRow = value.row();
        Tuple2<Object, Object> cntAndExpiredTime = this.updateCurrentSide(value, ctx, currentSideState);
        if (!value.change() && BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) <= 0L && recordFromLeft == this.isLeftJoin) {
            currentJoinCntState.remove((Object)inputRow);
        }
        this.cRowWrapper().reset();
        this.cRowWrapper().setCollector(out);
        this.cRowWrapper().setChange(value.change());
        if (recordFromLeft == this.isLeftJoin) {
            long joinCnt = this.preservedJoin(inputRow, recordFromLeft, otherSideState);
            if (BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) == 1L && value.change()) {
                currentJoinCntState.put((Object)inputRow, (Object)BoxesRunTime.boxToLong((long)joinCnt));
            }
        } else {
            MapState<Row, Object> otherSideJoinCntState = this.getJoinCntState(this.joinCntState(), !recordFromLeft);
            this.retractJoinWithNonEquiPreds(value, recordFromLeft, otherSideState, otherSideJoinCntState);
        }
    }

    @Override
    public void onTimer(long timestamp, CoProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.stateCleaningEnabled()) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.leftState(), this.rightState(), this.getJoinCntState(this.joinCntState(), this.isLeftJoin)}));
        }
    }

    public NonWindowLeftRightJoinWithNonEquiPredicates(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, boolean isLeftJoin, StreamQueryConfig queryConfig) {
        this.isLeftJoin = isLeftJoin;
        super(leftType, rightType, genJoinFuncName, genJoinFuncCode, isLeftJoin, queryConfig);
    }
}

