/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.PolyNull;

public class SerializableCharset
implements Serializable {
    private Charset charset;
    private String charsetName;

    private SerializableCharset(Charset charset) {
        assert (charset != null);
        this.charset = charset;
        this.charsetName = charset.name();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.charset.name());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.charsetName = (String)in.readObject();
        this.charset = (Charset)Objects.requireNonNull(Charset.availableCharsets().get(this.charsetName), () -> "charset is not found: " + this.charsetName);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static @PolyNull SerializableCharset forCharset(@PolyNull Charset charset) {
        if (charset == null) {
            return null;
        }
        return new SerializableCharset(charset);
    }
}

