/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg.batch;

import java.io.Serializable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.util.SingleElementIterator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.DeclarativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator$;
import org.apache.flink.table.planner.codegen.agg.batch.AggCodeGenHelper;
import org.apache.flink.table.planner.expressions.DeclarativeExpressionResolver;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.utils.AggregateInfo;
import org.apache.flink.table.runtime.context.ExecutionContextImpl;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class AggCodeGenHelper$ {
    public static AggCodeGenHelper$ MODULE$;

    static {
        new AggCodeGenHelper$();
    }

    public String[][] getAggBufferNames(String aggBufferPrefix, int[] auxGrouping, Seq<AggregateInfo> aggInfos) {
        IndexedSeq auxGroupingNames = (IndexedSeq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).indices().map((Function1 & Serializable & scala.Serializable)index -> AggCodeGenHelper$.$anonfun$getAggBufferNames$1(aggBufferPrefix, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq aggNames = (Seq)aggInfos.map((Function1 & Serializable & scala.Serializable)aggInfo -> {
            String[] stringArray;
            int aggBufferIdx = auxGrouping.length + aggInfo.aggIndex();
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
                DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.aggBufferAttributes())).map((Function1 & Serializable & scala.Serializable)attr -> new StringBuilder(5).append(aggBufferPrefix).append("_agg").append(aggBufferIdx).append("_").append(attr.getName()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            } else if (userDefinedFunction instanceof AggregateFunction) {
                stringArray = (String[])((Object[])new String[]{new StringBuilder(4).append(aggBufferPrefix).append("_agg").append(aggBufferIdx).toString()});
            } else {
                throw new MatchError((Object)userDefinedFunction);
            }
            return stringArray;
        }, Seq$.MODULE$.canBuildFrom());
        return (String[][])((TraversableOnce)auxGroupingNames.$plus$plus((GenTraversableOnce)aggNames, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    public LogicalType[][] getAggBufferTypes(RowType inputType, int[] auxGrouping, Seq<AggregateInfo> aggInfos) {
        LogicalType[][] auxGroupingTypes = (LogicalType[][])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).map((Function1 & Serializable & scala.Serializable)index -> AggCodeGenHelper$.$anonfun$getAggBufferTypes$1(inputType, BoxesRunTime.unboxToInt((Object)index)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(LogicalType.class))));
        Seq aggTypes = (Seq)aggInfos.map((Function1 & Serializable & scala.Serializable)x$12 -> (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$12.externalAccTypes())).map((Function1 & Serializable & scala.Serializable)x$1 -> LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))), Seq$.MODULE$.canBuildFrom());
        return (LogicalType[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])auxGroupingTypes)).$plus$plus((GenTraversableOnce)aggTypes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(LogicalType.class))));
    }

    public Map<AggregateFunction<?, ?>, String> getFunctionIdentifiers(Seq<AggregateInfo> aggInfos) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)aggInfos.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.function(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)AggCodeGenHelper$.$anonfun$getFunctionIdentifiers$2(a)))).map((Function1 & Serializable & scala.Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), (Object)CodeGenUtils$.MODULE$.udfFieldName((UserDefinedFunction)a)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String addAggsHandler(GeneratedAggsHandleFunction aggsHandler, CodeGeneratorContext ctx, CodeGeneratorContext aggsHandlerCtx) {
        ctx.addReusableInnerClass(aggsHandler.getClassName(), aggsHandler.getCode());
        String handler = CodeGenUtils$.MODULE$.newName("handler");
        ctx.addReusableMember(new StringBuilder(9).append(aggsHandler.getClassName()).append(" ").append(handler).append(" = null;").toString());
        String aggRefers = ctx.addReusableObject(aggsHandlerCtx.references().toArray(ClassTag$.MODULE$.AnyRef()), "Object[]", ctx.addReusableObject$default$3());
        ctx.addReusableOpenStatement(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n         |").append(handler).append(" = new ").append(aggsHandler.getClassName()).append("(").append(aggRefers).append(");\n         |").append(handler).append(".open(new ").append(ExecutionContextImpl.class.getCanonicalName()).append("(\n         |  this, getRuntimeContext()));\n       ").toString())).stripMargin());
        ctx.addReusableCloseStatement(new StringBuilder(9).append(handler).append(".close();").toString());
        return handler;
    }

    public String genGroupKeyChangedCheckCode(String currentKeyTerm, String lastKeyTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(269).append("\n       |").append(currentKeyTerm).append(".getSizeInBytes() != ").append(lastKeyTerm).append(".getSizeInBytes() ||\n       |  !(org.apache.flink.table.data.binary.BinaryRowDataUtil.byteArrayEquals(\n       |     ").append(currentKeyTerm).append(".getSegments()[0].getHeapMemory(),\n       |     ").append(lastKeyTerm).append(".getSegments()[0].getHeapMemory(),\n       |     ").append(currentKeyTerm).append(".getSizeInBytes()))\n       ").toString())).stripMargin().trim();
    }

    public Tuple3<String, String, GeneratedExpression> genSortAggCodes(boolean isMerge, boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, int[] grouping, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, String inputTerm, RowType inputType, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, RowType outputType, boolean forHashAgg) {
        Tuple2<Object, LogicalType>[][] argsMapping = this.buildAggregateArgsMapping(isMerge, grouping.length, inputType, auxGrouping, aggInfos, aggBufferTypes);
        Seq<GeneratedExpression> aggBufferExprs = this.genFlatAggBufferExprs(isMerge, ctx, builder, auxGrouping, aggInfos, argsMapping, aggBufferPrefix, aggBufferNames, aggBufferTypes);
        String initAggBufferCode = this.genInitFlatAggregateBuffer(ctx, builder, inputType, inputTerm, grouping, auxGrouping, aggInfos, functionIdentifiers, aggBufferExprs, forHashAgg);
        String doAggregateCode = this.genAggregateByFlatAggregateBuffer(isMerge, ctx, builder, inputType, inputTerm, auxGrouping, aggInfos, functionIdentifiers, argsMapping, aggBufferPrefix, aggBufferNames, aggBufferTypes, aggBufferExprs);
        GeneratedExpression aggOutputExpr = this.genSortAggOutputExpr(isMerge, isFinal, ctx, builder, grouping, auxGrouping, aggInfos, functionIdentifiers, argsMapping, aggBufferPrefix, aggBufferNames, aggBufferTypes, aggBufferExprs, outputType);
        return new Tuple3((Object)initAggBufferCode, (Object)doAggregateCode, (Object)aggOutputExpr);
    }

    public boolean genSortAggCodes$default$15() {
        return false;
    }

    public Tuple2<Object, LogicalType>[][] buildAggregateArgsMapping(boolean isMerge, int aggBufferOffset, RowType inputType, int[] auxGrouping, Seq<AggregateInfo> aggInfos, LogicalType[][] aggBufferTypes) {
        Tuple2[][] tuple2Array;
        int[][] aggArgs = (int[][])((TraversableOnce)aggInfos.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.argIndexes(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        Tuple2[][] auxGroupingMapping = (Tuple2[][])((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).indices().map((Function1 & Serializable & scala.Serializable)i -> AggCodeGenHelper$.$anonfun$buildAggregateArgsMapping$2(aggBufferTypes, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        if (isMerge) {
            IntRef offset = IntRef.create((int)(aggBufferOffset + auxGrouping.length));
            tuple2Array = (Tuple2[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes)).slice(auxGrouping.length, aggBufferTypes.length))).map((Function1 & Serializable & scala.Serializable)types -> {
                int baseOffset = offset$1.elem;
                offset$1.elem += ((LogicalType[])types).length;
                return (Tuple2[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])types)).indices().map((Function1 & Serializable & scala.Serializable)index -> AggCodeGenHelper$.$anonfun$buildAggregateArgsMapping$4(baseOffset, types, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
        } else {
            tuple2Array = (Tuple2[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggArgs)).map((Function1 & Serializable & scala.Serializable)args -> (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(args)).map((Function1 & Serializable & scala.Serializable)i -> AggCodeGenHelper$.$anonfun$buildAggregateArgsMapping$6(inputType, BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
        }
        Tuple2[][] aggCallMapping = tuple2Array;
        return (Tuple2[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])auxGroupingMapping)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggCallMapping)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
    }

    public LocalReferenceExpression newLocalReference(String resultTerm, LogicalType resultType) {
        return ApiExpressionUtils.localRef((String)resultTerm, (DataType)LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)resultType));
    }

    public Seq<GeneratedExpression> genFlatAggBufferExprs(boolean isMerge, CodeGeneratorContext ctx, RelBuilder builder, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Tuple2<Object, LogicalType>[][] argsMapping, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes) {
        ExprCodeGenerator exprCodeGen = new ExprCodeGenerator(ctx, false);
        ExpressionConverter converter = new ExpressionConverter(builder);
        IndexedSeq accessAuxGroupingExprs = (IndexedSeq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).indices().map((Function1 & Serializable & scala.Serializable)idx -> AggCodeGenHelper$.MODULE$.newLocalReference((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames[BoxesRunTime.unboxToInt((Object)idx)])).head(), (LogicalType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes[BoxesRunTime.unboxToInt((Object)idx)])).head()), IndexedSeq$.MODULE$.canBuildFrom());
        Seq aggCallExprs = (Seq)aggInfos.flatMap((Function1 & Serializable & scala.Serializable)aggInfo -> {
            ArrayOps.ofRef ofRef2;
            int aggBufferIdx = auxGrouping.length + aggInfo.aggIndex();
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
                DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                AggCodeGenHelper.ResolveReference ref = new AggCodeGenHelper.ResolveReference(ctx, builder, isMerge, declarativeAggregateFunction, aggBufferIdx, argsMapping, aggBufferPrefix, aggBufferTypes);
                ofRef2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.aggBufferAttributes())).map((Function1 & Serializable & scala.Serializable)x$6 -> (ResolvedExpression)x$6.accept((ExpressionVisitor)ref), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class)))));
            } else if (userDefinedFunction instanceof AggregateFunction) {
                String aggBufferName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames[aggBufferIdx])).head();
                LogicalType aggBufferType = (LogicalType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes[aggBufferIdx])).head();
                ofRef2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)MODULE$.newLocalReference(aggBufferName, aggBufferType)));
            } else {
                throw new MatchError((Object)userDefinedFunction);
            }
            return ofRef2;
        }, Seq$.MODULE$.canBuildFrom());
        IndexedSeq aggBufferExprs = (IndexedSeq)accessAuxGroupingExprs.$plus$plus((GenTraversableOnce)aggCallExprs, IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)aggBufferExprs.map((Function1 & Serializable & scala.Serializable)x$7 -> (RexNode)x$7.accept((ExpressionVisitor)converter), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String genInitFlatAggregateBuffer(CodeGeneratorContext ctx, RelBuilder builder, RowType inputType, String inputTerm, int[] grouping, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, Seq<GeneratedExpression> aggBufferExprs, boolean forHashAgg) {
        ExprCodeGenerator exprCodeGen = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)inputType, inputTerm, (Option<int[]>)new Some((Object)auxGrouping));
        ExpressionConverter converter = new ExpressionConverter(builder);
        GeneratedExpression[] initAuxGroupingExprs = (GeneratedExpression[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(forHashAgg ? (int[])((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).indices().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)idx -> idx + grouping.length, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()) : auxGrouping)).map((Function1 & Serializable & scala.Serializable)idx -> GenerateUtils$.MODULE$.generateFieldAccess(ctx, (LogicalType)inputType, inputTerm, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        Seq initAggCallBufferExprs = (Seq)aggInfos.flatMap((Function1 & Serializable & scala.Serializable)aggInfo -> {
            ArrayOps.ofRef ofRef2;
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
                DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                Expression[] expressions = declarativeAggregateFunction.initialValuesExpressions();
                RexNode[] rexNodes = (RexNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expressions)).map((Function1 & Serializable & scala.Serializable)x$8 -> (RexNode)x$8.accept((ExpressionVisitor)converter), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RexNode.class)));
                ofRef2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rexNodes)).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)))));
            } else if (userDefinedFunction instanceof AggregateFunction) {
                AggregateFunction aggregateFunction = (AggregateFunction)userDefinedFunction;
                String accTerm = new StringBuilder(20).append(functionIdentifiers.apply((Object)aggregateFunction)).append(".createAccumulator()").toString();
                DataType externalAccType = (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfo.externalAccTypes())).head();
                LogicalType internalAccType = externalAccType.getLogicalType();
                GeneratedExpression genExpr = new GeneratedExpression((String)CodeGenUtils$.MODULE$.genToInternalConverter(ctx, externalAccType).apply((Object)accTerm), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), internalAccType, GeneratedExpression$.MODULE$.apply$default$5());
                ofRef2 = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{genExpr}));
            } else {
                throw new MatchError((Object)userDefinedFunction);
            }
            return ofRef2;
        }, Seq$.MODULE$.canBuildFrom());
        GeneratedExpression[] initAggBufferExprs = (GeneratedExpression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initAuxGroupingExprs)).$plus$plus((GenTraversableOnce)initAggCallBufferExprs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        Predef$.MODULE$.require(aggBufferExprs.length() == initAggBufferExprs.length);
        return ((TraversableOnce)((TraversableLike)aggBufferExprs.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])initAggBufferExprs), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression aggBufVar = (GeneratedExpression)tuple2._1();
            GeneratedExpression initExpr = (GeneratedExpression)tuple2._2();
            String resultCode = MODULE$.genElementCopyTerm(ctx, aggBufVar.resultType(), initExpr.resultTerm());
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n             |").append(initExpr.code()).append("\n             |").append(aggBufVar.nullTerm()).append(" = ").append(initExpr.nullTerm()).append(";\n             |").append(aggBufVar.resultTerm()).append(" = ").append(resultCode).append(";\n         ").toString())).stripMargin().trim();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public boolean genInitFlatAggregateBuffer$default$10() {
        return false;
    }

    private String genElementCopyTerm(CodeGeneratorContext ctx, LogicalType t, String inputTerm) {
        String string;
        block2: {
            while (true) {
                LogicalTypeRoot logicalTypeRoot;
                boolean bl;
                if (bl = LogicalTypeRoot.CHAR.equals(logicalTypeRoot = t.getTypeRoot()) ? true : (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.MAP.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot))))))) {
                    TypeSerializer serializer = InternalSerializers.create((LogicalType)t);
                    String term = ctx.addReusableObject(serializer, "serializer", serializer.getClass().getCanonicalName());
                    String typeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(t);
                    string = new StringBuilder(10).append("(").append(typeTerm).append(") ").append(term).append(".copy(").append(inputTerm).append(")").toString();
                    break block2;
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                t = ((DistinctType)t).getSourceType();
            }
            string = inputTerm;
        }
        return string;
    }

    public String genAggregateByFlatAggregateBuffer(boolean isMerge, CodeGeneratorContext ctx, RelBuilder builder, RowType inputType, String inputTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, Tuple2<Object, LogicalType>[][] argsMapping, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, Seq<GeneratedExpression> aggBufferExprs) {
        return isMerge ? this.genMergeFlatAggregateBuffer(ctx, builder, inputTerm, inputType, auxGrouping, aggInfos, functionIdentifiers, argsMapping, aggBufferPrefix, aggBufferNames, aggBufferTypes, aggBufferExprs) : this.genAccumulateFlatAggregateBuffer(ctx, builder, inputTerm, inputType, auxGrouping, aggInfos, functionIdentifiers, argsMapping, aggBufferPrefix, aggBufferNames, aggBufferTypes, aggBufferExprs);
    }

    public GeneratedExpression genSortAggOutputExpr(boolean isMerge, boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, int[] grouping, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, Tuple2<Object, LogicalType>[][] argsMapping, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, Seq<GeneratedExpression> aggBufferExprs, RowType outputType) {
        GeneratedExpression generatedExpression;
        String valueRow = CodeGenUtils$.MODULE$.newName("valueRow");
        ExprCodeGenerator resultCodeGen = new ExprCodeGenerator(ctx, false);
        if (isFinal) {
            Seq<GeneratedExpression> getValueExprs = this.genGetValueFromFlatAggregateBuffer(isMerge, ctx, builder, auxGrouping, aggInfos, functionIdentifiers, argsMapping, aggBufferPrefix, aggBufferNames, aggBufferTypes, outputType);
            RowType valueRowType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)getValueExprs.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.resultType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))));
            generatedExpression = resultCodeGen.generateResultExpression(getValueExprs, valueRowType, GenericRowData.class, valueRow, resultCodeGen.generateResultExpression$default$5(), resultCodeGen.generateResultExpression$default$6(), resultCodeGen.generateResultExpression$default$7());
        } else {
            RowType valueRowType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)aggBufferExprs.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.resultType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))));
            generatedExpression = resultCodeGen.generateResultExpression(aggBufferExprs, valueRowType, GenericRowData.class, valueRow, resultCodeGen.generateResultExpression$default$5(), resultCodeGen.generateResultExpression$default$6(), resultCodeGen.generateResultExpression$default$7());
        }
        return generatedExpression;
    }

    public Seq<GeneratedExpression> genGetValueFromFlatAggregateBuffer(boolean isMerge, CodeGeneratorContext ctx, RelBuilder builder, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, Tuple2<Object, LogicalType>[][] argsMapping, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, RowType outputType) {
        ExprCodeGenerator exprCodeGen = new ExprCodeGenerator(ctx, false);
        ExpressionConverter converter = new ExpressionConverter(builder);
        IndexedSeq auxGroupingExprs = (IndexedSeq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGrouping)).indices().map((Function1 & Serializable & scala.Serializable)idx -> AggCodeGenHelper$.$anonfun$genGetValueFromFlatAggregateBuffer$1(aggBufferNames, aggBufferTypes, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq getValueExprs = (Seq)aggInfos.map((Function1 & Serializable & scala.Serializable)aggInfo -> {
            GeneratedExpression generatedExpression;
            int aggBufferIdx = auxGrouping.length + aggInfo.aggIndex();
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
                DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                AggCodeGenHelper.ResolveReference ref = new AggCodeGenHelper.ResolveReference(ctx, builder, isMerge, declarativeAggregateFunction, aggBufferIdx, argsMapping, aggBufferPrefix, aggBufferTypes);
                RexNode getValueRexNode = (RexNode)((Expression)declarativeAggregateFunction.getValueExpression().accept((ExpressionVisitor)ref)).accept((ExpressionVisitor)converter);
                generatedExpression = exprCodeGen.generateExpression(getValueRexNode);
            } else if (userDefinedFunction instanceof AggregateFunction) {
                AggregateFunction aggregateFunction = (AggregateFunction)userDefinedFunction;
                String aggBufferName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames[aggBufferIdx])).head();
                DataType externalAccType = (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfo.externalAccTypes())).head();
                DataType externalResultType = aggInfo.externalResultType();
                LogicalType resultType = externalResultType.getLogicalType();
                String getValueCode = new StringBuilder(10).append(functionIdentifiers.apply((Object)aggregateFunction)).append(".getValue(").append(new StringBuilder(1).append(CodeGenUtils$.MODULE$.genToExternalConverter(ctx, externalAccType, aggBufferName)).append(")").toString()).toString();
                String resultTerm = (String)CodeGenUtils$.MODULE$.genToInternalConverter(ctx, externalResultType).apply((Object)getValueCode);
                String nullTerm = new StringBuilder(6).append(aggBufferName).append("IsNull").toString();
                generatedExpression = new GeneratedExpression(resultTerm, nullTerm, GeneratedExpression$.MODULE$.NO_CODE(), resultType, GeneratedExpression$.MODULE$.apply$default$5());
            } else {
                throw new MatchError((Object)userDefinedFunction);
            }
            return generatedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)auxGroupingExprs.$plus$plus((GenTraversableOnce)getValueExprs, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String genMergeFlatAggregateBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, Tuple2<Object, LogicalType>[][] argsMapping, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, Seq<GeneratedExpression> aggBufferExprs) {
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        RowType x$16 = inputType;
        String x$17 = inputTerm;
        Option<int[]> x$18 = qual$1.bindInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$1.bindInput((LogicalType)x$16, x$17, x$18);
        ExpressionConverter converter = new ExpressionConverter(builder);
        IntRef currentAggBufferExprIdx = IntRef.create((int)auxGrouping.length);
        Seq mergeCode = (Seq)aggInfos.map((Function1 & Serializable & scala.Serializable)aggInfo -> {
            String string;
            int aggBufferIdx = auxGrouping.length + aggInfo.aggIndex();
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
                DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                AggCodeGenHelper.ResolveReference ref = new AggCodeGenHelper.ResolveReference(ctx, builder, true, declarativeAggregateFunction, aggBufferIdx, argsMapping, aggBufferPrefix, aggBufferTypes);
                GeneratedExpression[] mergeExprs = (GeneratedExpression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.mergeExpressions())).map((Function1 & Serializable & scala.Serializable)x$11 -> (ResolvedExpression)x$11.accept((ExpressionVisitor)ref), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class))))).map((Function1 & Serializable & scala.Serializable)x$12 -> (RexNode)x$12.accept((ExpressionVisitor)converter), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RexNode.class))))).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
                string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mergeExprs)).map((Function1 & Serializable & scala.Serializable)mergeExpr -> {
                    GeneratedExpression aggBufferExpr = (GeneratedExpression)aggBufferExprs.apply(currentAggBufferExprIdx$1.elem);
                    ++currentAggBufferExprIdx$1.elem;
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("\n                     |").append(mergeExpr.code()).append("\n                     |").append(aggBufferExpr.nullTerm()).append(" = ").append(mergeExpr.nullTerm()).append(";\n                     |if (!").append(mergeExpr.nullTerm()).append(") {\n                     |  ").append(mergeExpr.copyResultTermToTargetIfChanged(ctx, aggBufferExpr.resultTerm())).append("\n                     |}\n              ").toString())).stripMargin();
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
            } else if (userDefinedFunction instanceof AggregateFunction) {
                AggregateFunction aggregateFunction = (AggregateFunction)userDefinedFunction;
                Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])argsMapping[aggBufferIdx])).head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int inputIndex = tuple2._1$mcI$sp();
                LogicalType inputType = (LogicalType)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)inputIndex), (Object)inputType);
                Tuple2 tuple23 = tuple22;
                int inputIndex2 = tuple23._1$mcI$sp();
                LogicalType inputType2 = (LogicalType)tuple23._2();
                ResolvedExpression inputRef = DeclarativeExpressionResolver.toRexInputRef(builder, inputIndex2, inputType2);
                GeneratedExpression inputExpr = exprCodeGen.generateExpression((RexNode)inputRef.accept((ExpressionVisitor)converter));
                String aggBufferName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames[aggBufferIdx])).head();
                GeneratedExpression aggBufferExpr = (GeneratedExpression)aggBufferExprs.apply(currentAggBufferExprIdx$1.elem);
                ++currentAggBufferExprIdx$1.elem;
                String iterableTypeTerm = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(SingleElementIterator.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                DataType externalAccType = (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfo.externalAccTypes())).head();
                String externalAccTypeTerm = CodeGenUtils$.MODULE$.typeTerm(externalAccType.getConversionClass());
                String externalAccTerm = CodeGenUtils$.MODULE$.newName("acc");
                int aggIndex = aggInfo.aggIndex();
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("\n               |").append(iterableTypeTerm).append(" accIt").append(aggIndex).append(" = new ").append(iterableTypeTerm).append("();\n               |accIt").append(aggIndex).append(".set(").append(CodeGenUtils$.MODULE$.genToExternalConverter(ctx, externalAccType, inputExpr.resultTerm())).append(");\n               |").append(externalAccTypeTerm).append(" ").append(externalAccTerm).append(" = ").append(CodeGenUtils$.MODULE$.genToExternalConverter(ctx, externalAccType, aggBufferName)).append(";\n               |").append(functionIdentifiers.apply((Object)aggregateFunction)).append(".merge(").append(externalAccTerm).append(", accIt").append(aggIndex).append(");\n               |").append(aggBufferName).append(" = ").append(CodeGenUtils$.MODULE$.genToInternalConverter(ctx, externalAccType).apply((Object)externalAccTerm)).append(";\n               |").append(aggBufferExpr.nullTerm()).append(" = ").append(aggBufferName).append("IsNull || ").append(inputExpr.nullTerm()).append(";\n          ").toString())).stripMargin();
            } else {
                throw new MatchError((Object)userDefinedFunction);
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        return mergeCode.mkString("\n");
    }

    public String genAccumulateFlatAggregateBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, Tuple2<Object, LogicalType>[][] argsMapping, String aggBufferPrefix, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, Seq<GeneratedExpression> aggBufferExprs) {
        ExprCodeGenerator qual$2 = new ExprCodeGenerator(ctx, false);
        RowType x$19 = inputType;
        String x$20 = inputTerm;
        Option<int[]> x$21 = qual$2.bindInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$2.bindInput((LogicalType)x$19, x$20, x$21);
        ExpressionConverter converter = new ExpressionConverter(builder);
        IntRef currentAggBufferExprIdx = IntRef.create((int)auxGrouping.length);
        Seq filteredAccCode = (Seq)aggInfos.map((Function1 & Serializable & scala.Serializable)aggInfo -> {
            String string;
            String string2;
            AggregateCall aggCall = aggInfo.agg();
            int aggBufferIdx = auxGrouping.length + aggInfo.aggIndex();
            UserDefinedFunction userDefinedFunction = aggInfo.function();
            if (userDefinedFunction instanceof DeclarativeAggregateFunction) {
                DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)userDefinedFunction;
                AggCodeGenHelper.ResolveReference ref = new AggCodeGenHelper.ResolveReference(ctx, builder, false, declarativeAggregateFunction, aggBufferIdx, argsMapping, aggBufferPrefix, aggBufferTypes);
                GeneratedExpression[] accExprs = (GeneratedExpression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.accumulateExpressions())).map((Function1 & Serializable & scala.Serializable)x$14 -> (ResolvedExpression)x$14.accept((ExpressionVisitor)ref), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class))))).map((Function1 & Serializable & scala.Serializable)x$15 -> (RexNode)x$15.accept((ExpressionVisitor)new ExpressionConverter(builder)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RexNode.class))))).map((Function1 & Serializable & scala.Serializable)rex -> exprCodeGen.generateExpression((RexNode)rex), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
                string2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accExprs)).map((Function1 & Serializable & scala.Serializable)accExpr -> {
                    GeneratedExpression aggBufferExpr = (GeneratedExpression)aggBufferExprs.apply(currentAggBufferExprIdx$2.elem);
                    ++currentAggBufferExprIdx$2.elem;
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n                     |").append(accExpr.code()).append("\n                     |").append(aggBufferExpr.nullTerm()).append(" = ").append(accExpr.nullTerm()).append(";\n                     |if (!").append(accExpr.nullTerm()).append(") {\n                     |  // copy result term\n                     |  ").append(accExpr.copyResultTermToTargetIfChanged(ctx, aggBufferExpr.resultTerm())).append("\n                     |}\n              ").toString())).stripMargin();
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
            } else if (userDefinedFunction instanceof AggregateFunction) {
                AggregateFunction aggregateFunction = (AggregateFunction)userDefinedFunction;
                Tuple2[] args = argsMapping[aggBufferIdx];
                GeneratedExpression[] inputExprs = (GeneratedExpression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int argIndex = tuple2._1$mcI$sp();
                    LogicalType argType = (LogicalType)tuple2._2();
                    ResolvedExpression inputRef = DeclarativeExpressionResolver.toRexInputRef(builder, argIndex, argType);
                    GeneratedExpression generatedExpression = exprCodeGen.generateExpression((RexNode)inputRef.accept((ExpressionVisitor)converter));
                    return generatedExpression;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
                String[] operandTerms = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputExprs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    GeneratedExpression expr = (GeneratedExpression)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    String string = CodeGenUtils$.MODULE$.genToExternalConverterAll(ctx, aggInfo.externalArgTypes()[i], expr);
                    return string;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                String aggBufferName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames[aggBufferIdx])).head();
                GeneratedExpression aggBufferExpr = (GeneratedExpression)aggBufferExprs.apply(currentAggBufferExprIdx$2.elem);
                ++currentAggBufferExprIdx$2.elem;
                DataType externalAccType = (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggInfo.externalAccTypes())).head();
                String externalAccTypeTerm = CodeGenUtils$.MODULE$.typeTerm(externalAccType.getConversionClass());
                String externalAccTerm = CodeGenUtils$.MODULE$.newName("acc");
                String externalAccCode = CodeGenUtils$.MODULE$.genToExternalConverter(ctx, externalAccType, aggBufferName);
                String aggParametersCode = String.valueOf(((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{externalAccTerm}))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operandTerms)), Seq$.MODULE$.canBuildFrom())).mkString(", "));
                string2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(129).append("\n               |").append(externalAccTypeTerm).append(" ").append(externalAccTerm).append(" = ").append(externalAccCode).append(";\n               |").append(functionIdentifiers.apply((Object)aggregateFunction)).append(".accumulate(\n               | ").append(aggParametersCode).append(");\n               |").append(aggBufferName).append(" = ").append(CodeGenUtils$.MODULE$.genToInternalConverter(ctx, externalAccType).apply((Object)externalAccTerm)).append(";\n               |").append(aggBufferExpr.nullTerm()).append(" = false;\n          ").toString())).stripMargin();
            } else {
                throw new MatchError((Object)userDefinedFunction);
            }
            String accCode = string2;
            if (aggInfo.agg().hasFilter()) {
                GeneratedExpression expr = CodeGenUtils$.MODULE$.getFieldExpr(ctx, inputTerm, inputType, aggCall.filterArg);
                String filterTerm = new StringBuilder(5).append("!").append(expr.nullTerm()).append(" && ").append(expr.resultTerm()).toString();
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n             |").append(expr.code()).append("\n             |if (").append(filterTerm).append(") {\n             |  ").append(accCode).append("\n             |}\n        ").toString())).stripMargin();
            } else {
                string = accCode;
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        return filteredAccCode.mkString("\n");
    }

    public GeneratedOperator<OneInputStreamOperator<RowData, RowData>> generateOperator(CodeGeneratorContext ctx, String name, String operatorBaseClass, String processCode, String endInputCode, RowType inputType) {
        ctx.addReusableMember("private boolean hasInput = false;");
        ctx.addReusableMember(new StringBuilder(30).append(OperatorCodeGenerator$.MODULE$.STREAM_RECORD()).append(" element = new ").append(OperatorCodeGenerator$.MODULE$.STREAM_RECORD()).append("((Object)null);").toString());
        CodeGeneratorContext x$22 = ctx;
        String x$23 = name;
        String x$24 = processCode;
        RowType x$25 = inputType;
        Some x$26 = new Some((Object)endInputCode);
        boolean x$27 = true;
        String x$28 = OperatorCodeGenerator$.MODULE$.generateOneInputStreamOperator$default$5();
        Function1<String, String> x$29 = OperatorCodeGenerator$.MODULE$.generateOneInputStreamOperator$default$8();
        return OperatorCodeGenerator$.MODULE$.generateOneInputStreamOperator(x$22, x$23, x$24, (LogicalType)x$25, x$28, (Option<String>)x$26, x$27, x$29);
    }

    public static final /* synthetic */ String[] $anonfun$getAggBufferNames$1(String aggBufferPrefix$1, int index) {
        return (String[])((Object[])new String[]{new StringBuilder(10).append(aggBufferPrefix$1).append("_aux_group").append(index).toString()});
    }

    public static final /* synthetic */ LogicalType[] $anonfun$getAggBufferTypes$1(RowType inputType$1, int index) {
        return (LogicalType[])((Object[])new LogicalType[]{inputType$1.getTypeAt(index)});
    }

    public static final /* synthetic */ boolean $anonfun$getFunctionIdentifiers$2(UserDefinedFunction a) {
        return a instanceof AggregateFunction;
    }

    public static final /* synthetic */ Tuple2[] $anonfun$buildAggregateArgsMapping$2(LogicalType[][] aggBufferTypes$1, int i) {
        return (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)aggBufferTypes$1[i][0])});
    }

    public static final /* synthetic */ Tuple2 $anonfun$buildAggregateArgsMapping$4(int baseOffset$1, LogicalType[] types$1, int index) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(baseOffset$1 + index)), (Object)types$1[index]);
    }

    public static final /* synthetic */ Tuple2 $anonfun$buildAggregateArgsMapping$6(RowType inputType$2, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)inputType$2.getTypeAt(i));
    }

    public static final /* synthetic */ GeneratedExpression $anonfun$genGetValueFromFlatAggregateBuffer$1(String[][] aggBufferNames$4, LogicalType[][] aggBufferTypes$5, int idx) {
        String aggBufferName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferNames$4[idx])).head();
        LogicalType aggBufferType = (LogicalType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes$5[idx])).head();
        String nullTerm = new StringBuilder(6).append(aggBufferName).append("IsNull").toString();
        return new GeneratedExpression(aggBufferName, nullTerm, GeneratedExpression$.MODULE$.NO_CODE(), aggBufferType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private AggCodeGenHelper$() {
        MODULE$ = this;
    }
}

