/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.HashSet;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.interpreter.Source;
import org.apache.calcite.rel.core.Union;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;

public class UnionNode
implements Node {
    private final ImmutableList<Source> sources;
    private final Sink sink;
    private final Union rel;

    public UnionNode(Compiler compiler, Union rel) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < rel.getInputs().size(); ++i) {
            builder.add(compiler.source(rel, i));
        }
        this.sources = builder.build();
        this.sink = compiler.sink(rel);
        this.rel = rel;
    }

    @Override
    public void run() throws InterruptedException {
        HashSet<Row> rows = this.rel.all ? null : Sets.newHashSet();
        for (Source source : this.sources) {
            Row row2;
            while ((row2 = source.receive()) != null) {
                if (rows != null && !rows.add(row2)) continue;
                this.sink.send(row2);
            }
        }
    }
}

