/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Visitor;

public class TypeBinaryExpression
extends Expression {
    public final Expression expression;
    public final Type type;

    public TypeBinaryExpression(ExpressionType nodeType, Expression expression2, Type type) {
        super(nodeType, Boolean.TYPE);
        assert (expression2 != null) : "expression should not be null";
        this.expression = expression2;
        this.type = type;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression2 = this.expression.accept(shuttle);
        return shuttle.visit(this, expression2);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        this.expression.accept(writer, lprec, this.nodeType.lprec);
        writer.append(this.nodeType.op);
        writer.append(this.type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeBinaryExpression that = (TypeBinaryExpression)o;
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, ((Expression)this).type, this.type, this.expression});
    }
}

