/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.PrecedenceClimbingParser;
import org.apache.calcite.util.SaffronProperties;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.base.Predicate;
import org.slf4j.Logger;

public final class SqlParserUtil {
    static final Logger LOGGER = CalciteTrace.getParserTracer();

    private SqlParserUtil() {
    }

    public static String getCharacterSet(String s) {
        if (s.charAt(0) == '\'') {
            return null;
        }
        if (Character.toUpperCase(s.charAt(0)) == 'N') {
            return SaffronProperties.INSTANCE.defaultNationalCharset().get();
        }
        int i = s.indexOf("'");
        return s.substring(1, i);
    }

    public static String parseString(String s) {
        int i = s.indexOf("'");
        if (i > 0) {
            s = s.substring(i);
        }
        return SqlParserUtil.strip(s, "'", "'", "''", Casing.UNCHANGED);
    }

    public static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s);
    }

    public static BigDecimal parseInteger(String s) {
        return new BigDecimal(s);
    }

    @Deprecated
    public static Date parseDate(String s) {
        return Date.valueOf(s);
    }

    @Deprecated
    public static Time parseTime(String s) {
        return Time.valueOf(s);
    }

    @Deprecated
    public static Timestamp parseTimestamp(String s) {
        return Timestamp.valueOf(s);
    }

    public static SqlDateLiteral parseDateLiteral(String s, SqlParserPos pos) {
        String dateStr = SqlParserUtil.parseString(s);
        Calendar cal = DateTimeUtils.parseDateFormat(dateStr, ((Format)Format.PER_THREAD.get()).date, DateTimeUtils.UTC_ZONE);
        if (cal == null) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalLiteral("DATE", s, Static.RESOURCE.badFormat("yyyy-MM-dd").str()));
        }
        DateString d = DateString.fromCalendarFields(cal);
        return SqlLiteral.createDate(d, pos);
    }

    public static SqlTimeLiteral parseTimeLiteral(String s, SqlParserPos pos) {
        String dateStr = SqlParserUtil.parseString(s);
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral(dateStr, ((Format)Format.PER_THREAD.get()).time, DateTimeUtils.UTC_ZONE, -1);
        if (pt == null) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalLiteral("TIME", s, Static.RESOURCE.badFormat("HH:mm:ss").str()));
        }
        TimeString t = TimeString.fromCalendarFields(pt.getCalendar()).withFraction(pt.getFraction());
        return SqlLiteral.createTime(t, pt.getPrecision(), pos);
    }

    public static SqlTimestampLiteral parseTimestampLiteral(String s, SqlParserPos pos) {
        String dateStr = SqlParserUtil.parseString(s);
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral(dateStr, ((Format)Format.PER_THREAD.get()).timestamp, DateTimeUtils.UTC_ZONE, -1);
        if (pt == null) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalLiteral("TIMESTAMP", s, Static.RESOURCE.badFormat("yyyy-MM-dd HH:mm:ss").str()));
        }
        TimestampString ts = TimestampString.fromCalendarFields(pt.getCalendar()).withFraction(pt.getFraction());
        return SqlLiteral.createTimestamp(ts, pt.getPrecision(), pos);
    }

    public static SqlIntervalLiteral parseIntervalLiteral(SqlParserPos pos, int sign, String s, SqlIntervalQualifier intervalQualifier) {
        String intervalStr = SqlParserUtil.parseString(s);
        if (intervalStr.equals("")) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.illegalIntervalLiteral(s + " " + intervalQualifier.toString(), pos.toString()));
        }
        return SqlLiteral.createInterval(sign, intervalStr, intervalQualifier, pos);
    }

    public static void checkDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ROOT);
        Util.discard(df);
    }

    public static long intervalToMillis(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMillis(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMillis(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Preconditions.checkArgument(!intervalQualifier.isYearMonth(), "interval must be day time");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition(), RelDataTypeSystem.DEFAULT);
            assert (ret != null);
        }
        catch (CalciteContextException e2) {
            throw new RuntimeException("while parsing day-to-second interval " + literal, e2);
        }
        long l = 0L;
        long[] conv = new long[5];
        conv[4] = 1L;
        conv[3] = conv[4] * 1000L;
        conv[2] = conv[3] * 60L;
        conv[1] = conv[2] * 60L;
        conv[0] = conv[1] * 24L;
        for (int i = 1; i < ret.length; ++i) {
            l += conv[i - 1] * (long)ret[i];
        }
        return (long)ret[0] * l;
    }

    public static long intervalToMonths(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMonths(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMonths(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Preconditions.checkArgument(intervalQualifier.isYearMonth(), "interval must be year month");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition(), RelDataTypeSystem.DEFAULT);
            assert (ret != null);
        }
        catch (CalciteContextException e2) {
            throw new RuntimeException("Error while parsing year-to-month interval " + literal, e2);
        }
        long l = 0L;
        long[] conv = new long[2];
        conv[1] = 1L;
        conv[0] = conv[1] * 12L;
        for (int i = 1; i < ret.length; ++i) {
            l += conv[i - 1] * (long)ret[i];
        }
        return (long)ret[0] * l;
    }

    public static int parsePositiveInt(String value) {
        if ((value = value.trim()).charAt(0) == '-') {
            throw new NumberFormatException(value);
        }
        return Integer.parseInt(value);
    }

    @Deprecated
    public static byte[] parseBinaryString(String s) {
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\n", "");
        s = s.replaceAll("\t", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll("\f", "");
        if ((s = s.replaceAll("'", "")).length() == 0) {
            return new byte[0];
        }
        assert ((s.length() & 1) == 0);
        int lengthToBe = s.length() / 2;
        s = "ff" + s;
        BigInteger bigInt = new BigInteger(s, 16);
        byte[] ret = new byte[lengthToBe];
        System.arraycopy(bigInt.toByteArray(), 2, ret, 0, ret.length);
        return ret;
    }

    public static String strip(String s, String startQuote, String endQuote, String escape, Casing casing) {
        if (startQuote != null) {
            assert (endQuote != null);
            assert (startQuote.length() == 1);
            assert (endQuote.length() == 1);
            assert (escape != null);
            assert (s.startsWith(startQuote) && s.endsWith(endQuote)) : s;
            s = s.substring(1, s.length() - 1).replace(escape, endQuote);
        }
        switch (casing) {
            case TO_UPPER: {
                return s.toUpperCase(Locale.ROOT);
            }
            case TO_LOWER: {
                return s.toLowerCase(Locale.ROOT);
            }
        }
        return s;
    }

    public static String trim(String s, String chars) {
        char c;
        int stop;
        char c2;
        int start;
        if (s.length() == 0) {
            return "";
        }
        for (start = 0; start < s.length() && chars.indexOf(c2 = s.charAt(start)) >= 0; ++start) {
        }
        for (stop = s.length(); stop > start && chars.indexOf(c = s.charAt(stop - 1)) >= 0; --stop) {
        }
        if (start >= stop) {
            return "";
        }
        return s.substring(start, stop);
    }

    public static StringAndPos findPos(String sql) {
        int[] end;
        int firstCaret = sql.indexOf(94);
        if (firstCaret < 0) {
            return new StringAndPos(sql, -1, null);
        }
        int secondCaret = sql.indexOf(94, firstCaret + 1);
        if (secondCaret < 0) {
            String sqlSansCaret = sql.substring(0, firstCaret) + sql.substring(firstCaret + 1);
            int[] start = SqlParserUtil.indexToLineCol(sql, firstCaret);
            SqlParserPos pos = new SqlParserPos(start[0], start[1]);
            return new StringAndPos(sqlSansCaret, firstCaret, pos);
        }
        String sqlSansCaret = sql.substring(0, firstCaret) + sql.substring(firstCaret + 1, secondCaret) + sql.substring(secondCaret + 1);
        int[] start = SqlParserUtil.indexToLineCol(sql, firstCaret);
        if (start[0] == (end = SqlParserUtil.indexToLineCol(sql, --secondCaret))[0]) {
            end[1] = end[1] - 1;
        }
        SqlParserPos pos = new SqlParserPos(start[0], start[1], end[0], end[1]);
        return new StringAndPos(sqlSansCaret, firstCaret, pos);
    }

    public static int[] indexToLineCol(String sql, int i) {
        int line = 0;
        int j2 = 0;
        while (true) {
            int prevj = j2;
            if ((j2 = SqlParserUtil.nextLine(sql, j2)) < 0 || j2 > i) {
                return new int[]{line + 1, i - prevj + 1};
            }
            ++line;
        }
    }

    public static int nextLine(String sql, int j2) {
        int rn = sql.indexOf("\r\n", j2);
        int r = sql.indexOf("\r", j2);
        int n = sql.indexOf("\n", j2);
        if (r < 0 && n < 0) {
            assert (rn < 0);
            return -1;
        }
        if (rn >= 0 && rn < n && rn <= r) {
            return rn + 2;
        }
        if (r >= 0 && r < n) {
            return r + 1;
        }
        return n + 1;
    }

    public static int lineColToIndex(String sql, int line, int column) {
        --column;
        int i = 0;
        while (true) {
            int n = --line;
            --line;
            if (n <= 0) break;
            i = SqlParserUtil.nextLine(sql, i);
        }
        return i + column;
    }

    public static String addCarets(String sql, int line, int col, int endLine, int endCol) {
        int cut = SqlParserUtil.lineColToIndex(sql, line, col);
        String sqlWithCarets = sql.substring(0, cut) + "^" + sql.substring(cut);
        if (col != endCol || line != endLine) {
            cut = SqlParserUtil.lineColToIndex(sqlWithCarets, endLine, endCol);
            sqlWithCarets = ++cut < sqlWithCarets.length() ? sqlWithCarets.substring(0, cut) + "^" + sqlWithCarets.substring(cut) : sqlWithCarets + "^";
        }
        return sqlWithCarets;
    }

    public static String getTokenVal(String token) {
        int endIndex;
        if (!token.startsWith("\"")) {
            return null;
        }
        int startIndex = token.indexOf("\"");
        String tokenVal = token.substring(startIndex + 1, endIndex = token.lastIndexOf("\""));
        char c = tokenVal.charAt(0);
        if (Character.isLetter(c)) {
            return tokenVal;
        }
        return null;
    }

    public static ParsedCollation parseCollation(String in) {
        Locale locale;
        StringTokenizer st = new StringTokenizer(in, "$");
        String charsetStr = st.nextToken();
        String localeStr = st.nextToken();
        String strength = st.countTokens() > 0 ? st.nextToken() : SaffronProperties.INSTANCE.defaultCollationStrength().get();
        Charset charset = Charset.forName(charsetStr);
        String[] localeParts = localeStr.split("_");
        if (1 == localeParts.length) {
            locale = new Locale(localeParts[0]);
        } else if (2 == localeParts.length) {
            locale = new Locale(localeParts[0], localeParts[1]);
        } else if (3 == localeParts.length) {
            locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
        } else {
            throw Static.RESOURCE.illegalLocaleFormat(localeStr).ex();
        }
        return new ParsedCollation(charset, locale, strength);
    }

    @Deprecated
    public static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static SqlNode[] toNodeArray(List<SqlNode> list) {
        return list.toArray(new SqlNode[list.size()]);
    }

    public static SqlNode[] toNodeArray(SqlNodeList list) {
        return list.toArray();
    }

    @Deprecated
    public static String rightTrim(String s, char c) {
        int stop;
        for (stop = s.length(); stop > 0 && s.charAt(stop - 1) == c; --stop) {
        }
        if (stop > 0) {
            return s.substring(0, stop);
        }
        return "";
    }

    public static <T> void replaceSublist(List<T> list, int start, int end, T o) {
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument(start < end);
        for (int i = end - 1; i > start; --i) {
            list.remove(i);
        }
        list.set(start, o);
    }

    public static SqlNode toTree(List<Object> list) {
        if (list.size() == 1 && list.get(0) instanceof SqlNode) {
            return (SqlNode)list.get(0);
        }
        LOGGER.trace("Attempting to reduce {}", list);
        OldTokenSequenceImpl tokenSequence = new OldTokenSequenceImpl(list);
        SqlNode node = SqlParserUtil.toTreeEx(tokenSequence, 0, 0, SqlKind.OTHER);
        LOGGER.debug("Reduced {}", (Object)node);
        return node;
    }

    public static SqlNode toTreeEx(SqlSpecialOperator.TokenSequence list, int start, final int minPrec, final SqlKind stopperKind) {
        PredicateImpl<PrecedenceClimbingParser.Token> predicate = new PredicateImpl<PrecedenceClimbingParser.Token>(){

            @Override
            public boolean test(PrecedenceClimbingParser.Token t) {
                if (t instanceof PrecedenceClimbingParser.Op) {
                    SqlOperator op = ((ToTreeListItem)t.o).op;
                    return stopperKind != SqlKind.OTHER && op.kind == stopperKind || minPrec > 0 && op.getLeftPrec() < minPrec;
                }
                return false;
            }
        };
        PrecedenceClimbingParser parser = list.parser(start, (Predicate<PrecedenceClimbingParser.Token>)predicate);
        int beforeSize = parser.all().size();
        parser.partialParse();
        int afterSize = parser.all().size();
        SqlNode node = SqlParserUtil.convert(parser.all().get(0));
        list.replaceSublist(start, start + beforeSize - afterSize + 1, node);
        return node;
    }

    private static SqlNode convert(PrecedenceClimbingParser.Token token) {
        switch (token.type) {
            case ATOM: {
                return (SqlNode)token.o;
            }
            case CALL: {
                PrecedenceClimbingParser.Call call = (PrecedenceClimbingParser.Call)token;
                ArrayList<SqlNode> list = new ArrayList<SqlNode>();
                for (PrecedenceClimbingParser.Token arg : call.args) {
                    list.add(SqlParserUtil.convert(arg));
                }
                ToTreeListItem item = (ToTreeListItem)call.op.o;
                if (item.op == SqlStdOperatorTable.UNARY_MINUS && list.size() == 1 && list.get(0) instanceof SqlNumericLiteral) {
                    return SqlLiteral.createNegative((SqlNumericLiteral)list.get(0), item.pos.plusAll(list));
                }
                if (item.op == SqlStdOperatorTable.UNARY_PLUS && list.size() == 1 && list.get(0) instanceof SqlNumericLiteral) {
                    return (SqlNode)list.get(0);
                }
                return item.op.createCall(item.pos.plusAll(list), list);
            }
        }
        throw new AssertionError(token);
    }

    public static char checkUnicodeEscapeChar(String s) {
        if (s.length() != 1) {
            throw Static.RESOURCE.unicodeEscapeCharLength(s).ex();
        }
        char c = s.charAt(0);
        if (Character.isDigit(c) || Character.isWhitespace(c) || c == '+' || c == '\"' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            throw Static.RESOURCE.unicodeEscapeCharIllegal(s).ex();
        }
        return c;
    }

    private static class Format {
        private static final ThreadLocal<Format> PER_THREAD = new ThreadLocal<Format>(){

            @Override
            protected Format initialValue() {
                return new Format();
            }
        };
        final DateFormat timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        final DateFormat time = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
        final DateFormat date = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);

        private Format() {
        }
    }

    private static class OldTokenSequenceImpl
    implements SqlSpecialOperator.TokenSequence {
        final List<Object> list;

        private OldTokenSequenceImpl(List<Object> list) {
            this.list = list;
        }

        @Override
        public PrecedenceClimbingParser parser(int start, Predicate<PrecedenceClimbingParser.Token> predicate) {
            PrecedenceClimbingParser.Builder builder = new PrecedenceClimbingParser.Builder();
            for (Object o : Util.skip(this.list, start)) {
                if (o instanceof ToTreeListItem) {
                    ToTreeListItem item = (ToTreeListItem)o;
                    SqlOperator op = item.getOperator();
                    if (op instanceof SqlPrefixOperator) {
                        builder.prefix(item, op.getLeftPrec());
                        continue;
                    }
                    if (op instanceof SqlPostfixOperator) {
                        builder.postfix(item, op.getRightPrec());
                        continue;
                    }
                    if (op instanceof SqlBinaryOperator) {
                        builder.infix(item, op.getLeftPrec(), op.getLeftPrec() < op.getRightPrec());
                        continue;
                    }
                    if (op instanceof SqlSpecialOperator) {
                        builder.special(item, op.getLeftPrec(), op.getRightPrec(), new PrecedenceClimbingParser.Special(){

                            @Override
                            public PrecedenceClimbingParser.Result apply(PrecedenceClimbingParser parser, PrecedenceClimbingParser.SpecialOp op) {
                                List<PrecedenceClimbingParser.Token> tokens = parser.all();
                                SqlSpecialOperator op1 = (SqlSpecialOperator)((ToTreeListItem)op.o).op;
                                SqlSpecialOperator.ReduceResult r = op1.reduceExpr(tokens.indexOf(op), new TokenSequenceImpl(parser));
                                return new PrecedenceClimbingParser.Result(tokens.get(r.startOrdinal), tokens.get(r.endOrdinal - 1), parser.atom(r.node));
                            }
                        });
                        continue;
                    }
                    throw new AssertionError();
                }
                builder.atom(o);
            }
            return builder.build();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public SqlOperator op(int i) {
            return ((ToTreeListItem)this.list.get(i)).op;
        }

        @Override
        public SqlParserPos pos(int i) {
            Object o = this.list.get(i);
            return o instanceof ToTreeListItem ? ((ToTreeListItem)o).pos : ((SqlNode)o).getParserPosition();
        }

        @Override
        public boolean isOp(int i) {
            return this.list.get(i) instanceof ToTreeListItem;
        }

        @Override
        public SqlNode node(int i) {
            return (SqlNode)this.list.get(i);
        }

        @Override
        public void replaceSublist(int start, int end, SqlNode e2) {
            SqlParserUtil.replaceSublist(this.list, start, end, e2);
        }
    }

    private static class TokenSequenceImpl
    implements SqlSpecialOperator.TokenSequence {
        final List<PrecedenceClimbingParser.Token> list;
        final PrecedenceClimbingParser parser;

        private TokenSequenceImpl(PrecedenceClimbingParser parser) {
            this.parser = parser;
            this.list = parser.all();
        }

        @Override
        public PrecedenceClimbingParser parser(int start, Predicate<PrecedenceClimbingParser.Token> predicate) {
            return this.parser.copy(start, predicate);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public SqlOperator op(int i) {
            return ((ToTreeListItem)this.list.get((int)i).o).getOperator();
        }

        private static SqlParserPos pos(PrecedenceClimbingParser.Token token) {
            switch (token.type) {
                case ATOM: {
                    return ((SqlNode)token.o).getParserPosition();
                }
                case CALL: {
                    PrecedenceClimbingParser.Call call = (PrecedenceClimbingParser.Call)token;
                    SqlParserPos pos = ((ToTreeListItem)call.op.o).pos;
                    for (PrecedenceClimbingParser.Token arg : call.args) {
                        pos = pos.plus(TokenSequenceImpl.pos(arg));
                    }
                    return pos;
                }
            }
            return ((ToTreeListItem)token.o).getPos();
        }

        @Override
        public SqlParserPos pos(int i) {
            return TokenSequenceImpl.pos(this.list.get(i));
        }

        @Override
        public boolean isOp(int i) {
            return this.list.get((int)i).o instanceof ToTreeListItem;
        }

        @Override
        public SqlNode node(int i) {
            return SqlParserUtil.convert(this.list.get(i));
        }

        @Override
        public void replaceSublist(int start, int end, SqlNode e2) {
            SqlParserUtil.replaceSublist(this.list, start, end, this.parser.atom(e2));
        }
    }

    public static class StringAndPos {
        public final String sql;
        public final int cursor;
        public final SqlParserPos pos;

        StringAndPos(String sql, int cursor, SqlParserPos pos) {
            this.sql = sql;
            this.cursor = cursor;
            this.pos = pos;
        }
    }

    public static class ToTreeListItem {
        private final SqlOperator op;
        private final SqlParserPos pos;

        public ToTreeListItem(SqlOperator op, SqlParserPos pos) {
            this.op = op;
            this.pos = pos;
        }

        public String toString() {
            return this.op.toString();
        }

        public SqlOperator getOperator() {
            return this.op;
        }

        public SqlParserPos getPos() {
            return this.pos;
        }
    }

    public static class ParsedCollation {
        private final Charset charset;
        private final Locale locale;
        private final String strength;

        public ParsedCollation(Charset charset, Locale locale, String strength) {
            this.charset = charset;
            this.locale = locale;
            this.strength = strength;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getStrength() {
            return this.strength;
        }
    }
}

