/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc;

import java.nio.ByteBuffer;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Geometry;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.GeometryEngine;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Operator;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorExportToGeoJson;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorExportToWkb;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorFactoryLocal;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Polygon;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Polyline;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.SpatialReference;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCMultiCurve;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCMultiSurface;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCPolygon;

public class OGCMultiPolygon
extends OGCMultiSurface {
    Polygon polygon;

    public OGCMultiPolygon(Polygon src, SpatialReference sr) {
        this.polygon = src;
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 32);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(32, this.getEsriGeometry(), null);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public int numGeometries() {
        return this.polygon.getExteriorRingCount();
    }

    @Override
    public OGCGeometry geometryN(int n) {
        int exterior = 0;
        for (int i = 0; i < this.polygon.getPathCount(); ++i) {
            if (this.polygon.isExteriorRing(i)) {
                ++exterior;
            }
            if (exterior != n + 1) continue;
            return new OGCPolygon(this.polygon, i, this.esriSR);
        }
        throw new IllegalArgumentException("geometryN: n out of range");
    }

    @Override
    public String geometryType() {
        return "MultiPolygon";
    }

    @Override
    public OGCGeometry boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCGeometry.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }
}

