/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Algorithm;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.Lattice;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Schema;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.util.BitSetPlus;

public abstract class LatticeImpl
implements Lattice {
    protected final Schema schema;
    private Map<BitSetPlus, AggregateImpl> mapBitsToAggregate = new HashMap<BitSetPlus, AggregateImpl>();
    protected List<AggregateImpl> materializedAggregates = new ArrayList<AggregateImpl>();
    private static final double Alpha = 1.0;
    private static final double Beta = 100.0;

    protected LatticeImpl(Schema schema2) {
        this.schema = schema2;
        BitSetPlus allBits = new BitSetPlus();
        allBits.set(0, schema2.getAttributes().size());
        AggregateImpl fact = new AggregateImpl(this.schema, allBits);
        fact.rowCount = schema2.getStatisticsProvider().getFactRowCount();
        this.materialize(fact);
    }

    @Override
    public List<AggregateImpl> getMaterializedAggregates() {
        return this.materializedAggregates.subList(1, this.materializedAggregates.size());
    }

    protected List<AggregateImpl> getChildren(AggregateImpl aggregate) {
        BitSetPlus bits = aggregate.bits;
        ArrayList<AggregateImpl> list = new ArrayList<AggregateImpl>();
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            bits.clear(i);
            AggregateImpl child = this.getAggregate(bits);
            list.add(child);
            bits.set(i);
            i = bits.nextSetBit(i + 1);
        }
        return list;
    }

    protected List<AggregateImpl> getParents(AggregateImpl aggregate) {
        BitSetPlus bits = aggregate.bits;
        ArrayList<AggregateImpl> list = new ArrayList<AggregateImpl>();
        int i = bits.nextClearBit(0);
        while (i >= 0 && i < this.schema.getAttributes().size()) {
            bits.set(i);
            AggregateImpl parent = this.getAggregate(bits);
            list.add(parent);
            bits.clear(i);
            i = bits.nextClearBit(i + 1);
        }
        return list;
    }

    protected AggregateImpl getAggregate(BitSetPlus bits) {
        AggregateImpl aggregate = this.mapBitsToAggregate.get(bits);
        if (aggregate == null) {
            BitSetPlus clonedBits = (BitSetPlus)bits.clone();
            aggregate = new AggregateImpl(this.schema, clonedBits);
            aggregate.cost = this.schema.getStatisticsProvider().getRowCount(aggregate.getAttributes());
            this.mapBitsToAggregate.put(clonedBits, aggregate);
        }
        return aggregate;
    }

    protected BitSetPlus toBits(long i) {
        BitSetPlus bits = new BitSetPlus();
        int j2 = 0;
        for (long k = i; k != 0L; k >>= 1) {
            if ((k & 1L) == 1L) {
                bits.set(j2);
            }
            ++j2;
        }
        return bits;
    }

    protected List<AggregateImpl> nonMaterializedDescendants(AggregateImpl aggregate, boolean includeSelf) {
        ArrayList<AggregateImpl> list = new ArrayList<AggregateImpl>();
        list.add(aggregate);
        for (int j2 = 0; j2 < list.size(); ++j2) {
            AggregateImpl childAggregate = (AggregateImpl)list.get(j2);
            if (j2 == 0 && !includeSelf) {
                list.remove(j2);
                includeSelf = true;
                --j2;
            }
            this.appendNonMaterializedChildren(childAggregate, list);
        }
        return list;
    }

    private void appendNonMaterializedChildren(AggregateImpl aggregate, List<AggregateImpl> list) {
        BitSetPlus bits = aggregate.bits;
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            bits.clear(i);
            AggregateImpl child = this.getAggregate(bits);
            if (!child.materialized) {
                list.add(child);
            }
            bits.set(i);
            i = bits.nextSetBit(i + 1);
        }
    }

    protected double getBenefit(AggregateImpl aggregate, int[] benefitCount0) {
        double costSaving = 0.0;
        int benefitCount = 0;
        double aggregateCost = aggregate.estimateRowCount();
        for (AggregateImpl child : this.nonMaterializedDescendants(aggregate, true)) {
            if (!(aggregateCost < child.cost)) continue;
            costSaving += child.cost - aggregateCost;
            ++benefitCount;
        }
        double cost = this.estimateCost(aggregate.estimateRowCount(), this.schema.getStatisticsProvider().getFactRowCount());
        double benefit = costSaving / cost;
        benefitCount0[0] = benefitCount;
        return benefit;
    }

    protected double estimateCost(double rowCount, double factRowCount) {
        return 1.0 * rowCount + 100.0 * Math.log(factRowCount);
    }

    @Override
    public void materialize(AggregateImpl aggregate) {
        assert (!aggregate.materialized);
        aggregate.materialized = true;
        this.materializedAggregates.add(aggregate);
    }

    protected AggregateImpl findNearestMaterializedDescendant(AggregateImpl aggregate) {
        AggregateImpl best = null;
        for (AggregateImpl materializedAggregate : this.materializedAggregates) {
            if (!materializedAggregate.bits.contains(aggregate.bits) || best != null && !(materializedAggregate.rowCount < best.rowCount)) continue;
            best = materializedAggregate;
        }
        assert (best != null);
        return best;
    }

    protected List<AggregateImpl> findMaterializedDirectDescendants(AggregateImpl aggregate) {
        ArrayList<AggregateImpl> list = new ArrayList<AggregateImpl>();
        for (AggregateImpl materializedAggregate : this.materializedAggregates) {
            if (!materializedAggregate.bits.contains(aggregate.bits) || materializedAggregate.bits.equals(aggregate.bits)) continue;
            list.add(materializedAggregate);
        }
        block1: for (int i = 0; i < list.size(); ++i) {
            AggregateImpl aggregate1 = (AggregateImpl)list.get(i);
            for (int j2 = 0; j2 < list.size(); ++j2) {
                if (i == j2) continue;
                AggregateImpl aggregate2 = (AggregateImpl)list.get(j2);
                if (!aggregate2.bits.contains(aggregate1.bits)) continue;
                assert (!aggregate2.bits.equals(aggregate1.bits)) : "materialized aggs should be unique";
                list.remove(i);
                --i;
                continue block1;
            }
        }
        return list;
    }

    protected List<AggregateImpl> findMaterializedDirectAscendants(AggregateImpl aggregate) {
        ArrayList<AggregateImpl> list = new ArrayList<AggregateImpl>();
        for (AggregateImpl materializedAggregate : this.materializedAggregates) {
            if (!aggregate.bits.contains(materializedAggregate.bits) || aggregate.bits.equals(materializedAggregate.bits)) continue;
            list.add(materializedAggregate);
        }
        block1: for (int i = 0; i < list.size(); ++i) {
            AggregateImpl aggregate1 = (AggregateImpl)list.get(i);
            for (int j2 = 0; j2 < list.size(); ++j2) {
                if (i == j2) continue;
                AggregateImpl aggregate2 = (AggregateImpl)list.get(j2);
                if (!aggregate1.bits.contains(aggregate2.bits)) continue;
                assert (!aggregate1.bits.equals(aggregate2.bits)) : "materialized aggs should be unique";
                list.remove(i);
                --i;
                continue block1;
            }
        }
        return list;
    }

    public List<Algorithm.CostBenefit> computeAggregateCosts(List<AggregateImpl> aggregateList) {
        assert (this.materializedAggregates.size() == 1);
        return LatticeImpl.computeAggregateCosts(this, aggregateList);
    }

    public static List<Algorithm.CostBenefit> computeAggregateCosts(Lattice lattice, List<AggregateImpl> aggregateList) {
        ArrayList<Algorithm.CostBenefit> list = new ArrayList<Algorithm.CostBenefit>(aggregateList.size());
        for (AggregateImpl aggregate : aggregateList) {
            aggregate.materialized = false;
            list.add(lattice.costBenefitOf(aggregate));
        }
        return list;
    }
}

