/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\"d\t\t\u0005#I!B#D\u0001\u0003\u0013\t\u0019\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000bQL\b/Z:\n\u0005e1\"\u0001B\"S_^\u00042a\u0007\u0010!\u001b\u0005a\"BA\u000f\u0007\u0003\u001d\u0019w\u000eZ3hK:L!a\b\u000f\u0003\u0011\r{W\u000e]5mKJ\u0004\"!E\u0011\n\u0005\t\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0019\tA!\u001e;jY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0011!Q\u0003A!A!\u0002\u0013Y\u0013aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005ma\u0013BA\u0017\u001d\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002!%tG/\u001a:nK\u0012L\u0017\r^3UsB,\u0007cA\u00199u5\t!G\u0003\u00024i\u0005AA/\u001f9fS:4wN\u0003\u00026m\u000511m\\7n_:T!a\u000e\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002:e\tyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0005\u0002<{5\tAH\u0003\u0002\u0018\u0011%\u0011a\b\u0010\u0002\u0004%><\b\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u0013%t\u0007/\u001e;UsB,\u0007cA\u00199)!A1\t\u0001B\u0001B\u0003%A)\u0001\u0006s_^$\u0016.\\3JIb\u0004\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u00131!\u00138u\u0011!Y\u0005A!A!\u0002\u0013a\u0015aC9vKJL8i\u001c8gS\u001e\u0004\"!T(\u000e\u00039S!a\u000e\u0004\n\u0005As%!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\")!\u000b\u0001C\u0001'\u00061A(\u001b8jiz\"b\u0001V+W/bK\u0006CA\t\u0001\u0011\u0015Q\u0013\u000b1\u0001,\u0011\u0015y\u0013\u000b1\u00011\u0011\u0015\u0001\u0015\u000b1\u0001B\u0011\u0015\u0019\u0015\u000b1\u0001E\u0011\u0015Y\u0015\u000b1\u0001M\u0011%Y\u0006\u00011AA\u0002\u0013EA,\u0001\u0004pkR\u0004X\u000f^\u000b\u0002)!Ia\f\u0001a\u0001\u0002\u0004%\tbX\u0001\u000b_V$\b/\u001e;`I\u0015\fHC\u00011d!\t)\u0015-\u0003\u0002c\r\n!QK\\5u\u0011\u001d!W,!AA\u0002Q\t1\u0001\u001f\u00132\u0011\u00191\u0007\u0001)Q\u0005)\u00059q.\u001e;qkR\u0004\u0003\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0003j\u0003A\t7mY;nk2\fGo\u001c:Ti\u0006$X-F\u0001k!\rYgNO\u0007\u0002Y*\u0011Q\u000eN\u0001\u0006gR\fG/Z\u0005\u0003_2\u0014!BV1mk\u0016\u001cF/\u0019;f\u0011%\t\b\u00011AA\u0002\u0013%!/\u0001\u000bbG\u000e,X.\u001e7bi>\u00148\u000b^1uK~#S-\u001d\u000b\u0003ANDq\u0001\u001a9\u0002\u0002\u0003\u0007!\u000e\u0003\u0004v\u0001\u0001\u0006KA[\u0001\u0012C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016\u0004\u0003\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0003-\u0011xn^'baN#\u0018\r^3\u0016\u0003e\u0004Ba\u001b>}\u007f&\u00111\u0010\u001c\u0002\t\u001b\u0006\u00048\u000b^1uKB\u0011Q)`\u0005\u0003}\u001a\u0013A\u0001T8oOB)\u0011\u0011AA\u0005u5\u0011\u00111\u0001\u0006\u0004M\u0005\u0015!BAA\u0004\u0003\u0011Q\u0017M^1\n\t\u0005-\u00111\u0001\u0002\u0005\u0019&\u001cH\u000fC\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0011a\u0004:po6\u000b\u0007o\u0015;bi\u0016|F%Z9\u0015\u0007\u0001\f\u0019\u0002\u0003\u0005e\u0003\u001b\t\t\u00111\u0001z\u0011\u001d\t9\u0002\u0001Q!\ne\fAB]8x\u001b\u0006\u00048\u000b^1uK\u0002B1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e\u0005\u00012o\u001c:uK\u0012$\u0016.\\3ti\u0006l\u0007o]\u000b\u0003\u0003?\u0001R!!\u0001\u0002\"qLA!a\t\u0002\u0004\tQA*\u001b8lK\u0012d\u0015n\u001d;\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011F\u0001\u0015g>\u0014H/\u001a3US6,7\u000f^1naN|F%Z9\u0015\u0007\u0001\fY\u0003C\u0005e\u0003K\t\t\u00111\u0001\u0002 !A\u0011q\u0006\u0001!B\u0013\ty\"A\tt_J$X\r\u001a+j[\u0016\u001cH/Y7qg\u0002B1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u00026\u0005Aa-\u001e8di&|g.F\u0001!\u0011-\tI\u0004\u0001a\u0001\u0002\u0004%\t\"a\u000f\u0002\u0019\u0019,hn\u0019;j_:|F%Z9\u0015\u0007\u0001\fi\u0004\u0003\u0005e\u0003o\t\t\u00111\u0001!\u0011\u001d\t\t\u0005\u0001Q!\n\u0001\n\u0011BZ;oGRLwN\u001c\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005!q\u000e]3o)\r\u0001\u0017\u0011\n\u0005\t\u0003\u0017\n\u0019\u00051\u0001\u0002N\u000511m\u001c8gS\u001e\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'B\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002X\u0005E#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002\\\u0001!\t%!\u0018\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR9\u0001-a\u0018\u0002d\u0005}\u0004bBA1\u00033\u0002\r\u0001F\u0001\u0007S:\u0004X\u000f^\"\t\u0011\u0005\u0015\u0014\u0011\fa\u0001\u0003O\n1a\u0019;y!\u0011\tI'a\u001f\u0011\r\u0005-\u0014q\u000f\u000b\u0015\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014!\u00034v]\u000e$\u0018n\u001c8t\u0015\r9\u00141\u000f\u0006\u0004\u0003kB\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\tI(!\u001c\u0003\u001fA\u0013xnY3tg\u001a+hn\u0019;j_:LA!! \u0002x\t91i\u001c8uKb$\b\u0002CAA\u00033\u0002\r!a!\u0002\u0007=,H\u000fE\u0003\u0002\u0006\u0006%E#\u0004\u0002\u0002\b*\u0011a\u0005C\u0005\u0005\u0003\u0017\u000b9IA\u0005D_2dWm\u0019;pe\"9\u0011q\u0012\u0001\u0005B\u0005E\u0015aB8o)&lWM\u001d\u000b\bA\u0006M\u0015qSAP\u0011\u001d\t)*!$A\u0002q\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005\u0015\u0014Q\u0012a\u0001\u00033\u0003B!!\u001b\u0002\u001c&!\u0011QTA<\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"!!\u0002\u000e\u0002\u0007\u00111\u0011\u0005\b\u0003G\u0003A\u0011BAS\u0003IIgn]3siR{7k\u001c:uK\u0012d\u0015n\u001d;\u0015\u0007\u0001\f9\u000bC\u0004\u0002*\u0006\u0005\u0006\u0019\u0001?\u0002\u001fI,7m\u001c:e)&lWm\u001d;b[BDq!!,\u0001\r\u0003\ty+\u0001\u0011qe>\u001cWm]:FY\u0016lWM\u001c;t/&$\bnU1nKRKW.Z:uC6\u0004Hc\u00021\u00022\u0006U\u0016\u0011\u0018\u0005\b\u0003g\u000bY\u000b1\u0001\u0000\u0003)\u0019WO\u001d*po2K7\u000f\u001e\u0005\b\u0003o\u000bY\u000b1\u0001;\u0003=a\u0017m\u001d;BG\u000e,X.\u001e7bi>\u0014\b\u0002CAA\u0003W\u0003\r!a!\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\u0006)1\r\\8tKR\t\u0001\r")
public abstract class RowTimeUnboundedOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long timestamp = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long curWatermark = ctx.timerService().currentWatermark();
        if (timestamp > curWatermark) {
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)timestamp), rowList);
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (true) {
                if (this.sortedTimestamps().isEmpty()) {
                    this.accumulatorState().update((Object)lastAccumulator);
                    if (!existEarlyRecord) break;
                    ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
                    break;
                }
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, out);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
        }
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
        boolean bl = true;
        while (listIterator.hasPrevious() && bl) {
            long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
            if (recordTimestamp < timestamp) continue;
            listIterator.next();
            listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
            bl = false;
        }
        if (bl) {
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public void close() {
        this.function().close();
    }

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

