/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.runtime.join.EmitAwareCollector;
import org.apache.flink.table.runtime.join.OuterJoinPaddingUtil;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}g!B\u0001\u0003\u0003\u0003y!!\u0006+j[\u0016\u0014u.\u001e8eK\u0012\u001cFO]3b[*{\u0017N\u001c\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t#kA)\u0011C\u0007\u000f\u001d95\t!C\u0003\u0002\u0014)\u0005\u00111m\u001c\u0006\u0003+Y\t\u0011BZ;oGRLwN\\:\u000b\u0005]A\u0012aA1qS*\u0011\u0011\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!a\u0007\n\u0003#\r{\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0002\u001eA5\taD\u0003\u0002 \t\u0005)A/\u001f9fg&\u0011\u0011E\b\u0002\u0005\u0007J{w\u000fE\u0002$M!j\u0011\u0001\n\u0006\u0003K\u0019\tqaY8eK\u001e,g.\u0003\u0002(I\tA1i\\7qS2,'\u000fE\u0003*]A\u0002\u0004'D\u0001+\u0015\t)2F\u0003\u0002-[\u000511m\\7n_:T!a\u0006\u0005\n\u0005=R#\u0001\u0005$mCRTu.\u001b8Gk:\u001cG/[8o!\t\t4'D\u00013\u0015\ty\u0002\"\u0003\u00025e\t\u0019!k\\<\u0011\u0005YJT\"A\u001c\u000b\u0005a2\u0011\u0001B;uS2L!AO\u001c\u0003\u000f1{wmZ5oO\"AA\b\u0001BC\u0002\u0013%Q(\u0001\u0005k_&tG+\u001f9f+\u0005q\u0004CA F\u001b\u0005\u0001%BA\u0002B\u0015\t\u00115)A\u0005pa\u0016\u0014\u0018\r^8sg*\u0011A)L\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0001\nA!j\\5o)f\u0004X\r\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003?\u0003%Qw.\u001b8UsB,\u0007\u0005\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0003L\u00039aWM\u001a;M_^,'OQ8v]\u0012,\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0005\u0019>tw\r\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003M\u0003=aWM\u001a;M_^,'OQ8v]\u0012\u0004\u0003\u0002C+\u0001\u0005\u000b\u0007I\u0011B&\u0002\u001d1,g\r^+qa\u0016\u0014(i\\;oI\"Aq\u000b\u0001B\u0001B\u0003%A*A\bmK\u001a$X\u000b\u001d9fe\n{WO\u001c3!\u0011!I\u0006A!b\u0001\n\u0013Y\u0015aD1mY><X\r\u001a'bi\u0016tWm]:\t\u0011m\u0003!\u0011!Q\u0001\n1\u000b\u0001#\u00197m_^,G\rT1uK:,7o\u001d\u0011\t\u0011u\u0003!Q1A\u0005\ny\u000b\u0001\u0002\\3giRK\b/Z\u000b\u0002?B\u0019\u0001m\u0019\u0019\u000e\u0003\u0005T!AY\u0016\u0002\u0011QL\b/Z5oM>L!\u0001Z1\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:D\u0001B\u001a\u0001\u0003\u0002\u0003\u0006IaX\u0001\nY\u00164G\u000fV=qK\u0002B\u0001\u0002\u001b\u0001\u0003\u0006\u0004%IAX\u0001\ne&<\u0007\u000e\u001e+za\u0016D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006IaX\u0001\u000be&<\u0007\u000e\u001e+za\u0016\u0004\u0003\u0002\u00037\u0001\u0005\u000b\u0007I\u0011B7\u0002\u001f\u001d,gNS8j]\u001a+hn\u0019(b[\u0016,\u0012A\u001c\t\u0003_Jt!!\u00149\n\u0005Et\u0015A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!\u001d(\t\u0011Y\u0004!\u0011!Q\u0001\n9\f\u0001cZ3o\u0015>LgNR;oG:\u000bW.\u001a\u0011\t\u0011a\u0004!Q1A\u0005\n5\fqbZ3o\u0015>LgNR;oG\u000e{G-\u001a\u0005\tu\u0002\u0011\t\u0011)A\u0005]\u0006\u0001r-\u001a8K_&tg)\u001e8d\u0007>$W\r\t\u0005\u0006y\u0002!\t!`\u0001\u0007y%t\u0017\u000e\u001e \u0015#y\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty\u0001\u0005\u0002\u0000\u00015\t!\u0001C\u0003=w\u0002\u0007a\bC\u0003Kw\u0002\u0007A\nC\u0003Vw\u0002\u0007A\nC\u0003Zw\u0002\u0007A\nC\u0003^w\u0002\u0007q\fC\u0003iw\u0002\u0007q\fC\u0003mw\u0002\u0007a\u000eC\u0003yw\u0002\u0007a\u000eC\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016\u0005Y\u0001/\u00193eS:<W\u000b^5m+\t\t9\u0002E\u0002\u0000\u00033I1!a\u0007\u0003\u0005QyU\u000f^3s\u0015>Lg\u000eU1eI&tw-\u0016;jY\"A\u0011q\u0004\u0001!\u0002\u0013\t9\"\u0001\u0007qC\u0012$\u0017N\\4Vi&d\u0007\u0005C\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0012!\u00046pS:\u001cu\u000e\u001c7fGR|'/\u0006\u0002\u0002(A\u0019q0!\u000b\n\u0007\u0005-\"A\u0001\nF[&$\u0018i^1sK\u000e{G\u000e\\3di>\u0014\bbCA\u0018\u0001\u0001\u0007\t\u0019!C\u0005\u0003c\t\u0011C[8j]\u000e{G\u000e\\3di>\u0014x\fJ3r)\u0011\t\u0019$!\u000f\u0011\u00075\u000b)$C\u0002\u000289\u0013A!\u00168ji\"Q\u00111HA\u0017\u0003\u0003\u0005\r!a\n\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002@\u0001\u0001\u000b\u0015BA\u0014\u00039Qw.\u001b8D_2dWm\u0019;pe\u0002B1\"a\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002F\u0005a!n\\5o\rVt7\r^5p]V\t\u0001\u0006C\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n\u0005-\u0013\u0001\u00056pS:4UO\\2uS>tw\fJ3r)\u0011\t\u0019$!\u0014\t\u0013\u0005m\u0012qIA\u0001\u0002\u0004A\u0003bBA)\u0001\u0001\u0006K\u0001K\u0001\u000eU>LgNR;oGRLwN\u001c\u0011\t\u0017\u0005U\u0003\u00011AA\u0002\u0013%\u0011qK\u0001\nY\u00164GoQ1dQ\u0016,\"!!\u0017\u0011\u000f\u0005m\u0013\u0011\r'\u0002f5\u0011\u0011Q\f\u0006\u0004\u0003?Z\u0013!B:uCR,\u0017\u0002BA2\u0003;\u0012\u0001\"T1q'R\fG/\u001a\t\u0007\u0003O\ni'!\u001d\u000e\u0005\u0005%$b\u0001\u001d\u0002l)\tA)\u0003\u0003\u0002p\u0005%$\u0001\u0002'jgR\u0004r!a\u001d\u0002zA\ni(\u0004\u0002\u0002v)\u0019\u0011qO\"\u0002\u000bQ,\b\u000f\\3\n\t\u0005m\u0014Q\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00075\u000by(C\u0002\u0002\u0002:\u0013qAQ8pY\u0016\fg\u000eC\u0006\u0002\u0006\u0002\u0001\r\u00111A\u0005\n\u0005\u001d\u0015!\u00047fMR\u001c\u0015m\u00195f?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005%\u0005BCA\u001e\u0003\u0007\u000b\t\u00111\u0001\u0002Z!A\u0011Q\u0012\u0001!B\u0013\tI&\u0001\u0006mK\u001a$8)Y2iK\u0002B1\"!%\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\u0005Q!/[4ii\u000e\u000b7\r[3\t\u0017\u0005U\u0005\u00011AA\u0002\u0013%\u0011qS\u0001\u000fe&<\u0007\u000e^\"bG\",w\fJ3r)\u0011\t\u0019$!'\t\u0015\u0005m\u00121SA\u0001\u0002\u0004\tI\u0006\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0015BA-\u0003-\u0011\u0018n\u001a5u\u0007\u0006\u001c\u0007.\u001a\u0011\t\u0017\u0005\u0005\u0006\u00011AA\u0002\u0013%\u00111U\u0001\u000fY\u00164G\u000fV5nKJ\u001cF/\u0019;f+\t\t)\u000bE\u0003\u0002\\\u0005\u001dF*\u0003\u0003\u0002*\u0006u#A\u0003,bYV,7\u000b^1uK\"Y\u0011Q\u0016\u0001A\u0002\u0003\u0007I\u0011BAX\u0003IaWM\u001a;US6,'o\u0015;bi\u0016|F%Z9\u0015\t\u0005M\u0012\u0011\u0017\u0005\u000b\u0003w\tY+!AA\u0002\u0005\u0015\u0006\u0002CA[\u0001\u0001\u0006K!!*\u0002\u001f1,g\r\u001e+j[\u0016\u00148\u000b^1uK\u0002B1\"!/\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002$\u0006y!/[4iiRKW.\u001a:Ti\u0006$X\rC\u0006\u0002>\u0002\u0001\r\u00111A\u0005\n\u0005}\u0016a\u0005:jO\"$H+[7feN#\u0018\r^3`I\u0015\fH\u0003BA\u001a\u0003\u0003D!\"a\u000f\u0002<\u0006\u0005\t\u0019AAS\u0011!\t)\r\u0001Q!\n\u0005\u0015\u0016\u0001\u0005:jO\"$H+[7feN#\u0018\r^3!\u0011!\tI\r\u0001b\u0001\n#Y\u0015\u0001\u00057fMR\u0014V\r\\1uSZ,7+\u001b>f\u0011\u001d\ti\r\u0001Q\u0001\n1\u000b\u0011\u0003\\3giJ+G.\u0019;jm\u0016\u001c\u0016N_3!\u0011!\t\t\u000e\u0001b\u0001\n#Y\u0015!\u0005:jO\"$(+\u001a7bi&4XmU5{K\"9\u0011Q\u001b\u0001!\u0002\u0013a\u0015A\u0005:jO\"$(+\u001a7bi&4XmU5{K\u0002B\u0001\"!7\u0001\u0001\u0004%IaS\u0001\u0013Y\u00164G/\u0012=qSJ\fG/[8o)&lW\rC\u0005\u0002^\u0002\u0001\r\u0011\"\u0003\u0002`\u00061B.\u001a4u\u000bb\u0004\u0018N]1uS>tG+[7f?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005\u0005\b\"CA\u001e\u00037\f\t\u00111\u0001M\u0011\u001d\t)\u000f\u0001Q!\n1\u000b1\u0003\\3gi\u0016C\b/\u001b:bi&|g\u000eV5nK\u0002B\u0001\"!;\u0001\u0001\u0004%IaS\u0001\u0014e&<\u0007\u000e^#ya&\u0014\u0018\r^5p]RKW.\u001a\u0005\n\u0003[\u0004\u0001\u0019!C\u0005\u0003_\fqC]5hQR,\u0005\u0010]5sCRLwN\u001c+j[\u0016|F%Z9\u0015\t\u0005M\u0012\u0011\u001f\u0005\n\u0003w\tY/!AA\u00021Cq!!>\u0001A\u0003&A*\u0001\u000bsS\u001eDG/\u0012=qSJ\fG/[8o)&lW\r\t\u0005\t\u0003s\u0004\u0001\u0019!C\t\u0017\u0006\u0001B.\u001a4u\u001fB,'/\u0019;peRKW.\u001a\u0005\n\u0003{\u0004\u0001\u0019!C\t\u0003\u007f\fA\u0003\\3gi>\u0003XM]1u_J$\u0016.\\3`I\u0015\fH\u0003BA\u001a\u0005\u0003A\u0011\"a\u000f\u0002|\u0006\u0005\t\u0019\u0001'\t\u000f\t\u0015\u0001\u0001)Q\u0005\u0019\u0006\tB.\u001a4u\u001fB,'/\u0019;peRKW.\u001a\u0011\t\u0011\t%\u0001\u00011A\u0005\u0012-\u000b\u0011C]5hQR|\u0005/\u001a:bi>\u0014H+[7f\u0011%\u0011i\u0001\u0001a\u0001\n#\u0011y!A\u000bsS\u001eDGo\u00149fe\u0006$xN\u001d+j[\u0016|F%Z9\u0015\t\u0005M\"\u0011\u0003\u0005\n\u0003w\u0011Y!!AA\u00021CqA!\u0006\u0001A\u0003&A*\u0001\nsS\u001eDGo\u00149fe\u0006$xN\u001d+j[\u0016\u0004\u0003\u0002\u0003B\r\u0001\t\u0007I\u0011B&\u0002%5Lgn\u00117fC:,\u0006/\u00138uKJ4\u0018\r\u001c\u0005\b\u0005;\u0001\u0001\u0015!\u0003M\u0003Mi\u0017N\\\"mK\u0006tW\u000b]%oi\u0016\u0014h/\u00197!\u0011\u001d\u0011\t\u0003\u0001C!\u0005G\tAa\u001c9f]R!\u00111\u0007B\u0013\u0011!\u00119Ca\bA\u0002\t%\u0012AB2p]\u001aLw\r\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011y\u0003C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\tM\"Q\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\t]\u0002\u0001\"\u0011\u0003:\u0005y\u0001O]8dKN\u001cX\t\\3nK:$\u0018\u0007\u0006\u0005\u00024\tm\"q\bB%\u0011\u001d\u0011iD!\u000eA\u0002q\t\u0011b\u0019*poZ\u000bG.^3\t\u0011\t\u0005#Q\u0007a\u0001\u0005\u0007\n1a\u0019;y!\r\u0001\"QI\u0005\u0004\u0005\u000fR\"aB\"p]R,\u0007\u0010\u001e\u0005\t\u0005\u0017\u0012)\u00041\u0001\u0003N\u0005\u0019q.\u001e;\u0011\u000b\t=#1\u000b\u000f\u000e\u0005\tE#B\u0001\u001d\t\u0013\u0011\u0011)F!\u0015\u0003\u0013\r{G\u000e\\3di>\u0014\bb\u0002B-\u0001\u0011\u0005#1L\u0001\u0010aJ|7-Z:t\u000b2,W.\u001a8ueQA\u00111\u0007B/\u0005?\u0012\t\u0007C\u0004\u0003>\t]\u0003\u0019\u0001\u000f\t\u0011\t\u0005#q\u000ba\u0001\u0005\u0007B\u0001Ba\u0013\u0003X\u0001\u0007!Q\n\u0005\b\u0005K\u0002A\u0011\tB4\u0003\u001dyg\u000eV5nKJ$\u0002\"a\r\u0003j\t5$Q\u000f\u0005\b\u0005W\u0012\u0019\u00071\u0001M\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0003B\t\r\u0004\u0019\u0001B8!\r\u0001\"\u0011O\u0005\u0004\u0005gR\"AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0005\u0017\u0012\u0019\u00071\u0001\u0003N!9!\u0011\u0010\u0001\u0005\n\tm\u0014!E2bY\u0016C\b/\u001b:bi&|g\u000eV5nKR)AJ! \u0003\u0002\"9!q\u0010B<\u0001\u0004a\u0015\u0001D8qKJ\fGo\u001c:US6,\u0007b\u0002BB\u0005o\u0002\r\u0001T\u0001\re\u0016d\u0017\r^5wKNK'0\u001a\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0003Q\u0011XmZ5ti\u0016\u00148\t\\3b]V\u0003H+[7feRA\u00111\u0007BF\u0005\u001b\u0013\t\n\u0003\u0005\u0003B\t\u0015\u0005\u0019\u0001B\"\u0011\u001d\u0011yI!\"A\u00021\u000bqA]8x)&lW\r\u0003\u0005\u0003\u0014\n\u0015\u0005\u0019AA?\u0003\u001daWM\u001a;S_^DqAa&\u0001\t\u0013\u0011I*A\tsK6|g/Z#ya&\u0014X\r\u001a*poN$b\"a\r\u0003\u001c\n\u0005&Q\u0015BU\u0005[\u0013y\u000b\u0003\u0005\u0003\u001e\nU\u0005\u0019\u0001BP\u0003%\u0019w\u000e\u001c7fGR|'\u000fE\u0003\u0003P\tM\u0003\u0007C\u0004\u0003$\nU\u0005\u0019\u0001'\u0002\u001d\u0015D\b/\u001b:bi&|g\u000eV5nK\"A!q\u0015BK\u0001\u0004\tI&\u0001\u0005s_^\u001c\u0015m\u00195f\u0011!\u0011YK!&A\u0002\u0005\u0015\u0016A\u0003;j[\u0016\u00148\u000b^1uK\"A!\u0011\tBK\u0001\u0004\u0011y\u0007\u0003\u0005\u00032\nU\u0005\u0019AA?\u0003)\u0011X-\\8wK2+g\r\u001e\u0005\b\u0005k\u0003a\u0011\u0001B\\\u0003I)\b\u000fZ1uK>\u0003XM]1u_J$\u0016.\\3\u0015\t\u0005M\"\u0011\u0018\u0005\t\u0005\u0003\u0012\u0019\f1\u0001\u0003D!9!Q\u0018\u0001\u0007\u0002\t}\u0016\u0001F4fiRKW.\u001a$pe2+g\r^*ue\u0016\fW\u000eF\u0003M\u0005\u0003\u0014)\r\u0003\u0005\u0003D\nm\u0006\u0019\u0001B\"\u0003\u001d\u0019wN\u001c;fqRDqAa2\u0003<\u0002\u0007\u0001'A\u0002s_^DqAa3\u0001\r\u0003\u0011i-A\u000bhKR$\u0016.\\3G_J\u0014\u0016n\u001a5u'R\u0014X-Y7\u0015\u000b1\u0013yM!5\t\u0011\t\r'\u0011\u001aa\u0001\u0005\u0007BqAa2\u0003J\u0002\u0007\u0001\u0007C\u0004\u0003V\u00021\tAa6\u0002\u001bI,w-[:uKJ$\u0016.\\3s)\u0019\t\u0019D!7\u0003\\\"A!\u0011\tBj\u0001\u0004\u0011\u0019\u0005C\u0004\u0003^\nM\u0007\u0019\u0001'\u0002\u0017\rdW-\u00198vaRKW.\u001a")
public abstract class TimeBoundedStreamJoin
extends CoProcessFunction<CRow, CRow, CRow>
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final JoinType joinType;
    private final long leftLowerBound;
    private final long leftUpperBound;
    private final long allowedLateness;
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final OuterJoinPaddingUtil paddingUtil;
    private EmitAwareCollector joinCollector;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private MapState<Object, List<Tuple2<Row, Object>>> leftCache;
    private MapState<Object, List<Tuple2<Row, Object>>> rightCache;
    private ValueState<Object> leftTimerState;
    private ValueState<Object> rightTimerState;
    private final long leftRelativeSize;
    private final long rightRelativeSize;
    private long leftExpirationTime;
    private long rightExpirationTime;
    private long leftOperatorTime;
    private long rightOperatorTime;
    private final long minCleanUpInterval;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TimeBoundedStreamJoin timeBoundedStreamJoin = this;
        synchronized (timeBoundedStreamJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private JoinType joinType() {
        return this.joinType;
    }

    private long leftLowerBound() {
        return this.leftLowerBound;
    }

    private long leftUpperBound() {
        return this.leftUpperBound;
    }

    private long allowedLateness() {
        return this.allowedLateness;
    }

    private TypeInformation<Row> leftType() {
        return this.leftType;
    }

    private TypeInformation<Row> rightType() {
        return this.rightType;
    }

    private String genJoinFuncName() {
        return this.genJoinFuncName;
    }

    private String genJoinFuncCode() {
        return this.genJoinFuncCode;
    }

    private OuterJoinPaddingUtil paddingUtil() {
        return this.paddingUtil;
    }

    private EmitAwareCollector joinCollector() {
        return this.joinCollector;
    }

    private void joinCollector_$eq(EmitAwareCollector x$1) {
        this.joinCollector = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    private MapState<Object, List<Tuple2<Row, Object>>> leftCache() {
        return this.leftCache;
    }

    private void leftCache_$eq(MapState<Object, List<Tuple2<Row, Object>>> x$1) {
        this.leftCache = x$1;
    }

    private MapState<Object, List<Tuple2<Row, Object>>> rightCache() {
        return this.rightCache;
    }

    private void rightCache_$eq(MapState<Object, List<Tuple2<Row, Object>>> x$1) {
        this.rightCache = x$1;
    }

    private ValueState<Object> leftTimerState() {
        return this.leftTimerState;
    }

    private void leftTimerState_$eq(ValueState<Object> x$1) {
        this.leftTimerState = x$1;
    }

    private ValueState<Object> rightTimerState() {
        return this.rightTimerState;
    }

    private void rightTimerState_$eq(ValueState<Object> x$1) {
        this.rightTimerState = x$1;
    }

    public long leftRelativeSize() {
        return this.leftRelativeSize;
    }

    public long rightRelativeSize() {
        return this.rightRelativeSize;
    }

    private long leftExpirationTime() {
        return this.leftExpirationTime;
    }

    private void leftExpirationTime_$eq(long x$1) {
        this.leftExpirationTime = x$1;
    }

    private long rightExpirationTime() {
        return this.rightExpirationTime;
    }

    private void rightExpirationTime_$eq(long x$1) {
        this.rightExpirationTime = x$1;
    }

    public long leftOperatorTime() {
        return this.leftOperatorTime;
    }

    public void leftOperatorTime_$eq(long x$1) {
        this.leftOperatorTime = x$1;
    }

    public long rightOperatorTime() {
        return this.rightOperatorTime;
    }

    public void rightOperatorTime_$eq(long x$1) {
        this.rightOperatorTime = x$1;
    }

    private long minCleanUpInterval() {
        return this.minCleanUpInterval;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling JoinFunction: ", " \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncCode()}))).toString());
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName(), this.genJoinFuncCode());
        this.LOG().debug("Instantiating JoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        this.joinCollector_$eq(new EmitAwareCollector());
        this.joinCollector().setCRowChange(true);
        ListTypeInfo leftListTypeInfo = new ListTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{this.leftType(), BasicTypeInfo.BOOLEAN_TYPE_INFO}));
        MapStateDescriptor leftStateDescriptor = new MapStateDescriptor("WindowJoinLeftCache", Types$.MODULE$.LONG(), (TypeInformation)leftListTypeInfo);
        this.leftCache_$eq((MapState<Object, List<Tuple2<Row, Object>>>)this.getRuntimeContext().getMapState(leftStateDescriptor));
        ListTypeInfo rightListTypeInfo = new ListTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{this.rightType(), BasicTypeInfo.BOOLEAN_TYPE_INFO}));
        MapStateDescriptor rightStateDescriptor = new MapStateDescriptor("WindowJoinRightCache", Types$.MODULE$.LONG(), (TypeInformation)rightListTypeInfo);
        this.rightCache_$eq((MapState<Object, List<Tuple2<Row, Object>>>)this.getRuntimeContext().getMapState(rightStateDescriptor));
        ValueStateDescriptor leftTimerStateDesc = new ValueStateDescriptor("WindowJoinLeftTimerState", Long.TYPE);
        this.leftTimerState_$eq((ValueState<Object>)this.getRuntimeContext().getState(leftTimerStateDesc));
        ValueStateDescriptor rightTimerStateDesc = new ValueStateDescriptor("WindowJoinRightTimerState", Long.TYPE);
        this.rightTimerState_$eq((ValueState<Object>)this.getRuntimeContext().getState(rightTimerStateDesc));
    }

    public void processElement1(CRow cRowValue, CoProcessFunction.Context ctx, Collector<CRow> out) {
        block21: {
            boolean emitted;
            Row leftRow;
            block22: {
                block20: {
                    long rightQualifiedUpperBound;
                    long timeForLeftRow;
                    block17: {
                        this.joinCollector().innerCollector_$eq(out);
                        this.updateOperatorTime(ctx);
                        leftRow = cRowValue.row();
                        timeForLeftRow = this.getTimeForLeftStream(ctx, leftRow);
                        long rightQualifiedLowerBound = timeForLeftRow - this.rightRelativeSize();
                        rightQualifiedUpperBound = timeForLeftRow + this.leftRelativeSize();
                        emitted = false;
                        if (this.rightExpirationTime() >= rightQualifiedUpperBound) break block17;
                        this.rightExpirationTime_$eq(this.calExpirationTime(this.leftOperatorTime(), this.rightRelativeSize()));
                        Iterator rightIterator = this.rightCache().iterator();
                        while (rightIterator.hasNext()) {
                            block19: {
                                Map.Entry rightEntry;
                                block18: {
                                    Object object;
                                    rightEntry = (Map.Entry)rightIterator.next();
                                    long rightTime = BoxesRunTime.unboxToLong(rightEntry.getKey());
                                    if (rightTime >= rightQualifiedLowerBound && rightTime <= rightQualifiedUpperBound) {
                                        List rightRows = (List)rightEntry.getValue();
                                        boolean entryUpdated = false;
                                        for (int i = 0; i < rightRows.size(); ++i) {
                                            this.joinCollector().reset();
                                            Tuple2 tuple = (Tuple2)rightRows.get(i);
                                            this.joinFunction().join((Object)leftRow, tuple.f0, (Collector)this.joinCollector());
                                            emitted = emitted || this.joinCollector().emitted();
                                            JoinType joinType = this.joinType();
                                            JoinType joinType2 = JoinType.RIGHT_OUTER;
                                            if (joinType == null ? joinType2 != null : !joinType.equals(joinType2)) {
                                                JoinType joinType3 = this.joinType();
                                                JoinType joinType4 = JoinType.FULL_OUTER;
                                                if (joinType3 != null ? !joinType3.equals(joinType4) : joinType4 != null) continue;
                                            }
                                            if (BoxesRunTime.unboxToBoolean((Object)tuple.f1) || !this.joinCollector().emitted()) continue;
                                            tuple.f1 = BoxesRunTime.boxToBoolean((boolean)true);
                                            entryUpdated = true;
                                        }
                                        object = entryUpdated ? rightEntry.setValue(rightRows) : BoxedUnit.UNIT;
                                    } else {
                                        object = BoxedUnit.UNIT;
                                    }
                                    if (rightTime > this.rightExpirationTime()) continue;
                                    JoinType joinType = this.joinType();
                                    JoinType joinType5 = JoinType.RIGHT_OUTER;
                                    if (!(joinType == null ? joinType5 != null : !joinType.equals(joinType5))) break block18;
                                    JoinType joinType6 = this.joinType();
                                    JoinType joinType7 = JoinType.FULL_OUTER;
                                    if (joinType6 != null ? !joinType6.equals(joinType7) : joinType7 != null) break block19;
                                }
                                List rightRows = (List)rightEntry.getValue();
                                for (int i = 0; i < rightRows.size(); ++i) {
                                    Tuple2 tuple = (Tuple2)rightRows.get(i);
                                    if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                                    this.joinCollector().collect(this.paddingUtil().padRight((Row)tuple.f0));
                                }
                            }
                            rightIterator.remove();
                        }
                    }
                    if (this.rightOperatorTime() >= rightQualifiedUpperBound) break block20;
                    ArrayList<Tuple2> leftRowList = (ArrayList<Tuple2>)this.leftCache().get((Object)BoxesRunTime.boxToLong((long)timeForLeftRow));
                    if (leftRowList == null) {
                        leftRowList = new ArrayList<Tuple2>(1);
                    }
                    leftRowList.add(Tuple2.of((Object)leftRow, (Object)BoxesRunTime.boxToBoolean((boolean)emitted)));
                    this.leftCache().put((Object)BoxesRunTime.boxToLong((long)timeForLeftRow), leftRowList);
                    if (BoxesRunTime.unboxToLong((Object)this.rightTimerState().value()) == 0L) {
                        this.registerCleanUpTimer(ctx, timeForLeftRow, true);
                    }
                    break block21;
                }
                JoinType joinType = this.joinType();
                JoinType joinType8 = JoinType.LEFT_OUTER;
                if (!(joinType == null ? joinType8 != null : !joinType.equals(joinType8))) break block22;
                JoinType joinType9 = this.joinType();
                JoinType joinType10 = JoinType.FULL_OUTER;
                if (joinType9 != null ? !joinType9.equals(joinType10) : joinType10 != null) break block21;
            }
            if (!emitted) {
                this.joinCollector().collect(this.paddingUtil().padLeft(leftRow));
            }
        }
    }

    public void processElement2(CRow cRowValue, CoProcessFunction.Context ctx, Collector<CRow> out) {
        block21: {
            boolean emitted;
            Row rightRow;
            block22: {
                block20: {
                    long leftQualifiedUpperBound;
                    long timeForRightRow;
                    block17: {
                        this.joinCollector().innerCollector_$eq(out);
                        this.updateOperatorTime(ctx);
                        rightRow = cRowValue.row();
                        timeForRightRow = this.getTimeForRightStream(ctx, rightRow);
                        long leftQualifiedLowerBound = timeForRightRow - this.leftRelativeSize();
                        leftQualifiedUpperBound = timeForRightRow + this.rightRelativeSize();
                        emitted = false;
                        if (this.leftExpirationTime() >= leftQualifiedUpperBound) break block17;
                        this.leftExpirationTime_$eq(this.calExpirationTime(this.rightOperatorTime(), this.leftRelativeSize()));
                        Iterator leftIterator = this.leftCache().iterator();
                        while (leftIterator.hasNext()) {
                            block19: {
                                Map.Entry leftEntry;
                                block18: {
                                    Object object;
                                    leftEntry = (Map.Entry)leftIterator.next();
                                    long leftTime = BoxesRunTime.unboxToLong(leftEntry.getKey());
                                    if (leftTime >= leftQualifiedLowerBound && leftTime <= leftQualifiedUpperBound) {
                                        List leftRows = (List)leftEntry.getValue();
                                        boolean entryUpdated = false;
                                        for (int i = 0; i < leftRows.size(); ++i) {
                                            this.joinCollector().reset();
                                            Tuple2 tuple = (Tuple2)leftRows.get(i);
                                            this.joinFunction().join(tuple.f0, (Object)rightRow, (Collector)this.joinCollector());
                                            emitted = emitted || this.joinCollector().emitted();
                                            JoinType joinType = this.joinType();
                                            JoinType joinType2 = JoinType.LEFT_OUTER;
                                            if (joinType == null ? joinType2 != null : !joinType.equals(joinType2)) {
                                                JoinType joinType3 = this.joinType();
                                                JoinType joinType4 = JoinType.FULL_OUTER;
                                                if (joinType3 != null ? !joinType3.equals(joinType4) : joinType4 != null) continue;
                                            }
                                            if (BoxesRunTime.unboxToBoolean((Object)tuple.f1) || !this.joinCollector().emitted()) continue;
                                            tuple.f1 = BoxesRunTime.boxToBoolean((boolean)true);
                                            entryUpdated = true;
                                        }
                                        object = entryUpdated ? leftEntry.setValue(leftRows) : BoxedUnit.UNIT;
                                    } else {
                                        object = BoxedUnit.UNIT;
                                    }
                                    if (leftTime > this.leftExpirationTime()) continue;
                                    JoinType joinType = this.joinType();
                                    JoinType joinType5 = JoinType.LEFT_OUTER;
                                    if (!(joinType == null ? joinType5 != null : !joinType.equals(joinType5))) break block18;
                                    JoinType joinType6 = this.joinType();
                                    JoinType joinType7 = JoinType.FULL_OUTER;
                                    if (joinType6 != null ? !joinType6.equals(joinType7) : joinType7 != null) break block19;
                                }
                                List leftRows = (List)leftEntry.getValue();
                                for (int i = 0; i < leftRows.size(); ++i) {
                                    Tuple2 tuple = (Tuple2)leftRows.get(i);
                                    if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                                    this.joinCollector().collect(this.paddingUtil().padLeft((Row)tuple.f0));
                                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Emitting a null padding result for left row ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple.f0})));
                                }
                            }
                            leftIterator.remove();
                        }
                    }
                    if (this.leftOperatorTime() >= leftQualifiedUpperBound) break block20;
                    ArrayList<Tuple2> rightRowList = (ArrayList<Tuple2>)this.rightCache().get((Object)BoxesRunTime.boxToLong((long)timeForRightRow));
                    if (rightRowList == null) {
                        rightRowList = new ArrayList<Tuple2>(1);
                    }
                    rightRowList.add(new Tuple2((Object)rightRow, (Object)BoxesRunTime.boxToBoolean((boolean)emitted)));
                    this.rightCache().put((Object)BoxesRunTime.boxToLong((long)timeForRightRow), rightRowList);
                    if (BoxesRunTime.unboxToLong((Object)this.leftTimerState().value()) == 0L) {
                        this.registerCleanUpTimer(ctx, timeForRightRow, false);
                    }
                    break block21;
                }
                JoinType joinType = this.joinType();
                JoinType joinType8 = JoinType.RIGHT_OUTER;
                if (!(joinType == null ? joinType8 != null : !joinType.equals(joinType8))) break block22;
                JoinType joinType9 = this.joinType();
                JoinType joinType10 = JoinType.FULL_OUTER;
                if (joinType9 != null ? !joinType9.equals(joinType10) : joinType10 != null) break block21;
            }
            if (!emitted) {
                this.joinCollector().collect(this.paddingUtil().padRight(rightRow));
            }
        }
    }

    public void onTimer(long timestamp, CoProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        this.joinCollector().innerCollector_$eq(out);
        this.updateOperatorTime((CoProcessFunction.Context)ctx);
        if (BoxesRunTime.unboxToLong((Object)this.leftTimerState().value()) == timestamp) {
            this.rightExpirationTime_$eq(this.calExpirationTime(this.leftOperatorTime(), this.rightRelativeSize()));
            this.removeExpiredRows(this.joinCollector(), this.rightExpirationTime(), this.rightCache(), this.leftTimerState(), ctx, false);
        }
        if (BoxesRunTime.unboxToLong((Object)this.rightTimerState().value()) == timestamp) {
            this.leftExpirationTime_$eq(this.calExpirationTime(this.rightOperatorTime(), this.leftRelativeSize()));
            this.removeExpiredRows(this.joinCollector(), this.leftExpirationTime(), this.leftCache(), this.rightTimerState(), ctx, true);
        }
    }

    private long calExpirationTime(long operatorTime, long relativeSize) {
        return operatorTime < Long.MAX_VALUE ? operatorTime - relativeSize - this.allowedLateness() - 1L : Long.MAX_VALUE;
    }

    private void registerCleanUpTimer(CoProcessFunction.Context ctx, long rowTime, boolean leftRow) {
        if (leftRow) {
            long cleanupTime = rowTime + this.leftRelativeSize() + this.minCleanUpInterval() + this.allowedLateness() + 1L;
            this.registerTimer(ctx, cleanupTime);
            this.rightTimerState().update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        } else {
            long cleanupTime = rowTime + this.rightRelativeSize() + this.minCleanUpInterval() + this.allowedLateness() + 1L;
            this.registerTimer(ctx, cleanupTime);
            this.leftTimerState().update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        }
    }

    private void removeExpiredRows(Collector<Row> collector, long expirationTime, MapState<Object, List<Tuple2<Row, Object>>> rowCache, ValueState<Object> timerState, CoProcessFunction.OnTimerContext ctx, boolean removeLeft) {
        Iterator iterator = rowCache.iterator();
        long earliestTimestamp = -1L;
        while (iterator.hasNext()) {
            long rowTime;
            block6: {
                block9: {
                    Map.Entry entry;
                    block10: {
                        block7: {
                            block8: {
                                entry = (Map.Entry)iterator.next();
                                rowTime = BoxesRunTime.unboxToLong(entry.getKey());
                                if (rowTime > expirationTime) break block6;
                                if (!removeLeft) break block7;
                                JoinType joinType = this.joinType();
                                JoinType joinType2 = JoinType.LEFT_OUTER;
                                if (!(joinType == null ? joinType2 != null : !joinType.equals(joinType2))) break block8;
                                JoinType joinType3 = this.joinType();
                                JoinType joinType4 = JoinType.FULL_OUTER;
                                if (joinType3 != null ? !joinType3.equals(joinType4) : joinType4 != null) break block7;
                            }
                            List rows = (List)entry.getValue();
                            for (int i = 0; i < rows.size(); ++i) {
                                Tuple2 tuple = (Tuple2)rows.get(i);
                                if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                                collector.collect((Object)this.paddingUtil().padLeft((Row)tuple.f0));
                            }
                            break block9;
                        }
                        if (removeLeft) break block9;
                        JoinType joinType = this.joinType();
                        JoinType joinType5 = JoinType.RIGHT_OUTER;
                        if (!(joinType == null ? joinType5 != null : !joinType.equals(joinType5))) break block10;
                        JoinType joinType6 = this.joinType();
                        JoinType joinType7 = JoinType.FULL_OUTER;
                        if (joinType6 != null ? !joinType6.equals(joinType7) : joinType7 != null) break block9;
                    }
                    List rows = (List)entry.getValue();
                    for (int i = 0; i < rows.size(); ++i) {
                        Tuple2 tuple = (Tuple2)rows.get(i);
                        if (BoxesRunTime.unboxToBoolean((Object)tuple.f1)) continue;
                        collector.collect((Object)this.paddingUtil().padRight((Row)tuple.f0));
                    }
                }
                iterator.remove();
                continue;
            }
            if (rowTime >= earliestTimestamp && earliestTimestamp >= 0L) continue;
            earliestTimestamp = rowTime;
        }
        if (earliestTimestamp > 0L) {
            this.registerCleanUpTimer((CoProcessFunction.Context)ctx, earliestTimestamp, removeLeft);
        } else {
            timerState.clear();
            rowCache.clear();
        }
    }

    public abstract void updateOperatorTime(CoProcessFunction.Context var1);

    public abstract long getTimeForLeftStream(CoProcessFunction.Context var1, Row var2);

    public abstract long getTimeForRightStream(CoProcessFunction.Context var1, Row var2);

    public abstract void registerTimer(CoProcessFunction.Context var1, long var2);

    public TimeBoundedStreamJoin(JoinType joinType, long leftLowerBound, long leftUpperBound, long allowedLateness, TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode) {
        this.joinType = joinType;
        this.leftLowerBound = leftLowerBound;
        this.leftUpperBound = leftUpperBound;
        this.allowedLateness = allowedLateness;
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        this.paddingUtil = new OuterJoinPaddingUtil(leftType.getArity(), rightType.getArity());
        this.leftRelativeSize = -leftLowerBound;
        this.rightRelativeSize = leftUpperBound;
        this.leftExpirationTime = 0L;
        this.rightExpirationTime = 0L;
        this.leftOperatorTime = 0L;
        this.rightOperatorTime = 0L;
        this.minCleanUpInterval = (this.leftRelativeSize() + this.rightRelativeSize()) / 2L;
        if (allowedLateness < 0L) {
            throw new IllegalArgumentException("The allowed lateness must be non-negative.");
        }
    }
}

