/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.flink.table.api.AmbiguousTableSourceException;
import org.apache.flink.table.api.NoMatchingTableSourceException;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorProperties$;
import org.apache.flink.table.descriptors.FormatDescriptorValidator$;
import org.apache.flink.table.descriptors.MetadataValidator$;
import org.apache.flink.table.descriptors.StatisticsValidator$;
import org.apache.flink.table.descriptors.TableSourceDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceFactory;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class TableSourceFactoryService$
implements Logging {
    public static final TableSourceFactoryService$ MODULE$;
    private ServiceLoader<TableSourceFactory<?>> defaultLoader;
    private final transient Logger LOG;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new TableSourceFactoryService$();
    }

    private ServiceLoader defaultLoader$lzycompute() {
        TableSourceFactoryService$ tableSourceFactoryService$ = this;
        synchronized (tableSourceFactoryService$) {
            if (!this.bitmap$0) {
                this.defaultLoader = ServiceLoader.load(TableSourceFactory.class);
                this.bitmap$0 = true;
            }
            return this.defaultLoader;
        }
    }

    private Logger LOG$lzycompute() {
        TableSourceFactoryService$ tableSourceFactoryService$ = this;
        synchronized (tableSourceFactoryService$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    private ServiceLoader<TableSourceFactory<?>> defaultLoader() {
        return this.bitmap$0 ? this.defaultLoader : this.defaultLoader$lzycompute();
    }

    public TableSource<?> findAndCreateTableSource(TableSourceDescriptor descriptor) {
        return this.findAndCreateTableSource(descriptor, null);
    }

    public TableSource<?> findAndCreateTableSource(TableSourceDescriptor descriptor, ClassLoader classLoader) {
        DescriptorProperties properties2 = new DescriptorProperties(DescriptorProperties$.MODULE$.$lessinit$greater$default$1());
        descriptor.addProperties(properties2);
        return this.findAndCreateTableSource((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties2.asMap()).asScala()).toMap(Predef$.MODULE$.$conforms()), classLoader);
    }

    public TableSource<?> findAndCreateTableSource(scala.collection.immutable.Map<String, String> properties2) {
        return this.findAndCreateTableSource(properties2, null);
    }

    /*
     * Loose catch block
     */
    public TableSource<?> findAndCreateTableSource(scala.collection.immutable.Map<String, String> properties2, ClassLoader classLoader) {
        TableSourceFactory factory;
        TableSourceFactory<?> factory2;
        Iterator<TableSourceFactory<?>> iter;
        Iterator<TableSourceFactory<?>> iterator;
        None$ matchingFactory = None$.MODULE$;
        if (classLoader == null) {
            iterator = this.defaultLoader().iterator();
        } else {
            ServiceLoader<TableSourceFactory> customLoader = ServiceLoader.load(TableSourceFactory.class, classLoader);
            iterator = iter = customLoader.iterator();
        }
        while (iter.hasNext()) {
            factory2 = iter.next();
            java.util.Map<String, String> requiredContextJava = factory2.requiredContext();
            Map requiredContext = requiredContextJava == null ? (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$) : (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requiredContextJava).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, String> e2) {
                    return new Tuple2((Object)((String)e2._1()).toLowerCase(), e2._2());
                }
            }, Map$.MODULE$.canBuildFrom());
            scala.collection.mutable.Map plainContext = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            plainContext.$plus$plus$eq((TraversableOnce)requiredContext);
            plainContext.remove((Object)ConnectorDescriptorValidator$.MODULE$.CONNECTOR_PROPERTY_VERSION());
            plainContext.remove((Object)FormatDescriptorValidator$.MODULE$.FORMAT_PROPERTY_VERSION());
            plainContext.remove((Object)MetadataValidator$.MODULE$.METADATA_PROPERTY_VERSION());
            plainContext.remove((Object)StatisticsValidator$.MODULE$.STATISTICS_PROPERTY_VERSION());
            if (!plainContext.forall((Function1)new Serializable(properties2){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map properties$1;

                public final boolean apply(Tuple2<String, String> e2) {
                    return this.properties$1.contains(e2._1()) && BoxesRunTime.equals((Object)this.properties$1.apply(e2._1()), (Object)e2._2());
                }
                {
                    this.properties$1 = properties$1;
                }
            })) continue;
            None$ none$ = matchingFactory;
            if (none$ instanceof Some) {
                throw new AmbiguousTableSourceException(properties2);
            }
            if (None$.MODULE$.equals(none$)) {
                matchingFactory = new Some((Object)new Tuple2(factory2, (Object)requiredContext.keys().toSeq()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)none$);
        }
        Tuple2 tuple2 = (Tuple2)matchingFactory.getOrElse((Function0)new Serializable(properties2){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map properties$1;

            public final Nothing$ apply() {
                throw new NoMatchingTableSourceException((scala.collection.immutable.Map<String, String>)this.properties$1);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            TableSourceFactory factory3 = (TableSourceFactory)tuple2._1();
            Seq context = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)factory3, (Object)context);
            factory = (TableSourceFactory)tuple23._1();
            Seq context2 = (Seq)tuple23._2();
            ArrayBuffer plainProperties = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            properties2.keys().foreach((Function1)new Serializable(context2, plainProperties){
                public static final long serialVersionUID = 0L;
                private final Seq context$1;
                private final ArrayBuffer plainProperties$1;

                public final Object apply(String k) {
                    String key = k.replaceAll(".\\d+", ".#");
                    return this.context$1.contains((Object)key) || this.plainProperties$1.contains((Object)key) ? BoxedUnit.UNIT : this.plainProperties$1.$plus$eq((Object)key);
                }
                {
                    this.context$1 = context$1;
                    this.plainProperties$1 = plainProperties$1;
                }
            });
            List<String> supportedPropertiesJava = factory.supportedProperties();
            Seq supportedProperties = supportedPropertiesJava == null ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(supportedPropertiesJava).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.toLowerCase();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            plainProperties.foreach((Function1)new Serializable(factory, supportedProperties){
                public static final long serialVersionUID = 0L;
                private final TableSourceFactory factory$1;
                private final Seq supportedProperties$1;

                public final void apply(String k) {
                    if (this.supportedProperties$1.contains((Object)k)) {
                        return;
                    }
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table factory '", "' does not support the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.factory$1.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"property '", "'. Supported properties are: \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.supportedProperties$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String keyOrValue) {
                            return DescriptorProperties$.MODULE$.toString(keyOrValue);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("\n")}))).toString());
                }
                {
                    this.factory$1 = factory$1;
                    this.supportedProperties$1 = supportedProperties$1;
                }
            });
            return factory.create((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(properties2).asJava());
        }
        throw new MatchError((Object)tuple2);
        {
            catch (Throwable throwable) {
                try {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table source factory '", "' caused an exception."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factory2.getClass().getCanonicalName()})), throwable);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    this.LOG().error("Could not load service provider for table source factories.", (Throwable)serviceConfigurationError);
                    throw new TableException("Could not load service provider for table source factories.", serviceConfigurationError);
                }
            }
        }
        catch (Throwable throwable) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table source factory '", "' caused an exception."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factory.getClass().getCanonicalName()})), throwable);
        }
        catch (Throwable throwable) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table source factory '", "' caused an exception."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factory.getClass().getCanonicalName()})), throwable);
        }
    }

    private TableSourceFactoryService$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

