/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.junit.rules.ExternalResource;

public class TestLoggerResource
extends ExternalResource {
    private static final LoggerContext LOGGER_CONTEXT = (LoggerContext)LogManager.getContext((boolean)false);
    private final String loggerName;
    private final org.slf4j.event.Level level;
    @Nullable
    private LoggerConfig backupLoggerConfig = null;
    private ConcurrentLinkedQueue<String> loggingEvents;

    public TestLoggerResource(Class<?> clazz, org.slf4j.event.Level level) {
        this(clazz.getCanonicalName(), level);
    }

    private TestLoggerResource(String loggerName, org.slf4j.event.Level level) {
        this.loggerName = loggerName;
        this.level = level;
    }

    public List<String> getMessages() {
        return new ArrayList<String>(this.loggingEvents);
    }

    private static String generateRandomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    protected void before() throws Throwable {
        this.loggingEvents = new ConcurrentLinkedQueue();
        LoggerConfig previousLoggerConfig = LOGGER_CONTEXT.getConfiguration().getLoggerConfig(this.loggerName);
        Level previousLevel = previousLoggerConfig.getLevel();
        Level userDefinedLevel = Level.getLevel((String)this.level.name());
        Level newLevel = userDefinedLevel.isMoreSpecificThan(previousLevel) ? previousLevel : userDefinedLevel;
        ThresholdFilter levelFilter = ThresholdFilter.createFilter((Level)userDefinedLevel, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        AbstractAppender testAppender = new AbstractAppender("test-appender-" + TestLoggerResource.generateRandomString(), (Filter)levelFilter, null, false, Property.EMPTY_ARRAY){

            public void append(LogEvent event) {
                TestLoggerResource.this.loggingEvents.add(event.getMessage().getFormattedMessage());
            }
        };
        testAppender.start();
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)true, (Level)newLevel, (String)this.loggerName, null, (AppenderRef[])new AppenderRef[0], null, (Configuration)LOGGER_CONTEXT.getConfiguration(), null);
        loggerConfig.addAppender((Appender)testAppender, null, null);
        if (previousLoggerConfig.getName().equals(this.loggerName)) {
            this.backupLoggerConfig = previousLoggerConfig;
            LOGGER_CONTEXT.getConfiguration().removeLogger(this.loggerName);
            for (Appender appender : previousLoggerConfig.getAppenders().values()) {
                loggerConfig.addAppender(appender, null, null);
            }
        }
        LOGGER_CONTEXT.getConfiguration().addLogger(this.loggerName, loggerConfig);
        LOGGER_CONTEXT.updateLoggers();
    }

    protected void after() {
        LOGGER_CONTEXT.getConfiguration().removeLogger(this.loggerName);
        if (this.backupLoggerConfig != null) {
            LOGGER_CONTEXT.getConfiguration().addLogger(this.loggerName, this.backupLoggerConfig);
            this.backupLoggerConfig = null;
        }
        LOGGER_CONTEXT.updateLoggers();
        this.loggingEvents = null;
    }

    public static SingleTestResource asSingleTestResource(String loggerName, org.slf4j.event.Level level) throws Throwable {
        return new SingleTestResource(loggerName, level);
    }

    public static class SingleTestResource
    implements AutoCloseable {
        final TestLoggerResource resource;

        private SingleTestResource(String loggerName, org.slf4j.event.Level level) throws Throwable {
            this.resource = new TestLoggerResource(loggerName, level);
            this.resource.before();
        }

        @Override
        public void close() throws Exception {
            this.resource.after();
        }

        public List<String> getMessages() {
            return this.resource.getMessages();
        }
    }
}

