/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit;

import org.apache.flink.testutils.junit.RetryOnException;
import org.apache.flink.testutils.junit.RetryOnFailure;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRule
implements TestRule {
    public static final Logger LOG = LoggerFactory.getLogger(RetryRule.class);

    public Statement apply(Statement statement, Description description) {
        Test test;
        RetryOnFailure retryOnFailure = (RetryOnFailure)description.getAnnotation(RetryOnFailure.class);
        RetryOnException retryOnException = (RetryOnException)description.getAnnotation(RetryOnException.class);
        if ((retryOnFailure != null || retryOnException != null) && (test = (Test)description.getAnnotation(Test.class)).expected() != Test.None.class) {
            throw new IllegalArgumentException("You cannot combine the RetryOnFailure annotation with the Test(expected) annotation.");
        }
        if (retryOnFailure != null && retryOnException != null) {
            throw new IllegalArgumentException("You cannot combine the RetryOnFailure and RetryOnException annotations.");
        }
        if (retryOnFailure != null) {
            return new RetryOnFailureStatement(retryOnFailure.times(), statement);
        }
        if (retryOnException != null) {
            return new RetryOnExceptionStatement(retryOnException.times(), retryOnException.exception(), statement);
        }
        return statement;
    }

    private static class RetryOnExceptionStatement
    extends Statement {
        private final Class<? extends Throwable> exceptionClass;
        private final int timesOnFailure;
        private final Statement statement;
        private int currentRun;

        private RetryOnExceptionStatement(int timesOnFailure, Class<? extends Throwable> exceptionClass, Statement statement) {
            if (timesOnFailure < 0) {
                throw new IllegalArgumentException("Negatives number of retries on failure");
            }
            if (exceptionClass == null) {
                throw new NullPointerException("exceptionClass");
            }
            this.exceptionClass = exceptionClass;
            this.timesOnFailure = timesOnFailure;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            this.currentRun = 0;
            while (this.currentRun <= this.timesOnFailure) {
                try {
                    this.statement.evaluate();
                    break;
                }
                catch (Throwable t) {
                    LOG.warn(String.format("Test run failed (%d/%d).", this.currentRun, this.timesOnFailure + 1), t);
                    if (!this.exceptionClass.isAssignableFrom(t.getClass()) || this.currentRun >= this.timesOnFailure) {
                        throw t;
                    }
                    ++this.currentRun;
                }
            }
        }
    }

    private static class RetryOnFailureStatement
    extends Statement {
        private final int timesOnFailure;
        private int currentRun;
        private final Statement statement;

        private RetryOnFailureStatement(int timesOnFailure, Statement statement) {
            if (timesOnFailure < 0) {
                throw new IllegalArgumentException("Negatives number of retries on failure");
            }
            this.timesOnFailure = timesOnFailure;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            this.currentRun = 0;
            while (this.currentRun <= this.timesOnFailure) {
                try {
                    this.statement.evaluate();
                    break;
                }
                catch (Throwable t) {
                    LOG.warn(String.format("Test run failed (%d/%d).", this.currentRun, this.timesOnFailure + 1), t);
                    if (this.currentRun == this.timesOnFailure) {
                        throw t;
                    }
                    ++this.currentRun;
                }
            }
        }
    }
}

