/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file.encryption;

import com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.flume.channel.file.encryption.CipherProvider;
import org.apache.flume.channel.file.encryption.DecryptionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCTRNoPaddingProvider
extends CipherProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AESCTRNoPaddingProvider.class);
    static final String TYPE = "AES/CTR/NoPadding";

    public CipherProvider.Encryptor.Builder<AESCTRNoPaddingEncryptor> newEncryptorBuilder() {
        return new EncryptorBuilder();
    }

    public CipherProvider.Decryptor.Builder<AESCTRNoPaddingDecryptor> newDecryptorBuilder() {
        return new DecryptorBuilder();
    }

    private static byte[] doFinal(Cipher cipher, byte[] input) throws DecryptionFailureException {
        try {
            return cipher.doFinal(input);
        }
        catch (Exception e) {
            String msg = "Unable to encrypt or decrypt data AES/CTR/NoPadding input.length " + input.length;
            LOG.error(msg, (Throwable)e);
            throw new DecryptionFailureException(msg, e);
        }
    }

    private static Cipher getCipher(Key key, int mode, byte[] parameters) {
        try {
            Cipher cipher = Cipher.getInstance(TYPE);
            cipher.init(mode, key, new IvParameterSpec(parameters));
            return cipher;
        }
        catch (Exception e) {
            String msg = "Unable to load key using transformation: AES/CTR/NoPadding";
            if (e instanceof InvalidKeyException) {
                try {
                    int maxAllowedLen = Cipher.getMaxAllowedKeyLength(TYPE);
                    if (maxAllowedLen < 256) {
                        msg = msg + "; Warning: Maximum allowed key length = " + maxAllowedLen + " with the available JCE security policy files. Have you installed the JCE unlimited strength jurisdiction policy files?";
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    msg = msg + "; Unable to find specified algorithm?";
                }
            }
            LOG.error(msg, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class AESCTRNoPaddingDecryptor
    extends CipherProvider.Decryptor {
        private Cipher cipher;

        private AESCTRNoPaddingDecryptor(Key key, byte[] parameters) {
            this.cipher = AESCTRNoPaddingProvider.getCipher(key, 2, parameters);
        }

        @Override
        public byte[] decrypt(byte[] cipherText) {
            return AESCTRNoPaddingProvider.doFinal(this.cipher, cipherText);
        }

        @Override
        public String getCodec() {
            return AESCTRNoPaddingProvider.TYPE;
        }
    }

    private static class AESCTRNoPaddingEncryptor
    extends CipherProvider.Encryptor {
        private byte[] parameters;
        private Cipher cipher;

        private AESCTRNoPaddingEncryptor(Key key, byte[] parameters) {
            this.parameters = parameters;
            this.cipher = AESCTRNoPaddingProvider.getCipher(key, 1, parameters);
        }

        @Override
        public byte[] getParameters() {
            return this.parameters;
        }

        @Override
        public String getCodec() {
            return AESCTRNoPaddingProvider.TYPE;
        }

        @Override
        public byte[] encrypt(byte[] clearText) {
            return AESCTRNoPaddingProvider.doFinal(this.cipher, clearText);
        }
    }

    public static class DecryptorBuilder
    extends CipherProvider.Decryptor.Builder<AESCTRNoPaddingDecryptor> {
        @Override
        public AESCTRNoPaddingDecryptor build() {
            return new AESCTRNoPaddingDecryptor(this.key, this.parameters);
        }
    }

    public static class EncryptorBuilder
    extends CipherProvider.Encryptor.Builder<AESCTRNoPaddingEncryptor> {
        @Override
        public AESCTRNoPaddingEncryptor build() {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            byte[] seed = new byte[12];
            SecureRandom random = new SecureRandom();
            random.nextBytes(seed);
            buffer.put(seed).putInt(1);
            return new AESCTRNoPaddingEncryptor(this.key, buffer.array());
        }
    }
}

