/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Test;

public class TestFileStatus {
    private static final Log LOG = LogFactory.getLog(TestFileStatus.class);
    static final int LENGTH = 1;
    static final int REPLICATION = 2;
    static final long BLKSIZE = 3L;
    static final long MTIME = 4L;
    static final long ATIME = 5L;
    static final String OWNER = "owner";
    static final String GROUP = "group";
    static final FsPermission PERMISSION = FsPermission.valueOf((String)"-rw-rw-rw-");
    static final Path PATH = new Path("path");

    @Test
    public void testFileStatusWritable() throws Exception {
        FileStatus[] tests = new FileStatus[]{new FileStatus(1L, false, 5, 3L, 4L, 5L, null, "", "", new Path("/a/b")), new FileStatus(0L, false, 1, 2L, 3L, new Path("/")), new FileStatus(1L, false, 5, 3L, 4L, 5L, null, "", "", new Path("/a/b"))};
        LOG.info((Object)"Writing FileStatuses to a ByteArrayOutputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        for (FileStatus fs : tests) {
            fs.write((DataOutput)out);
        }
        LOG.info((Object)"Creating ByteArrayInputStream object");
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        LOG.info((Object)"Testing if read objects are equal to written ones");
        FileStatus dest = new FileStatus();
        int iterator = 0;
        for (FileStatus fs : tests) {
            dest.readFields((DataInput)in);
            Assert.assertEquals((String)("Different FileStatuses in iteration " + iterator), (Object)dest, (Object)fs);
            ++iterator;
        }
    }

    @Test
    public void constructorFull() throws IOException {
        boolean isdir = false;
        Path symlink = new Path("symlink");
        FileStatus fileStatus = new FileStatus(1L, isdir, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, symlink, PATH);
        this.validateAccessors(fileStatus, 1L, isdir, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, symlink, PATH);
    }

    @Test
    public void constructorNoSymlink() throws IOException {
        boolean isdir = true;
        FileStatus fileStatus = new FileStatus(1L, isdir, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, PATH);
        this.validateAccessors(fileStatus, 1L, isdir, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, null, PATH);
    }

    @Test
    public void constructorNoOwner() throws IOException {
        boolean isdir = true;
        FileStatus fileStatus = new FileStatus(1L, isdir, 2, 3L, 4L, PATH);
        this.validateAccessors(fileStatus, 1L, isdir, 2, 3L, 4L, 0L, FsPermission.getDirDefault(), "", "", null, PATH);
    }

    @Test
    public void constructorBlank() throws IOException {
        FileStatus fileStatus = new FileStatus();
        this.validateAccessors(fileStatus, 0L, false, 0, 0L, 0L, 0L, FsPermission.getFileDefault(), "", "", null, null);
    }

    @Test
    public void testEquals() {
        Path path = new Path("path");
        FileStatus fileStatus1 = new FileStatus(1L, true, 1, 1L, 1L, 1L, FsPermission.valueOf((String)"-rw-rw-rw-"), "one", "one", null, path);
        FileStatus fileStatus2 = new FileStatus(2L, true, 2, 2L, 2L, 2L, FsPermission.valueOf((String)"---x--x--x"), "two", "two", null, path);
        Assert.assertEquals((Object)fileStatus1, (Object)fileStatus2);
    }

    @Test
    public void testNotEquals() {
        Path path1 = new Path("path1");
        Path path2 = new Path("path2");
        FileStatus fileStatus1 = new FileStatus(1L, true, 1, 1L, 1L, 1L, FsPermission.valueOf((String)"-rw-rw-rw-"), "one", "one", null, path1);
        FileStatus fileStatus2 = new FileStatus(1L, true, 1, 1L, 1L, 1L, FsPermission.valueOf((String)"-rw-rw-rw-"), "one", "one", null, path2);
        Assert.assertFalse((boolean)fileStatus1.equals((Object)fileStatus2));
        Assert.assertFalse((boolean)fileStatus2.equals((Object)fileStatus1));
    }

    @Test
    public void toStringFile() throws IOException {
        boolean isdir = false;
        FileStatus fileStatus = new FileStatus(1L, isdir, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, null, PATH);
        this.validateToString(fileStatus);
    }

    @Test
    public void toStringDir() throws IOException {
        FileStatus fileStatus = new FileStatus(1L, true, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, null, PATH);
        this.validateToString(fileStatus);
    }

    @Test
    public void testCompareTo() throws IOException {
        FileStatus fileStatus2;
        Path path1 = new Path("path1");
        Path path2 = new Path("path2");
        FileStatus fileStatus1 = new FileStatus(1L, true, 1, 1L, 1L, 1L, FsPermission.valueOf((String)"-rw-rw-rw-"), "one", "one", null, path1);
        Assert.assertTrue((fileStatus1.compareTo(fileStatus2 = new FileStatus(1L, true, 1, 1L, 1L, 1L, FsPermission.valueOf((String)"-rw-rw-rw-"), "one", "one", null, path2)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((fileStatus2.compareTo(fileStatus1) > 0 ? 1 : 0) != 0);
        ArrayList<FileStatus> statList = new ArrayList<FileStatus>();
        statList.add(fileStatus1);
        statList.add(fileStatus2);
        Assert.assertTrue((Collections.binarySearch(statList, fileStatus1) > -1 ? 1 : 0) != 0);
    }

    @Test
    public void toStringSymlink() throws IOException {
        boolean isdir = false;
        Path symlink = new Path("symlink");
        FileStatus fileStatus = new FileStatus(1L, isdir, 2, 3L, 4L, 5L, PERMISSION, OWNER, GROUP, symlink, PATH);
        this.validateToString(fileStatus);
    }

    private void validateAccessors(FileStatus fileStatus, long length, boolean isdir, int replication, long blocksize, long mtime, long atime, FsPermission permission, String owner, String group, Path symlink, Path path) throws IOException {
        Assert.assertEquals((long)length, (long)fileStatus.getLen());
        Assert.assertEquals((Object)isdir, (Object)fileStatus.isDirectory());
        Assert.assertEquals((long)replication, (long)fileStatus.getReplication());
        Assert.assertEquals((long)blocksize, (long)fileStatus.getBlockSize());
        Assert.assertEquals((long)mtime, (long)fileStatus.getModificationTime());
        Assert.assertEquals((long)atime, (long)fileStatus.getAccessTime());
        Assert.assertEquals((Object)permission, (Object)fileStatus.getPermission());
        Assert.assertEquals((Object)owner, (Object)fileStatus.getOwner());
        Assert.assertEquals((Object)group, (Object)fileStatus.getGroup());
        if (symlink == null) {
            Assert.assertFalse((boolean)fileStatus.isSymlink());
        } else {
            Assert.assertTrue((boolean)fileStatus.isSymlink());
            Assert.assertEquals((Object)symlink, (Object)fileStatus.getSymlink());
        }
        Assert.assertEquals((Object)path, (Object)fileStatus.getPath());
    }

    private void validateToString(FileStatus fileStatus) throws IOException {
        StringBuilder expected = new StringBuilder();
        expected.append("FileStatus{");
        expected.append("path=").append(fileStatus.getPath()).append("; ");
        expected.append("isDirectory=").append(fileStatus.isDirectory()).append("; ");
        if (!fileStatus.isDirectory()) {
            expected.append("length=").append(fileStatus.getLen()).append("; ");
            expected.append("replication=").append(fileStatus.getReplication()).append("; ");
            expected.append("blocksize=").append(fileStatus.getBlockSize()).append("; ");
        }
        expected.append("modification_time=").append(fileStatus.getModificationTime()).append("; ");
        expected.append("access_time=").append(fileStatus.getAccessTime()).append("; ");
        expected.append("owner=").append(fileStatus.getOwner()).append("; ");
        expected.append("group=").append(fileStatus.getGroup()).append("; ");
        expected.append("permission=").append(fileStatus.getPermission()).append("; ");
        if (fileStatus.isSymlink()) {
            expected.append("isSymlink=").append(true).append("; ");
            expected.append("symlink=").append(fileStatus.getSymlink()).append("}");
        } else {
            expected.append("isSymlink=").append(false).append("}");
        }
        Assert.assertEquals((Object)expected.toString(), (Object)fileStatus.toString());
    }
}

