/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMetricsRegistry {
    @Test
    public void testNewMetrics() {
        final MetricsRegistry r = new MetricsRegistry("test");
        r.newCounter("c1", "c1 desc", 1);
        r.newCounter("c2", "c2 desc", 2L);
        r.newGauge("g1", "g1 desc", 3);
        r.newGauge("g2", "g2 desc", 4L);
        r.newStat("s1", "s1 desc", "ops", "time");
        Assert.assertEquals((String)"num metrics in registry", (long)5L, (long)r.metrics().size());
        Assert.assertTrue((String)"c1 found", (boolean)(r.get("c1") instanceof MutableCounterInt));
        Assert.assertTrue((String)"c2 found", (boolean)(r.get("c2") instanceof MutableCounterLong));
        Assert.assertTrue((String)"g1 found", (boolean)(r.get("g1") instanceof MutableGaugeInt));
        Assert.assertTrue((String)"g2 found", (boolean)(r.get("g2") instanceof MutableGaugeLong));
        Assert.assertTrue((String)"s1 found", (boolean)(r.get("s1") instanceof MutableStat));
        this.expectMetricsException("Metric name c1 already exists", new Runnable(){

            @Override
            public void run() {
                r.newCounter("c1", "test dup", 0);
            }
        });
    }

    @Test
    public void testMetricsRegistryIllegalMetricNames() {
        final MetricsRegistry r = new MetricsRegistry("test");
        r.newCounter("c1", "c1 desc", 1);
        r.newGauge("g1", "g1 desc", 1);
        r.newQuantiles("q1", "q1 desc", "q1 name", "q1 val type", 1);
        this.expectMetricsException("Metric name 'badcount 2' contains illegal whitespace character", new Runnable(){

            @Override
            public void run() {
                r.newCounter("badcount 2", "c2 desc", 2);
            }
        });
        this.expectMetricsException("Metric name 'badcount3  ' contains illegal whitespace character", new Runnable(){

            @Override
            public void run() {
                r.newCounter("badcount3  ", "c3 desc", 3);
            }
        });
        this.expectMetricsException("Metric name '  badcount4' contains illegal whitespace character", new Runnable(){

            @Override
            public void run() {
                r.newCounter("  badcount4", "c4 desc", 4);
            }
        });
        this.expectMetricsException("Metric name 'withtab5\t' contains illegal whitespace character", new Runnable(){

            @Override
            public void run() {
                r.newCounter("withtab5\t", "c5 desc", 5);
            }
        });
        this.expectMetricsException("Metric name 'withnewline6\n' contains illegal whitespace character", new Runnable(){

            @Override
            public void run() {
                r.newCounter("withnewline6\n", "c6 desc", 6);
            }
        });
        Assert.assertEquals((String)"num metrics in registry", (long)3L, (long)r.metrics().size());
    }

    @Test
    public void testAddByName() {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        final MetricsRegistry r = new MetricsRegistry("test");
        r.add("s1", 42L);
        r.get("s1").snapshot(rb);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for s1"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"S1AvgTime", (String)"Average time for s1"), 42.0);
        r.newCounter("c1", "test add", 1);
        r.newGauge("g1", "test add", 1);
        this.expectMetricsException("Unsupported add", new Runnable(){

            @Override
            public void run() {
                r.add("c1", 42L);
            }
        });
        this.expectMetricsException("Unsupported add", new Runnable(){

            @Override
            public void run() {
                r.add("g1", 42L);
            }
        });
    }

    @Test
    public void testAddIllegalParameters() {
        final MetricsRegistry r = new MetricsRegistry("IllegalParamTest");
        this.expectMetricsException("Interval should be positive.  Value passed is: -20", new Runnable(){

            @Override
            public void run() {
                r.newQuantiles("q1", "New Quantile 1", "qq1", "qv1", -20);
            }
        });
    }

    @Ignore
    private void expectMetricsException(String prefix, Runnable fun) {
        try {
            fun.run();
        }
        catch (MetricsException e) {
            Assert.assertTrue((String)"expected exception", (boolean)e.getMessage().startsWith(prefix));
            return;
        }
        Assert.fail((String)("should've thrown '" + prefix + "...'"));
    }
}

