/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;

public class DataNodeTestUtils {
    private static final Log LOG = LogFactory.getLog(DataNodeTestUtils.class);
    private static final String DIR_FAILURE_SUFFIX = ".origin";
    public static final String TEST_CLUSTER_ID = "testClusterID";
    public static final String TEST_POOL_ID = "BP-TEST";

    public static DatanodeRegistration getDNRegistrationForBP(DataNode dn, String bpid) throws IOException {
        return dn.getDNRegistrationForBP(bpid);
    }

    public static void setHeartbeatsDisabledForTests(DataNode dn, boolean heartbeatsDisabledForTests) {
        dn.setHeartbeatsDisabledForTests(heartbeatsDisabledForTests);
    }

    public static void setCacheReportsDisabledForTests(MiniDFSCluster cluster, boolean disabled) {
        for (DataNode dn : cluster.getDataNodes()) {
            dn.setCacheReportsDisabledForTest(disabled);
        }
    }

    public static void triggerDeletionReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerDeletionReportForTests();
        }
    }

    public static void triggerHeartbeat(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerHeartbeatForTests();
        }
    }

    public static void triggerBlockReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerBlockReportForTests();
        }
    }

    public static InterDatanodeProtocol createInterDatanodeProtocolProxy(DataNode dn, DatanodeID datanodeid, Configuration conf, boolean connectToDnViaHostname) throws IOException {
        if (connectToDnViaHostname != dn.getDnConf().connectToDnViaHostname) {
            throw new AssertionError((Object)"Unexpected DN hostname configuration");
        }
        return DataNode.createInterDataNodeProtocolProxy((DatanodeID)datanodeid, (Configuration)conf, (int)dn.getDnConf().socketTimeout, (boolean)dn.getDnConf().connectToDnViaHostname);
    }

    public static FsDatasetSpi<?> getFSDataset(DataNode dn) {
        return dn.getFSDataset();
    }

    public static ReplicaInfo fetchReplicaInfo(DataNode dn, String bpid, long blkId) {
        return FsDatasetTestUtil.fetchReplicaInfo(dn.getFSDataset(), bpid, blkId);
    }

    public static void injectDataDirFailure(File ... dirs) throws IOException {
        for (File dir : dirs) {
            File renamedTo = new File(dir.getPath() + DIR_FAILURE_SUFFIX);
            if (renamedTo.exists()) {
                throw new IOException(String.format("Can not inject failure to dir: %s because %s exists.", dir, renamedTo));
            }
            if (!dir.renameTo(renamedTo)) {
                throw new IOException(String.format("Failed to rename %s to %s.", dir, renamedTo));
            }
            if (dir.createNewFile()) continue;
            throw new IOException(String.format("Failed to create file %s to inject disk failure.", dir));
        }
    }

    public static void restoreDataDirFromFailure(File ... dirs) throws IOException {
        for (File dir : dirs) {
            File renamedDir = new File(dir.getPath() + DIR_FAILURE_SUFFIX);
            if (!renamedDir.exists()) continue;
            if (dir.exists()) {
                if (!dir.isFile()) {
                    throw new IOException("Injected failure data dir is supposed to be file: " + dir);
                }
                if (!dir.delete()) {
                    throw new IOException("Failed to delete injected failure data dir: " + dir);
                }
            }
            if (renamedDir.renameTo(dir)) continue;
            throw new IOException(String.format("Failed to recover injected failure data dir %s to %s.", renamedDir, dir));
        }
    }

    public static void runDirectoryScanner(DataNode dn) throws IOException {
        DirectoryScanner directoryScanner = dn.getDirectoryScanner();
        if (directoryScanner != null) {
            dn.getDirectoryScanner().reconcile();
        }
    }

    public static void reconfigureDataNode(DataNode dn, File ... newVols) throws Exception {
        StringBuilder dnNewDataDirs = new StringBuilder();
        for (File newVol : newVols) {
            if (dnNewDataDirs.length() > 0) {
                dnNewDataDirs.append(',');
            }
            dnNewDataDirs.append(newVol.getAbsolutePath());
        }
        try {
            Assert.assertThat((Object)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", dnNewDataDirs.toString()), (Matcher)Is.is((Object)dn.getConf().get("dfs.datanode.data.dir")));
        }
        catch (ReconfigurationException e) {
            LOG.warn((Object)"Could not reconfigure DataNode.", (Throwable)e);
        }
    }

    public static FsVolumeImpl getVolume(DataNode dn, File basePath) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = dn.getFSDataset().getFsVolumeReferences();){
            Iterator i$ = volumes.iterator();
            if (i$.hasNext()) {
                FsVolumeSpi vol = (FsVolumeSpi)i$.next();
                FsVolumeImpl fsVolumeImpl = (FsVolumeImpl)vol;
                return fsVolumeImpl;
            }
        }
        return null;
    }

    public static void waitForDiskError(final DataNode dn, FsVolumeSpi volume) throws Exception {
        LOG.info((Object)"Starting to wait for datanode to detect disk failure.");
        final long lastDiskErrorCheck = dn.getLastDiskErrorCheck();
        dn.checkDiskErrorAsync(volume);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return dn.getLastDiskErrorCheck() != lastDiskErrorCheck;
            }
        }, (int)100, (int)10000);
    }
}

